/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityIdentifier> {
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(EntityIdentifier.getter(EntityIdentifier::entityType)).setter(EntityIdentifier.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(EntityIdentifier.getter(EntityIdentifier::entityId)).setter(EntityIdentifier.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPE_FIELD, ENTITY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityType;
    private final String entityId;

    private EntityIdentifier(BuilderImpl builder) {
        this.entityType = builder.entityType;
        this.entityId = builder.entityId;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String entityId() {
        return this.entityId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityIdentifier)) {
            return false;
        }
        EntityIdentifier other = (EntityIdentifier)obj;
        return Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.entityId(), other.entityId());
    }

    public final String toString() {
        return ToString.builder((String)"EntityIdentifier").add("EntityType", (Object)(this.entityType() == null ? null : "*** Sensitive Data Redacted ***")).add("EntityId", (Object)(this.entityId() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityIdentifier, T> g) {
        return obj -> g.apply((EntityIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityType;
        private String entityId;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityIdentifier model) {
            this.entityType(model.entityType);
            this.entityId(model.entityId);
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityIdentifier build() {
            return new EntityIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityIdentifier> {
        public Builder entityType(String var1);

        public Builder entityId(String var1);
    }
}

