/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an action for a request for which an authorization decision is made.
 * </p>
 * <p>
 * This data type is used as a request parameter to the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a
 * href
 * ="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized
 * </a>, and <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html"
 * >IsAuthorizedWithToken</a> operations.
 * </p>
 * <p>
 * Example: <code>{ "actionId": "&lt;action name&gt;", "actionType": "Action" }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionIdentifier.Builder, ActionIdentifier> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(ActionIdentifier::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(ActionIdentifier::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            ACTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("actionType", ACTION_TYPE_FIELD);
                    put("actionId", ACTION_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final String actionId;

    private ActionIdentifier(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.actionId = builder.actionId;
    }

    /**
     * <p>
     * The type of an action.
     * </p>
     * 
     * @return The type of an action.
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * <p>
     * The ID of an action.
     * </p>
     * 
     * @return The ID of an action.
     */
    public final String actionId() {
        return actionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionIdentifier)) {
            return false;
        }
        ActionIdentifier other = (ActionIdentifier) obj;
        return Objects.equals(actionType(), other.actionType()) && Objects.equals(actionId(), other.actionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionIdentifier")
                .add("ActionType", actionType() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ActionId", actionId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActionIdentifier, T> g) {
        return obj -> g.apply((ActionIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionIdentifier> {
        /**
         * <p>
         * The type of an action.
         * </p>
         * 
         * @param actionType
         *        The type of an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The ID of an action.
         * </p>
         * 
         * @param actionId
         *        The ID of an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private String actionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionIdentifier model) {
            actionType(model.actionType);
            actionId(model.actionId);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        @Override
        public ActionIdentifier build() {
            return new ActionIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
