/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information about an error resulting from a <code>BatchGetPolicy</code> API call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetPolicyErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetPolicyErrorItem.Builder, BatchGetPolicyErrorItem> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(BatchGetPolicyErrorItem::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(BatchGetPolicyErrorItem::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyId").getter(getter(BatchGetPolicyErrorItem::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchGetPolicyErrorItem::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD,
            POLICY_STORE_ID_FIELD, POLICY_ID_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("code", CODE_FIELD);
                    put("policyStoreId", POLICY_STORE_ID_FIELD);
                    put("policyId", POLICY_ID_FIELD);
                    put("message", MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String policyStoreId;

    private final String policyId;

    private final String message;

    private BatchGetPolicyErrorItem(BuilderImpl builder) {
        this.code = builder.code;
        this.policyStoreId = builder.policyStoreId;
        this.policyId = builder.policyId;
        this.message = builder.message;
    }

    /**
     * <p>
     * The error code that was returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link BatchGetPolicyErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code that was returned.
     * @see BatchGetPolicyErrorCode
     */
    public final BatchGetPolicyErrorCode code() {
        return BatchGetPolicyErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code that was returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link BatchGetPolicyErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code that was returned.
     * @see BatchGetPolicyErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The identifier of the policy store associated with the failed request.
     * </p>
     * 
     * @return The identifier of the policy store associated with the failed request.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * The identifier of the policy associated with the failed request.
     * </p>
     * 
     * @return The identifier of the policy associated with the failed request.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * A detailed error message.
     * </p>
     * 
     * @return A detailed error message.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPolicyErrorItem)) {
            return false;
        }
        BatchGetPolicyErrorItem other = (BatchGetPolicyErrorItem) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(policyId(), other.policyId()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetPolicyErrorItem").add("Code", codeAsString()).add("PolicyStoreId", policyStoreId())
                .add("PolicyId", policyId()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "policyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPolicyErrorItem, T> g) {
        return obj -> g.apply((BatchGetPolicyErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetPolicyErrorItem> {
        /**
         * <p>
         * The error code that was returned.
         * </p>
         * 
         * @param code
         *        The error code that was returned.
         * @see BatchGetPolicyErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchGetPolicyErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code that was returned.
         * </p>
         * 
         * @param code
         *        The error code that was returned.
         * @see BatchGetPolicyErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchGetPolicyErrorCode
         */
        Builder code(BatchGetPolicyErrorCode code);

        /**
         * <p>
         * The identifier of the policy store associated with the failed request.
         * </p>
         * 
         * @param policyStoreId
         *        The identifier of the policy store associated with the failed request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * The identifier of the policy associated with the failed request.
         * </p>
         * 
         * @param policyId
         *        The identifier of the policy associated with the failed request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * A detailed error message.
         * </p>
         * 
         * @param message
         *        A detailed error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String policyStoreId;

        private String policyId;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPolicyErrorItem model) {
            code(model.code);
            policyStoreId(model.policyStoreId);
            policyId(model.policyId);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(BatchGetPolicyErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchGetPolicyErrorItem build() {
            return new BatchGetPolicyErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
