/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchIsAuthorizedRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<BatchIsAuthorizedRequest.Builder, BatchIsAuthorizedRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(BatchIsAuthorizedRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<EntitiesDefinition> ENTITIES_FIELD = SdkField
            .<EntitiesDefinition> builder(MarshallingType.SDK_POJO).memberName("entities")
            .getter(getter(BatchIsAuthorizedRequest::entities)).setter(setter(Builder::entities))
            .constructor(EntitiesDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build()).build();

    private static final SdkField<List<BatchIsAuthorizedInputItem>> REQUESTS_FIELD = SdkField
            .<List<BatchIsAuthorizedInputItem>> builder(MarshallingType.LIST)
            .memberName("requests")
            .getter(getter(BatchIsAuthorizedRequest::requests))
            .setter(setter(Builder::requests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchIsAuthorizedInputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchIsAuthorizedInputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            ENTITIES_FIELD, REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("policyStoreId", POLICY_STORE_ID_FIELD);
                    put("entities", ENTITIES_FIELD);
                    put("requests", REQUESTS_FIELD);
                }
            });

    private final String policyStoreId;

    private final EntitiesDefinition entities;

    private final List<BatchIsAuthorizedInputItem> requests;

    private BatchIsAuthorizedRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.entities = builder.entities;
        this.requests = builder.requests;
    }

    /**
     * <p>
     * Specifies the ID of the policy store. Policies in this policy store will be used to make the authorization
     * decisions for the input.
     * </p>
     * 
     * @return Specifies the ID of the policy store. Policies in this policy store will be used to make the
     *         authorization decisions for the input.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the list of resources and principals and their associated attributes that Verified Permissions can
     * examine when evaluating the policies.
     * </p>
     * <note>
     * <p>
     * You can include only principal and resource entities in this parameter; you can't include actions. You must
     * specify actions in the schema.
     * </p>
     * </note>
     * 
     * @return Specifies the list of resources and principals and their associated attributes that Verified Permissions
     *         can examine when evaluating the policies. </p> <note>
     *         <p>
     *         You can include only principal and resource entities in this parameter; you can't include actions. You
     *         must specify actions in the schema.
     *         </p>
     */
    public final EntitiesDefinition entities() {
        return entities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Requests property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRequests() {
        return requests != null && !(requests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to 30 requests that you want Verified Permissions to evaluate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequests} method.
     * </p>
     * 
     * @return An array of up to 30 requests that you want Verified Permissions to evaluate.
     */
    public final List<BatchIsAuthorizedInputItem> requests() {
        return requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(entities());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequests() ? requests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedRequest)) {
            return false;
        }
        BatchIsAuthorizedRequest other = (BatchIsAuthorizedRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(entities(), other.entities())
                && hasRequests() == other.hasRequests() && Objects.equals(requests(), other.requests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchIsAuthorizedRequest").add("PolicyStoreId", policyStoreId()).add("Entities", entities())
                .add("Requests", hasRequests() ? requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "requests":
            return Optional.ofNullable(clazz.cast(requests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedRequest, T> g) {
        return obj -> g.apply((BatchIsAuthorizedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchIsAuthorizedRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store. Policies in this policy store will be used to make the authorization
         * decisions for the input.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store. Policies in this policy store will be used to make the
         *        authorization decisions for the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the list of resources and principals and their associated attributes that Verified Permissions can
         * examine when evaluating the policies.
         * </p>
         * <note>
         * <p>
         * You can include only principal and resource entities in this parameter; you can't include actions. You must
         * specify actions in the schema.
         * </p>
         * </note>
         * 
         * @param entities
         *        Specifies the list of resources and principals and their associated attributes that Verified
         *        Permissions can examine when evaluating the policies. </p> <note>
         *        <p>
         *        You can include only principal and resource entities in this parameter; you can't include actions. You
         *        must specify actions in the schema.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(EntitiesDefinition entities);

        /**
         * <p>
         * Specifies the list of resources and principals and their associated attributes that Verified Permissions can
         * examine when evaluating the policies.
         * </p>
         * <note>
         * <p>
         * You can include only principal and resource entities in this parameter; you can't include actions. You must
         * specify actions in the schema.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link EntitiesDefinition.Builder}
         * avoiding the need to create one manually via {@link EntitiesDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntitiesDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(EntitiesDefinition)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link EntitiesDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(EntitiesDefinition)
         */
        default Builder entities(Consumer<EntitiesDefinition.Builder> entities) {
            return entities(EntitiesDefinition.builder().applyMutation(entities).build());
        }

        /**
         * <p>
         * An array of up to 30 requests that you want Verified Permissions to evaluate.
         * </p>
         * 
         * @param requests
         *        An array of up to 30 requests that you want Verified Permissions to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requests(Collection<BatchIsAuthorizedInputItem> requests);

        /**
         * <p>
         * An array of up to 30 requests that you want Verified Permissions to evaluate.
         * </p>
         * 
         * @param requests
         *        An array of up to 30 requests that you want Verified Permissions to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requests(BatchIsAuthorizedInputItem... requests);

        /**
         * <p>
         * An array of up to 30 requests that you want Verified Permissions to evaluate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedInputItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedInputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedInputItem.Builder#build()}
         * is called immediately and its result is passed to {@link #requests(List<BatchIsAuthorizedInputItem>)}.
         * 
         * @param requests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedInputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requests(java.util.Collection<BatchIsAuthorizedInputItem>)
         */
        Builder requests(Consumer<BatchIsAuthorizedInputItem.Builder>... requests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private EntitiesDefinition entities;

        private List<BatchIsAuthorizedInputItem> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            entities(model.entities);
            requests(model.requests);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final EntitiesDefinition.Builder getEntities() {
            return entities != null ? entities.toBuilder() : null;
        }

        public final void setEntities(EntitiesDefinition.BuilderImpl entities) {
            this.entities = entities != null ? entities.build() : null;
        }

        @Override
        public final Builder entities(EntitiesDefinition entities) {
            this.entities = entities;
            return this;
        }

        public final List<BatchIsAuthorizedInputItem.Builder> getRequests() {
            List<BatchIsAuthorizedInputItem.Builder> result = BatchIsAuthorizedInputListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<BatchIsAuthorizedInputItem.BuilderImpl> requests) {
            this.requests = BatchIsAuthorizedInputListCopier.copyFromBuilder(requests);
        }

        @Override
        public final Builder requests(Collection<BatchIsAuthorizedInputItem> requests) {
            this.requests = BatchIsAuthorizedInputListCopier.copy(requests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(BatchIsAuthorizedInputItem... requests) {
            requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(Consumer<BatchIsAuthorizedInputItem.Builder>... requests) {
            requests(Stream.of(requests).map(c -> BatchIsAuthorizedInputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchIsAuthorizedRequest build() {
            return new BatchIsAuthorizedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
