/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePolicyRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<CreatePolicyRequest.Builder, CreatePolicyRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(CreatePolicyRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<PolicyDefinition> DEFINITION_FIELD = SdkField
            .<PolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(CreatePolicyRequest::definition)).setter(setter(Builder::definition))
            .constructor(PolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            POLICY_STORE_ID_FIELD, DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("policyStoreId", POLICY_STORE_ID_FIELD);
                    put("definition", DEFINITION_FIELD);
                }
            });

    private final String clientToken;

    private final String policyStoreId;

    private final PolicyDefinition definition;

    private CreatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.policyStoreId = builder.policyStoreId;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you
     * safely retry the request without accidentally performing the same operation a second time. Passing the same value
     * to a later call to an operation requires that you also pass the same value for all other parameters. We recommend
     * that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>ConflictException</code> error.
     * </p>
     * <p>
     * Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next request
     * with the same parameters performs the operation again regardless of the value of <code>ClientToken</code>.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
     *         lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>ConflictException</code> error.
     *         </p>
     *         <p>
     *         Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next
     *         request with the same parameters performs the operation again regardless of the value of
     *         <code>ClientToken</code>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
     * </p>
     * 
     * @return Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * A structure that specifies the policy type and content to use for the new policy. You must include either a
     * static or a templateLinked element. The policy content must be written in the Cedar policy language.
     * </p>
     * 
     * @return A structure that specifies the policy type and content to use for the new policy. You must include either
     *         a static or a templateLinked element. The policy content must be written in the Cedar policy language.
     */
    public final PolicyDefinition definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePolicyRequest").add("ClientToken", clientToken()).add("PolicyStoreId", policyStoreId())
                .add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyRequest, T> g) {
        return obj -> g.apply((CreatePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePolicyRequest> {
        /**
         * <p>
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets
         * you safely retry the request without accidentally performing the same operation a second time. Passing the
         * same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>ConflictException</code> error.
         * </p>
         * <p>
         * Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next
         * request with the same parameters performs the operation again regardless of the value of
         * <code>ClientToken</code>.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
         *        lets you safely retry the request without accidentally performing the same operation a second time.
         *        Passing the same value to a later call to an operation requires that you also pass the same value for
         *        all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>ConflictException</code> error.
         *        </p>
         *        <p>
         *        Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the
         *        next request with the same parameters performs the operation again regardless of the value of
         *        <code>ClientToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * A structure that specifies the policy type and content to use for the new policy. You must include either a
         * static or a templateLinked element. The policy content must be written in the Cedar policy language.
         * </p>
         * 
         * @param definition
         *        A structure that specifies the policy type and content to use for the new policy. You must include
         *        either a static or a templateLinked element. The policy content must be written in the Cedar policy
         *        language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(PolicyDefinition definition);

        /**
         * <p>
         * A structure that specifies the policy type and content to use for the new policy. You must include either a
         * static or a templateLinked element. The policy content must be written in the Cedar policy language.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyDefinition.Builder} avoiding the
         * need to create one manually via {@link PolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(PolicyDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link PolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(PolicyDefinition)
         */
        default Builder definition(Consumer<PolicyDefinition.Builder> definition) {
            return definition(PolicyDefinition.builder().applyMutation(definition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String policyStoreId;

        private PolicyDefinition definition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyRequest model) {
            super(model);
            clientToken(model.clientToken);
            policyStoreId(model.policyStoreId);
            definition(model.definition);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final PolicyDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(PolicyDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PolicyDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyRequest build() {
            return new CreatePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
