/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a principal or resource that can be referenced in a Cedar policy.
 * </p>
 * <p>
 * This data type is used as part of the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyFilter.html">PolicyFilter</a>
 * structure that is used as a request parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a>
 * operation..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityReference implements SdkPojo, Serializable, ToCopyableBuilder<EntityReference.Builder, EntityReference> {
    private static final SdkField<Boolean> UNSPECIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unspecified").getter(getter(EntityReference::unspecified)).setter(setter(Builder::unspecified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unspecified").build()).build();

    private static final SdkField<EntityIdentifier> IDENTIFIER_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("identifier")
            .getter(getter(EntityReference::identifier)).setter(setter(Builder::identifier))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNSPECIFIED_FIELD,
            IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("unspecified", UNSPECIFIED_FIELD);
                    put("identifier", IDENTIFIER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean unspecified;

    private final EntityIdentifier identifier;

    private final Type type;

    private EntityReference(BuilderImpl builder) {
        this.unspecified = builder.unspecified;
        this.identifier = builder.identifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * Used to indicate that a principal or resource is not specified. This can be used to search for policies that are
     * not associated with a specific principal or resource.
     * </p>
     * 
     * @return Used to indicate that a principal or resource is not specified. This can be used to search for policies
     *         that are not associated with a specific principal or resource.
     */
    public final Boolean unspecified() {
        return unspecified;
    }

    /**
     * <p>
     * The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a resource.
     * </p>
     * 
     * @return The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a
     *         resource.
     */
    public final EntityIdentifier identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unspecified());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityReference)) {
            return false;
        }
        EntityReference other = (EntityReference) obj;
        return Objects.equals(unspecified(), other.unspecified()) && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityReference").add("Unspecified", unspecified()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unspecified":
            return Optional.ofNullable(clazz.cast(unspecified()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #unspecified()} initialized to the given value.
     *
     * <p>
     * Used to indicate that a principal or resource is not specified. This can be used to search for policies that are
     * not associated with a specific principal or resource.
     * </p>
     * 
     * @param unspecified
     *        Used to indicate that a principal or resource is not specified. This can be used to search for policies
     *        that are not associated with a specific principal or resource.
     */
    public static EntityReference fromUnspecified(Boolean unspecified) {
        return builder().unspecified(unspecified).build();
    }

    /**
     * Create an instance of this class with {@link #identifier()} initialized to the given value.
     *
     * <p>
     * The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a resource.
     * </p>
     * 
     * @param identifier
     *        The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a
     *        resource.
     */
    public static EntityReference fromIdentifier(EntityIdentifier identifier) {
        return builder().identifier(identifier).build();
    }

    /**
     * Create an instance of this class with {@link #identifier()} initialized to the given value.
     *
     * <p>
     * The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a resource.
     * </p>
     * 
     * @param identifier
     *        The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a
     *        resource.
     */
    public static EntityReference fromIdentifier(Consumer<EntityIdentifier.Builder> identifier) {
        EntityIdentifier.Builder builder = EntityIdentifier.builder();
        identifier.accept(builder);
        return fromIdentifier(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EntityReference, T> g) {
        return obj -> g.apply((EntityReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityReference> {
        /**
         * <p>
         * Used to indicate that a principal or resource is not specified. This can be used to search for policies that
         * are not associated with a specific principal or resource.
         * </p>
         * 
         * @param unspecified
         *        Used to indicate that a principal or resource is not specified. This can be used to search for
         *        policies that are not associated with a specific principal or resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unspecified(Boolean unspecified);

        /**
         * <p>
         * The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a
         * resource.
         * </p>
         * 
         * @param identifier
         *        The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(EntityIdentifier identifier);

        /**
         * <p>
         * The identifier of the entity. It can consist of either an EntityType and EntityId, a principal, or a
         * resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #identifier(EntityIdentifier)}.
         * 
         * @param identifier
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifier(EntityIdentifier)
         */
        default Builder identifier(Consumer<EntityIdentifier.Builder> identifier) {
            return identifier(EntityIdentifier.builder().applyMutation(identifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean unspecified;

        private EntityIdentifier identifier;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntityReference model) {
            unspecified(model.unspecified);
            identifier(model.identifier);
        }

        public final Boolean getUnspecified() {
            return unspecified;
        }

        public final void setUnspecified(Boolean unspecified) {
            Object oldValue = this.unspecified;
            this.unspecified = unspecified;
            handleUnionValueChange(Type.UNSPECIFIED, oldValue, this.unspecified);
        }

        @Override
        public final Builder unspecified(Boolean unspecified) {
            Object oldValue = this.unspecified;
            this.unspecified = unspecified;
            handleUnionValueChange(Type.UNSPECIFIED, oldValue, this.unspecified);
            return this;
        }

        public final EntityIdentifier.Builder getIdentifier() {
            return identifier != null ? identifier.toBuilder() : null;
        }

        public final void setIdentifier(EntityIdentifier.BuilderImpl identifier) {
            Object oldValue = this.identifier;
            this.identifier = identifier != null ? identifier.build() : null;
            handleUnionValueChange(Type.IDENTIFIER, oldValue, this.identifier);
        }

        @Override
        public final Builder identifier(EntityIdentifier identifier) {
            Object oldValue = this.identifier;
            this.identifier = identifier;
            handleUnionValueChange(Type.IDENTIFIER, oldValue, this.identifier);
            return this;
        }

        @Override
        public EntityReference build() {
            return new EntityReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EntityReference#type()
     */
    public enum Type {
        UNSPECIFIED,

        IDENTIFIER,

        UNKNOWN_TO_SDK_VERSION
    }
}
