/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a description of an evaluation error.
 * </p>
 * <p>
 * This data type is a response parameter of the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a
 * href
 * ="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized
 * </a>, and <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html"
 * >IsAuthorizedWithToken</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationErrorItem.Builder, EvaluationErrorItem> {
    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDescription").getter(getter(EvaluationErrorItem::errorDescription))
            .setter(setter(Builder::errorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("errorDescription", ERROR_DESCRIPTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String errorDescription;

    private EvaluationErrorItem(BuilderImpl builder) {
        this.errorDescription = builder.errorDescription;
    }

    /**
     * <p>
     * The error description.
     * </p>
     * 
     * @return The error description.
     */
    public final String errorDescription() {
        return errorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationErrorItem)) {
            return false;
        }
        EvaluationErrorItem other = (EvaluationErrorItem) obj;
        return Objects.equals(errorDescription(), other.errorDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationErrorItem").add("ErrorDescription", errorDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorDescription":
            return Optional.ofNullable(clazz.cast(errorDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationErrorItem, T> g) {
        return obj -> g.apply((EvaluationErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationErrorItem> {
        /**
         * <p>
         * The error description.
         * </p>
         * 
         * @param errorDescription
         *        The error description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDescription(String errorDescription);
    }

    static final class BuilderImpl implements Builder {
        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationErrorItem model) {
            errorDescription(model.errorDescription);
        }

        public final String getErrorDescription() {
            return errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public EvaluationErrorItem build() {
            return new EvaluationErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
