/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains configuration of the identity source.
 * </p>
 * <p>
 * This data type was a response parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html"
 * >GetIdentitySource</a> operation. Replaced by <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html"
 * >ConfigurationDetail</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentitySourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentitySourceDetails.Builder, IdentitySourceDetails> {
    private static final SdkField<List<String>> CLIENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clientIds")
            .getter(getter(IdentitySourceDetails::clientIds))
            .setter(setter(Builder::clientIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userPoolArn").getter(getter(IdentitySourceDetails::userPoolArn)).setter(setter(Builder::userPoolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolArn").build()).build();

    private static final SdkField<String> DISCOVERY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("discoveryUrl").getter(getter(IdentitySourceDetails::discoveryUrl)).setter(setter(Builder::discoveryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryUrl").build()).build();

    private static final SdkField<String> OPEN_ID_ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("openIdIssuer").getter(getter(IdentitySourceDetails::openIdIssuerAsString))
            .setter(setter(Builder::openIdIssuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIdIssuer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_IDS_FIELD,
            USER_POOL_ARN_FIELD, DISCOVERY_URL_FIELD, OPEN_ID_ISSUER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clientIds", CLIENT_IDS_FIELD);
                    put("userPoolArn", USER_POOL_ARN_FIELD);
                    put("discoveryUrl", DISCOVERY_URL_FIELD);
                    put("openIdIssuer", OPEN_ID_ISSUER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> clientIds;

    private final String userPoolArn;

    private final String discoveryUrl;

    private final String openIdIssuer;

    private IdentitySourceDetails(BuilderImpl builder) {
        this.clientIds = builder.clientIds;
        this.userPoolArn = builder.userPoolArn;
        this.discoveryUrl = builder.discoveryUrl;
        this.openIdIssuer = builder.openIdIssuer;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     *
     * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.clientIds
     */
    @Deprecated
    public final boolean hasClientIds() {
        return clientIds != null && !(clientIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this
     * identity source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientIds} method.
     * </p>
     * 
     * @return The application client IDs associated with the specified Amazon Cognito user pool that are enabled for
     *         this identity source.
     * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.clientIds
     */
    @Deprecated
    public final List<String> clientIds() {
        return clientIds;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this Verified Permissions policy
     * store.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this Verified
     *         Permissions policy store.
     * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.userPoolArn
     */
    @Deprecated
    public final String userPoolArn() {
        return userPoolArn;
    }

    /**
     * <p>
     * The well-known URL that points to this user pool's OIDC discovery endpoint. This is a URL string in the following
     * format. This URL replaces the placeholders for both the Amazon Web Services Region and the user pool identifier
     * with those appropriate for this user pool.
     * </p>
     * <p>
     * <code>https://cognito-idp.<i>&lt;region&gt;</i>.amazonaws.com/<i>&lt;user-pool-id&gt;</i>/.well-known/openid-configuration</code>
     * </p>
     * 
     * @return The well-known URL that points to this user pool's OIDC discovery endpoint. This is a URL string in the
     *         following format. This URL replaces the placeholders for both the Amazon Web Services Region and the user
     *         pool identifier with those appropriate for this user pool.</p>
     *         <p>
     *         <code>https://cognito-idp.<i>&lt;region&gt;</i>.amazonaws.com/<i>&lt;user-pool-id&gt;</i>/.well-known/openid-configuration</code>
     * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.issuer
     */
    @Deprecated
    public final String discoveryUrl() {
        return discoveryUrl;
    }

    /**
     * <p>
     * A string that identifies the type of OIDC service represented by this identity source.
     * </p>
     * <p>
     * At this time, the only valid value is <code>cognito</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #openIdIssuer} will
     * return {@link OpenIdIssuer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #openIdIssuerAsString}.
     * </p>
     * 
     * @return A string that identifies the type of OIDC service represented by this identity source. </p>
     *         <p>
     *         At this time, the only valid value is <code>cognito</code>.
     * @see OpenIdIssuer
     * @deprecated This attribute has been replaced by configuration
     */
    @Deprecated
    public final OpenIdIssuer openIdIssuer() {
        return OpenIdIssuer.fromValue(openIdIssuer);
    }

    /**
     * <p>
     * A string that identifies the type of OIDC service represented by this identity source.
     * </p>
     * <p>
     * At this time, the only valid value is <code>cognito</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #openIdIssuer} will
     * return {@link OpenIdIssuer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #openIdIssuerAsString}.
     * </p>
     * 
     * @return A string that identifies the type of OIDC service represented by this identity source. </p>
     *         <p>
     *         At this time, the only valid value is <code>cognito</code>.
     * @see OpenIdIssuer
     * @deprecated This attribute has been replaced by configuration
     */
    @Deprecated
    public final String openIdIssuerAsString() {
        return openIdIssuer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClientIds() ? clientIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(openIdIssuerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceDetails)) {
            return false;
        }
        IdentitySourceDetails other = (IdentitySourceDetails) obj;
        return hasClientIds() == other.hasClientIds() && Objects.equals(clientIds(), other.clientIds())
                && Objects.equals(userPoolArn(), other.userPoolArn()) && Objects.equals(discoveryUrl(), other.discoveryUrl())
                && Objects.equals(openIdIssuerAsString(), other.openIdIssuerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentitySourceDetails")
                .add("ClientIds", clientIds() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserPoolArn", userPoolArn()).add("DiscoveryUrl", discoveryUrl())
                .add("OpenIdIssuer", openIdIssuerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientIds":
            return Optional.ofNullable(clazz.cast(clientIds()));
        case "userPoolArn":
            return Optional.ofNullable(clazz.cast(userPoolArn()));
        case "discoveryUrl":
            return Optional.ofNullable(clazz.cast(discoveryUrl()));
        case "openIdIssuer":
            return Optional.ofNullable(clazz.cast(openIdIssuerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceDetails, T> g) {
        return obj -> g.apply((IdentitySourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentitySourceDetails> {
        /**
         * <p>
         * The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this
         * identity source.
         * </p>
         * 
         * @param clientIds
         *        The application client IDs associated with the specified Amazon Cognito user pool that are enabled for
         *        this identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.clientIds
         */
        @Deprecated
        Builder clientIds(Collection<String> clientIds);

        /**
         * <p>
         * The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this
         * identity source.
         * </p>
         * 
         * @param clientIds
         *        The application client IDs associated with the specified Amazon Cognito user pool that are enabled for
         *        this identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.clientIds
         */
        @Deprecated
        Builder clientIds(String... clientIds);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this Verified Permissions policy
         * store.
         * </p>
         * 
         * @param userPoolArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this
         *        Verified Permissions policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.userPoolArn
         */
        @Deprecated
        Builder userPoolArn(String userPoolArn);

        /**
         * <p>
         * The well-known URL that points to this user pool's OIDC discovery endpoint. This is a URL string in the
         * following format. This URL replaces the placeholders for both the Amazon Web Services Region and the user
         * pool identifier with those appropriate for this user pool.
         * </p>
         * <p>
         * <code>https://cognito-idp.<i>&lt;region&gt;</i>.amazonaws.com/<i>&lt;user-pool-id&gt;</i>/.well-known/openid-configuration</code>
         * </p>
         * 
         * @param discoveryUrl
         *        The well-known URL that points to this user pool's OIDC discovery endpoint. This is a URL string in
         *        the following format. This URL replaces the placeholders for both the Amazon Web Services Region and
         *        the user pool identifier with those appropriate for this user pool.</p>
         *        <p>
         *        <code>https://cognito-idp.<i>&lt;region&gt;</i>.amazonaws.com/<i>&lt;user-pool-id&gt;</i>/.well-known/openid-configuration</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration.issuer
         */
        @Deprecated
        Builder discoveryUrl(String discoveryUrl);

        /**
         * <p>
         * A string that identifies the type of OIDC service represented by this identity source.
         * </p>
         * <p>
         * At this time, the only valid value is <code>cognito</code>.
         * </p>
         * 
         * @param openIdIssuer
         *        A string that identifies the type of OIDC service represented by this identity source. </p>
         *        <p>
         *        At this time, the only valid value is <code>cognito</code>.
         * @see OpenIdIssuer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenIdIssuer
         * @deprecated This attribute has been replaced by configuration
         */
        @Deprecated
        Builder openIdIssuer(String openIdIssuer);

        /**
         * <p>
         * A string that identifies the type of OIDC service represented by this identity source.
         * </p>
         * <p>
         * At this time, the only valid value is <code>cognito</code>.
         * </p>
         * 
         * @param openIdIssuer
         *        A string that identifies the type of OIDC service represented by this identity source. </p>
         *        <p>
         *        At this time, the only valid value is <code>cognito</code>.
         * @see OpenIdIssuer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenIdIssuer
         * @deprecated This attribute has been replaced by configuration
         */
        @Deprecated
        Builder openIdIssuer(OpenIdIssuer openIdIssuer);
    }

    static final class BuilderImpl implements Builder {
        private List<String> clientIds = DefaultSdkAutoConstructList.getInstance();

        private String userPoolArn;

        private String discoveryUrl;

        private String openIdIssuer;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceDetails model) {
            clientIds(model.clientIds);
            userPoolArn(model.userPoolArn);
            discoveryUrl(model.discoveryUrl);
            openIdIssuer(model.openIdIssuer);
        }

        @Deprecated
        public final Collection<String> getClientIds() {
            if (clientIds instanceof SdkAutoConstructList) {
                return null;
            }
            return clientIds;
        }

        @Deprecated
        public final void setClientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
        }

        @Override
        @Deprecated
        public final Builder clientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder clientIds(String... clientIds) {
            clientIds(Arrays.asList(clientIds));
            return this;
        }

        @Deprecated
        public final String getUserPoolArn() {
            return userPoolArn;
        }

        @Deprecated
        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        @Override
        @Deprecated
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        @Deprecated
        public final String getDiscoveryUrl() {
            return discoveryUrl;
        }

        @Deprecated
        public final void setDiscoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
        }

        @Override
        @Deprecated
        public final Builder discoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
            return this;
        }

        @Deprecated
        public final String getOpenIdIssuer() {
            return openIdIssuer;
        }

        @Deprecated
        public final void setOpenIdIssuer(String openIdIssuer) {
            this.openIdIssuer = openIdIssuer;
        }

        @Override
        @Deprecated
        public final Builder openIdIssuer(String openIdIssuer) {
            this.openIdIssuer = openIdIssuer;
            return this;
        }

        @Override
        @Deprecated
        public final Builder openIdIssuer(OpenIdIssuer openIdIssuer) {
            this.openIdIssuer(openIdIssuer == null ? null : openIdIssuer.toString());
            return this;
        }

        @Override
        public IdentitySourceDetails build() {
            return new IdentitySourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
