/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsAuthorizedRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<IsAuthorizedRequest.Builder, IsAuthorizedRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(IsAuthorizedRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<EntityIdentifier> PRINCIPAL_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("principal")
            .getter(getter(IsAuthorizedRequest::principal)).setter(setter(Builder::principal))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<ActionIdentifier> ACTION_FIELD = SdkField.<ActionIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(IsAuthorizedRequest::action)).setter(setter(Builder::action))
            .constructor(ActionIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<EntityIdentifier> RESOURCE_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(IsAuthorizedRequest::resource)).setter(setter(Builder::resource))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<ContextDefinition> CONTEXT_FIELD = SdkField
            .<ContextDefinition> builder(MarshallingType.SDK_POJO).memberName("context")
            .getter(getter(IsAuthorizedRequest::context)).setter(setter(Builder::context))
            .constructor(ContextDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<EntitiesDefinition> ENTITIES_FIELD = SdkField
            .<EntitiesDefinition> builder(MarshallingType.SDK_POJO).memberName("entities")
            .getter(getter(IsAuthorizedRequest::entities)).setter(setter(Builder::entities))
            .constructor(EntitiesDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            PRINCIPAL_FIELD, ACTION_FIELD, RESOURCE_FIELD, CONTEXT_FIELD, ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("policyStoreId", POLICY_STORE_ID_FIELD);
                    put("principal", PRINCIPAL_FIELD);
                    put("action", ACTION_FIELD);
                    put("resource", RESOURCE_FIELD);
                    put("context", CONTEXT_FIELD);
                    put("entities", ENTITIES_FIELD);
                }
            });

    private final String policyStoreId;

    private final EntityIdentifier principal;

    private final ActionIdentifier action;

    private final EntityIdentifier resource;

    private final ContextDefinition context;

    private final EntitiesDefinition entities;

    private IsAuthorizedRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.principal = builder.principal;
        this.action = builder.action;
        this.resource = builder.resource;
        this.context = builder.context;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization
     * decision for the input.
     * </p>
     * 
     * @return Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization
     *         decision for the input.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the principal for which the authorization decision is to be made.
     * </p>
     * 
     * @return Specifies the principal for which the authorization decision is to be made.
     */
    public final EntityIdentifier principal() {
        return principal;
    }

    /**
     * <p>
     * Specifies the requested action to be authorized. For example, is the principal authorized to perform this action
     * on the resource?
     * </p>
     * 
     * @return Specifies the requested action to be authorized. For example, is the principal authorized to perform this
     *         action on the resource?
     */
    public final ActionIdentifier action() {
        return action;
    }

    /**
     * <p>
     * Specifies the resource for which the authorization decision is to be made.
     * </p>
     * 
     * @return Specifies the resource for which the authorization decision is to be made.
     */
    public final EntityIdentifier resource() {
        return resource;
    }

    /**
     * <p>
     * Specifies additional context that can be used to make more granular authorization decisions.
     * </p>
     * 
     * @return Specifies additional context that can be used to make more granular authorization decisions.
     */
    public final ContextDefinition context() {
        return context;
    }

    /**
     * <p>
     * Specifies the list of resources and principals and their associated attributes that Verified Permissions can
     * examine when evaluating the policies.
     * </p>
     * <note>
     * <p>
     * You can include only principal and resource entities in this parameter; you can't include actions. You must
     * specify actions in the schema.
     * </p>
     * </note>
     * 
     * @return Specifies the list of resources and principals and their associated attributes that Verified Permissions
     *         can examine when evaluating the policies. </p> <note>
     *         <p>
     *         You can include only principal and resource entities in this parameter; you can't include actions. You
     *         must specify actions in the schema.
     *         </p>
     */
    public final EntitiesDefinition entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(entities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsAuthorizedRequest)) {
            return false;
        }
        IsAuthorizedRequest other = (IsAuthorizedRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(principal(), other.principal())
                && Objects.equals(action(), other.action()) && Objects.equals(resource(), other.resource())
                && Objects.equals(context(), other.context()) && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsAuthorizedRequest").add("PolicyStoreId", policyStoreId()).add("Principal", principal())
                .add("Action", action()).add("Resource", resource()).add("Context", context()).add("Entities", entities())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsAuthorizedRequest, T> g) {
        return obj -> g.apply((IsAuthorizedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo, CopyableBuilder<Builder, IsAuthorizedRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization
         * decision for the input.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store. Policies in this policy store will be used to make an
         *        authorization decision for the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the principal for which the authorization decision is to be made.
         * </p>
         * 
         * @param principal
         *        Specifies the principal for which the authorization decision is to be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(EntityIdentifier principal);

        /**
         * <p>
         * Specifies the principal for which the authorization decision is to be made.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(EntityIdentifier)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(EntityIdentifier)
         */
        default Builder principal(Consumer<EntityIdentifier.Builder> principal) {
            return principal(EntityIdentifier.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * Specifies the requested action to be authorized. For example, is the principal authorized to perform this
         * action on the resource?
         * </p>
         * 
         * @param action
         *        Specifies the requested action to be authorized. For example, is the principal authorized to perform
         *        this action on the resource?
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ActionIdentifier action);

        /**
         * <p>
         * Specifies the requested action to be authorized. For example, is the principal authorized to perform this
         * action on the resource?
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionIdentifier.Builder} avoiding the
         * need to create one manually via {@link ActionIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ActionIdentifier)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ActionIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ActionIdentifier)
         */
        default Builder action(Consumer<ActionIdentifier.Builder> action) {
            return action(ActionIdentifier.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Specifies the resource for which the authorization decision is to be made.
         * </p>
         * 
         * @param resource
         *        Specifies the resource for which the authorization decision is to be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(EntityIdentifier resource);

        /**
         * <p>
         * Specifies the resource for which the authorization decision is to be made.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(EntityIdentifier)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(EntityIdentifier)
         */
        default Builder resource(Consumer<EntityIdentifier.Builder> resource) {
            return resource(EntityIdentifier.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Specifies additional context that can be used to make more granular authorization decisions.
         * </p>
         * 
         * @param context
         *        Specifies additional context that can be used to make more granular authorization decisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(ContextDefinition context);

        /**
         * <p>
         * Specifies additional context that can be used to make more granular authorization decisions.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextDefinition.Builder} avoiding the
         * need to create one manually via {@link ContextDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #context(ContextDefinition)}.
         * 
         * @param context
         *        a consumer that will call methods on {@link ContextDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #context(ContextDefinition)
         */
        default Builder context(Consumer<ContextDefinition.Builder> context) {
            return context(ContextDefinition.builder().applyMutation(context).build());
        }

        /**
         * <p>
         * Specifies the list of resources and principals and their associated attributes that Verified Permissions can
         * examine when evaluating the policies.
         * </p>
         * <note>
         * <p>
         * You can include only principal and resource entities in this parameter; you can't include actions. You must
         * specify actions in the schema.
         * </p>
         * </note>
         * 
         * @param entities
         *        Specifies the list of resources and principals and their associated attributes that Verified
         *        Permissions can examine when evaluating the policies. </p> <note>
         *        <p>
         *        You can include only principal and resource entities in this parameter; you can't include actions. You
         *        must specify actions in the schema.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(EntitiesDefinition entities);

        /**
         * <p>
         * Specifies the list of resources and principals and their associated attributes that Verified Permissions can
         * examine when evaluating the policies.
         * </p>
         * <note>
         * <p>
         * You can include only principal and resource entities in this parameter; you can't include actions. You must
         * specify actions in the schema.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link EntitiesDefinition.Builder}
         * avoiding the need to create one manually via {@link EntitiesDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntitiesDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(EntitiesDefinition)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link EntitiesDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(EntitiesDefinition)
         */
        default Builder entities(Consumer<EntitiesDefinition.Builder> entities) {
            return entities(EntitiesDefinition.builder().applyMutation(entities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private EntityIdentifier principal;

        private ActionIdentifier action;

        private EntityIdentifier resource;

        private ContextDefinition context;

        private EntitiesDefinition entities;

        private BuilderImpl() {
        }

        private BuilderImpl(IsAuthorizedRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            principal(model.principal);
            action(model.action);
            resource(model.resource);
            context(model.context);
            entities(model.entities);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final EntityIdentifier.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityIdentifier.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityIdentifier principal) {
            this.principal = principal;
            return this;
        }

        public final ActionIdentifier.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(ActionIdentifier.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ActionIdentifier action) {
            this.action = action;
            return this;
        }

        public final EntityIdentifier.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(EntityIdentifier.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityIdentifier resource) {
            this.resource = resource;
            return this;
        }

        public final ContextDefinition.Builder getContext() {
            return context != null ? context.toBuilder() : null;
        }

        public final void setContext(ContextDefinition.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(ContextDefinition context) {
            this.context = context;
            return this;
        }

        public final EntitiesDefinition.Builder getEntities() {
            return entities != null ? entities.toBuilder() : null;
        }

        public final void setEntities(EntitiesDefinition.BuilderImpl entities) {
            this.entities = entities != null ? entities.build() : null;
        }

        @Override
        public final Builder entities(EntitiesDefinition entities) {
            this.entities = entities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IsAuthorizedRequest build() {
            return new IsAuthorizedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
