/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes a policy definition. It must always have either an <code>static</code> or a
 * <code>templateLinked</code> element.
 * </p>
 * <p>
 * This data type is used as a response parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html">GetPolicy</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyDefinitionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyDefinitionDetail.Builder, PolicyDefinitionDetail> {
    private static final SdkField<StaticPolicyDefinitionDetail> STATIC_FIELD = SdkField
            .<StaticPolicyDefinitionDetail> builder(MarshallingType.SDK_POJO).memberName("static")
            .getter(getter(PolicyDefinitionDetail::staticValue)).setter(setter(Builder::staticValue))
            .constructor(StaticPolicyDefinitionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("static").build()).build();

    private static final SdkField<TemplateLinkedPolicyDefinitionDetail> TEMPLATE_LINKED_FIELD = SdkField
            .<TemplateLinkedPolicyDefinitionDetail> builder(MarshallingType.SDK_POJO).memberName("templateLinked")
            .getter(getter(PolicyDefinitionDetail::templateLinked)).setter(setter(Builder::templateLinked))
            .constructor(TemplateLinkedPolicyDefinitionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLinked").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FIELD,
            TEMPLATE_LINKED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("static", STATIC_FIELD);
                    put("templateLinked", TEMPLATE_LINKED_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final StaticPolicyDefinitionDetail staticValue;

    private final TemplateLinkedPolicyDefinitionDetail templateLinked;

    private final Type type;

    private PolicyDefinitionDetail(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.templateLinked = builder.templateLinked;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a static policy that wasn't created with a policy template.
     * </p>
     * 
     * @return Information about a static policy that wasn't created with a policy template.
     */
    public final StaticPolicyDefinitionDetail staticValue() {
        return staticValue;
    }

    /**
     * <p>
     * Information about a template-linked policy that was created by instantiating a policy template.
     * </p>
     * 
     * @return Information about a template-linked policy that was created by instantiating a policy template.
     */
    public final TemplateLinkedPolicyDefinitionDetail templateLinked() {
        return templateLinked;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(templateLinked());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDefinitionDetail)) {
            return false;
        }
        PolicyDefinitionDetail other = (PolicyDefinitionDetail) obj;
        return Objects.equals(staticValue(), other.staticValue()) && Objects.equals(templateLinked(), other.templateLinked());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyDefinitionDetail").add("Static", staticValue()).add("TemplateLinked", templateLinked())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "static":
            return Optional.ofNullable(clazz.cast(staticValue()));
        case "templateLinked":
            return Optional.ofNullable(clazz.cast(templateLinked()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #staticValue()} initialized to the given value.
     *
     * <p>
     * Information about a static policy that wasn't created with a policy template.
     * </p>
     * 
     * @param staticValue
     *        Information about a static policy that wasn't created with a policy template.
     */
    public static PolicyDefinitionDetail fromStaticValue(StaticPolicyDefinitionDetail staticValue) {
        return builder().staticValue(staticValue).build();
    }

    /**
     * Create an instance of this class with {@link #staticValue()} initialized to the given value.
     *
     * <p>
     * Information about a static policy that wasn't created with a policy template.
     * </p>
     * 
     * @param staticValue
     *        Information about a static policy that wasn't created with a policy template.
     */
    public static PolicyDefinitionDetail fromStaticValue(Consumer<StaticPolicyDefinitionDetail.Builder> staticValue) {
        StaticPolicyDefinitionDetail.Builder builder = StaticPolicyDefinitionDetail.builder();
        staticValue.accept(builder);
        return fromStaticValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #templateLinked()} initialized to the given value.
     *
     * <p>
     * Information about a template-linked policy that was created by instantiating a policy template.
     * </p>
     * 
     * @param templateLinked
     *        Information about a template-linked policy that was created by instantiating a policy template.
     */
    public static PolicyDefinitionDetail fromTemplateLinked(TemplateLinkedPolicyDefinitionDetail templateLinked) {
        return builder().templateLinked(templateLinked).build();
    }

    /**
     * Create an instance of this class with {@link #templateLinked()} initialized to the given value.
     *
     * <p>
     * Information about a template-linked policy that was created by instantiating a policy template.
     * </p>
     * 
     * @param templateLinked
     *        Information about a template-linked policy that was created by instantiating a policy template.
     */
    public static PolicyDefinitionDetail fromTemplateLinked(Consumer<TemplateLinkedPolicyDefinitionDetail.Builder> templateLinked) {
        TemplateLinkedPolicyDefinitionDetail.Builder builder = TemplateLinkedPolicyDefinitionDetail.builder();
        templateLinked.accept(builder);
        return fromTemplateLinked(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDefinitionDetail, T> g) {
        return obj -> g.apply((PolicyDefinitionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyDefinitionDetail> {
        /**
         * <p>
         * Information about a static policy that wasn't created with a policy template.
         * </p>
         * 
         * @param staticValue
         *        Information about a static policy that wasn't created with a policy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(StaticPolicyDefinitionDetail staticValue);

        /**
         * <p>
         * Information about a static policy that wasn't created with a policy template.
         * </p>
         * This is a convenience method that creates an instance of the {@link StaticPolicyDefinitionDetail.Builder}
         * avoiding the need to create one manually via {@link StaticPolicyDefinitionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticPolicyDefinitionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #staticValue(StaticPolicyDefinitionDetail)}.
         * 
         * @param staticValue
         *        a consumer that will call methods on {@link StaticPolicyDefinitionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticValue(StaticPolicyDefinitionDetail)
         */
        default Builder staticValue(Consumer<StaticPolicyDefinitionDetail.Builder> staticValue) {
            return staticValue(StaticPolicyDefinitionDetail.builder().applyMutation(staticValue).build());
        }

        /**
         * <p>
         * Information about a template-linked policy that was created by instantiating a policy template.
         * </p>
         * 
         * @param templateLinked
         *        Information about a template-linked policy that was created by instantiating a policy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateLinked(TemplateLinkedPolicyDefinitionDetail templateLinked);

        /**
         * <p>
         * Information about a template-linked policy that was created by instantiating a policy template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TemplateLinkedPolicyDefinitionDetail.Builder} avoiding the need to create one manually via
         * {@link TemplateLinkedPolicyDefinitionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateLinkedPolicyDefinitionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #templateLinked(TemplateLinkedPolicyDefinitionDetail)}.
         * 
         * @param templateLinked
         *        a consumer that will call methods on {@link TemplateLinkedPolicyDefinitionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateLinked(TemplateLinkedPolicyDefinitionDetail)
         */
        default Builder templateLinked(Consumer<TemplateLinkedPolicyDefinitionDetail.Builder> templateLinked) {
            return templateLinked(TemplateLinkedPolicyDefinitionDetail.builder().applyMutation(templateLinked).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StaticPolicyDefinitionDetail staticValue;

        private TemplateLinkedPolicyDefinitionDetail templateLinked;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDefinitionDetail model) {
            staticValue(model.staticValue);
            templateLinked(model.templateLinked);
        }

        public final StaticPolicyDefinitionDetail.Builder getStaticValue() {
            return staticValue != null ? staticValue.toBuilder() : null;
        }

        public final void setStaticValue(StaticPolicyDefinitionDetail.BuilderImpl staticValue) {
            Object oldValue = this.staticValue;
            this.staticValue = staticValue != null ? staticValue.build() : null;
            handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
        }

        @Override
        public final Builder staticValue(StaticPolicyDefinitionDetail staticValue) {
            Object oldValue = this.staticValue;
            this.staticValue = staticValue;
            handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
            return this;
        }

        public final TemplateLinkedPolicyDefinitionDetail.Builder getTemplateLinked() {
            return templateLinked != null ? templateLinked.toBuilder() : null;
        }

        public final void setTemplateLinked(TemplateLinkedPolicyDefinitionDetail.BuilderImpl templateLinked) {
            Object oldValue = this.templateLinked;
            this.templateLinked = templateLinked != null ? templateLinked.build() : null;
            handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
        }

        @Override
        public final Builder templateLinked(TemplateLinkedPolicyDefinitionDetail templateLinked) {
            Object oldValue = this.templateLinked;
            this.templateLinked = templateLinked;
            handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
            return this;
        }

        @Override
        public PolicyDefinitionDetail build() {
            return new PolicyDefinitionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PolicyDefinitionDetail#type()
     */
    public enum Type {
        STATIC,

        TEMPLATE_LINKED,

        UNKNOWN_TO_SDK_VERSION
    }
}
