/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains Cedar policy validation settings for the policy store. The validation mode determines which
 * validation failures that Cedar considers serious enough to block acceptance of a new or edited static policy or
 * policy template.
 * </p>
 * <p>
 * This data type is used as a request parameter in the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyStore.html"
 * >CreatePolicyStore</a> and <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore.html"
 * >UpdatePolicyStore</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationSettings.Builder, ValidationSettings> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(ValidationSettings::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("mode", MODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String mode;

    private ValidationSettings(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The validation mode currently configured for this policy store. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors are
     * reported by either service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all submitted
     * new or updated static policies and policy templates. Any that fail validation are rejected and Cedar doesn't
     * store them in the policy store.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions rejects all
     * static policies and policy templates because there is no schema to validate against.
     * </p>
     * <p>
     * To submit a static policy or policy template without a schema, you must turn off validation.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ValidationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The validation mode currently configured for this policy store. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation
     *         errors are reported by either service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all
     *         submitted new or updated static policies and policy templates. Any that fail validation are rejected and
     *         Cedar doesn't store them in the policy store.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions rejects
     *         all static policies and policy templates because there is no schema to validate against.
     *         </p>
     *         <p>
     *         To submit a static policy or policy template without a schema, you must turn off validation.
     *         </p>
     * @see ValidationMode
     */
    public final ValidationMode mode() {
        return ValidationMode.fromValue(mode);
    }

    /**
     * <p>
     * The validation mode currently configured for this policy store. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors are
     * reported by either service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all submitted
     * new or updated static policies and policy templates. Any that fail validation are rejected and Cedar doesn't
     * store them in the policy store.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions rejects all
     * static policies and policy templates because there is no schema to validate against.
     * </p>
     * <p>
     * To submit a static policy or policy template without a schema, you must turn off validation.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ValidationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The validation mode currently configured for this policy store. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation
     *         errors are reported by either service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all
     *         submitted new or updated static policies and policy templates. Any that fail validation are rejected and
     *         Cedar doesn't store them in the policy store.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions rejects
     *         all static policies and policy templates because there is no schema to validate against.
     *         </p>
     *         <p>
     *         To submit a static policy or policy template without a schema, you must turn off validation.
     *         </p>
     * @see ValidationMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationSettings)) {
            return false;
        }
        ValidationSettings other = (ValidationSettings) obj;
        return Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationSettings").add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ValidationSettings, T> g) {
        return obj -> g.apply((ValidationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationSettings> {
        /**
         * <p>
         * The validation mode currently configured for this policy store. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors
         * are reported by either service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all
         * submitted new or updated static policies and policy templates. Any that fail validation are rejected and
         * Cedar doesn't store them in the policy store.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions rejects all
         * static policies and policy templates because there is no schema to validate against.
         * </p>
         * <p>
         * To submit a static policy or policy template without a schema, you must turn off validation.
         * </p>
         * </important>
         * 
         * @param mode
         *        The validation mode currently configured for this policy store. The valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation
         *        errors are reported by either service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all
         *        submitted new or updated static policies and policy templates. Any that fail validation are rejected
         *        and Cedar doesn't store them in the policy store.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions
         *        rejects all static policies and policy templates because there is no schema to validate against.
         *        </p>
         *        <p>
         *        To submit a static policy or policy template without a schema, you must turn off validation.
         *        </p>
         * @see ValidationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The validation mode currently configured for this policy store. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors
         * are reported by either service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all
         * submitted new or updated static policies and policy templates. Any that fail validation are rejected and
         * Cedar doesn't store them in the policy store.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions rejects all
         * static policies and policy templates because there is no schema to validate against.
         * </p>
         * <p>
         * To submit a static policy or policy template without a schema, you must turn off validation.
         * </p>
         * </important>
         * 
         * @param mode
         *        The validation mode currently configured for this policy store. The valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>OFF</b> – Neither Verified Permissions nor Cedar perform any validation on policies. No validation
         *        errors are reported by either service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STRICT</b> – Requires a schema to be present in the policy store. Cedar performs validation on all
         *        submitted new or updated static policies and policy templates. Any that fail validation are rejected
         *        and Cedar doesn't store them in the policy store.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        If <code>Mode=STRICT</code> and the policy store doesn't contain a schema, Verified Permissions
         *        rejects all static policies and policy templates because there is no schema to validate against.
         *        </p>
         *        <p>
         *        To submit a static policy or policy template without a schema, you must turn off validation.
         *        </p>
         * @see ValidationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationMode
         */
        Builder mode(ValidationMode mode);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationSettings model) {
            mode(model.mode);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ValidationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public ValidationSettings build() {
            return new ValidationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
