/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Decision {
    ALLOW("ALLOW"),
    DENY("DENY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Decision> VALUE_MAP;
    private final String value;

    private Decision(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Decision fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Decision> knownValues() {
        EnumSet<Decision> knownValues = EnumSet.allOf(Decision.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Decision.class, Decision::toString);
    }
}

