/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsAsyncClient;
import software.amazon.awssdk.services.verifiedpermissions.internal.UserAgentUtils;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyTemplatesRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyTemplatesResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyTemplateItem;

public class ListPolicyTemplatesPublisher
implements SdkPublisher<ListPolicyTemplatesResponse> {
    private final VerifiedPermissionsAsyncClient client;
    private final ListPolicyTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyTemplatesPublisher(VerifiedPermissionsAsyncClient client, ListPolicyTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyTemplatesPublisher(VerifiedPermissionsAsyncClient client, ListPolicyTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyTemplateItem> policyTemplates() {
        Function<ListPolicyTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyTemplates() != null) {
                return response.policyTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyTemplatesResponseFetcher
    implements AsyncPageFetcher<ListPolicyTemplatesResponse> {
        private ListPolicyTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyTemplatesResponse> nextPage(ListPolicyTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyTemplatesPublisher.this.client.listPolicyTemplates(ListPolicyTemplatesPublisher.this.firstRequest);
            }
            return ListPolicyTemplatesPublisher.this.client.listPolicyTemplates((ListPolicyTemplatesRequest)((Object)ListPolicyTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

