/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetPolicyResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<BatchGetPolicyResponse.Builder, BatchGetPolicyResponse> {
    private static final SdkField<List<BatchGetPolicyOutputItem>> RESULTS_FIELD = SdkField
            .<List<BatchGetPolicyOutputItem>> builder(MarshallingType.LIST)
            .memberName("results")
            .getter(getter(BatchGetPolicyResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetPolicyOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetPolicyOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetPolicyErrorItem>> ERRORS_FIELD = SdkField
            .<List<BatchGetPolicyErrorItem>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetPolicyResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetPolicyErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetPolicyErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetPolicyOutputItem> results;

    private final List<BatchGetPolicyErrorItem> errors;

    private BatchGetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the policies listed in the request that were successfully returned. These results are returned
     * in the order they were requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return Information about the policies listed in the request that were successfully returned. These results are
     *         returned in the order they were requested.
     */
    public final List<BatchGetPolicyOutputItem> results() {
        return results;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the policies from the request that resulted in an error. These results are returned in the
     * order they were requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Information about the policies from the request that resulted in an error. These results are returned in
     *         the order they were requested.
     */
    public final List<BatchGetPolicyErrorItem> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPolicyResponse)) {
            return false;
        }
        BatchGetPolicyResponse other = (BatchGetPolicyResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetPolicyResponse").add("Results", hasResults() ? results() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("results", RESULTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPolicyResponse, T> g) {
        return obj -> g.apply((BatchGetPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetPolicyResponse> {
        /**
         * <p>
         * Information about the policies listed in the request that were successfully returned. These results are
         * returned in the order they were requested.
         * </p>
         * 
         * @param results
         *        Information about the policies listed in the request that were successfully returned. These results
         *        are returned in the order they were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<BatchGetPolicyOutputItem> results);

        /**
         * <p>
         * Information about the policies listed in the request that were successfully returned. These results are
         * returned in the order they were requested.
         * </p>
         * 
         * @param results
         *        Information about the policies listed in the request that were successfully returned. These results
         *        are returned in the order they were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(BatchGetPolicyOutputItem... results);

        /**
         * <p>
         * Information about the policies listed in the request that were successfully returned. These results are
         * returned in the order they were requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyOutputItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyOutputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyOutputItem.Builder#build()} is
         * called immediately and its result is passed to {@link #results(List<BatchGetPolicyOutputItem>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<BatchGetPolicyOutputItem>)
         */
        Builder results(Consumer<BatchGetPolicyOutputItem.Builder>... results);

        /**
         * <p>
         * Information about the policies from the request that resulted in an error. These results are returned in the
         * order they were requested.
         * </p>
         * 
         * @param errors
         *        Information about the policies from the request that resulted in an error. These results are returned
         *        in the order they were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetPolicyErrorItem> errors);

        /**
         * <p>
         * Information about the policies from the request that resulted in an error. These results are returned in the
         * order they were requested.
         * </p>
         * 
         * @param errors
         *        Information about the policies from the request that resulted in an error. These results are returned
         *        in the order they were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetPolicyErrorItem... errors);

        /**
         * <p>
         * Information about the policies from the request that resulted in an error. These results are returned in the
         * order they were requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyErrorItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyErrorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyErrorItem.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchGetPolicyErrorItem>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyErrorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetPolicyErrorItem>)
         */
        Builder errors(Consumer<BatchGetPolicyErrorItem.Builder>... errors);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private List<BatchGetPolicyOutputItem> results = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetPolicyErrorItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPolicyResponse model) {
            super(model);
            results(model.results);
            errors(model.errors);
        }

        public final List<BatchGetPolicyOutputItem.Builder> getResults() {
            List<BatchGetPolicyOutputItem.Builder> result = BatchGetPolicyOutputListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<BatchGetPolicyOutputItem.BuilderImpl> results) {
            this.results = BatchGetPolicyOutputListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<BatchGetPolicyOutputItem> results) {
            this.results = BatchGetPolicyOutputListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchGetPolicyOutputItem... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<BatchGetPolicyOutputItem.Builder>... results) {
            results(Stream.of(results).map(c -> BatchGetPolicyOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetPolicyErrorItem.Builder> getErrors() {
            List<BatchGetPolicyErrorItem.Builder> result = BatchGetPolicyErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetPolicyErrorItem.BuilderImpl> errors) {
            this.errors = BatchGetPolicyErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetPolicyErrorItem> errors) {
            this.errors = BatchGetPolicyErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetPolicyErrorItem... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetPolicyErrorItem.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetPolicyErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetPolicyResponse build() {
            return new BatchGetPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
