/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of an attribute.
 * </p>
 * <p>
 * Contains information about the runtime context for a request for which an authorization decision is made.
 * </p>
 * <p>
 * This data type is used as a member of the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ContextDefinition.html"
 * >ContextDefinition</a> structure which is uses as a request parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html">IsAuthorized</a>, <a
 * href
 * ="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html">BatchIsAuthorized
 * </a>, and <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html"
 * >IsAuthorizedWithToken</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeValue implements SdkPojo, Serializable, ToCopyableBuilder<AttributeValue.Builder, AttributeValue> {
    private static final SdkField<Boolean> BOOLEAN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("boolean").getter(getter(AttributeValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boolean").build()).build();

    private static final SdkField<EntityIdentifier> ENTITY_IDENTIFIER_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("entityIdentifier")
            .getter(getter(AttributeValue::entityIdentifier)).setter(setter(Builder::entityIdentifier))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdentifier").build()).build();

    private static final SdkField<Long> LONG_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("long")
            .getter(getter(AttributeValue::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("long").build()).build();

    private static final SdkField<String> STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("string")
            .getter(getter(AttributeValue::string)).setter(setter(Builder::string))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()).build();

    private static final SdkField<List<AttributeValue>> SET_FIELD = SdkField
            .<List<AttributeValue>> builder(MarshallingType.LIST)
            .memberName("set")
            .getter(getter(AttributeValue::set))
            .setter(setter(Builder::set))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("set").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> RECORD_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("record")
            .getter(getter(AttributeValue::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("record").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IPADDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ipaddr")
            .getter(getter(AttributeValue::ipaddr)).setter(setter(Builder::ipaddr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipaddr").build()).build();

    private static final SdkField<String> DECIMAL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("decimal")
            .getter(getter(AttributeValue::decimal)).setter(setter(Builder::decimal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_FIELD,
            ENTITY_IDENTIFIER_FIELD, LONG_FIELD, STRING_FIELD, SET_FIELD, RECORD_FIELD, IPADDR_FIELD, DECIMAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean booleanValue;

    private final EntityIdentifier entityIdentifier;

    private final Long longValue;

    private final String string;

    private final List<AttributeValue> set;

    private final Map<String, AttributeValue> record;

    private final String ipaddr;

    private final String decimal;

    private final Type type;

    private AttributeValue(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.entityIdentifier = builder.entityIdentifier;
        this.longValue = builder.longValue;
        this.string = builder.string;
        this.set = builder.set;
        this.record = builder.record;
        this.ipaddr = builder.ipaddr;
        this.decimal = builder.decimal;
        this.type = builder.type;
    }

    /**
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a>
     * type.
     * </p>
     * <p>
     * Example: <code>{"boolean": true}</code>
     * </p>
     * 
     * @return An attribute value of <a
     *         href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a> type.</p>
     *         <p>
     *         Example: <code>{"boolean": true}</code>
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * An attribute value of type <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
     * >EntityIdentifier</a>.
     * </p>
     * <p>
     * Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
     * </p>
     * 
     * @return An attribute value of type <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
     *         >EntityIdentifier</a>.</p>
     *         <p>
     *         Example:
     *         <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
     */
    public final EntityIdentifier entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a> type.
     * </p>
     * <p>
     * Example: <code>{"long": 0}</code>
     * </p>
     * 
     * @return An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a>
     *         type.</p>
     *         <p>
     *         Example: <code>{"long": 0}</code>
     */
    public final Long longValue() {
        return longValue;
    }

    /**
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a>
     * type.
     * </p>
     * <p>
     * Example: <code>{"string": "abc"}</code>
     * </p>
     * 
     * @return An attribute value of <a
     *         href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a> type.</p>
     *         <p>
     *         Example: <code>{"string": "abc"}</code>
     */
    public final String string() {
        return string;
    }

    /**
     * For responses, this returns true if the service returned a value for the Set property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSet() {
        return set != null && !(set instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.
     * </p>
     * <p>
     * Example: <code>{"set": [ {} ] }</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSet} method.
     * </p>
     * 
     * @return An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a>
     *         type.</p>
     *         <p>
     *         Example: <code>{"set": [ {} ] }</code>
     */
    public final List<AttributeValue> set() {
        return set;
    }

    /**
     * For responses, this returns true if the service returned a value for the Record property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a>
     * type.
     * </p>
     * <p>
     * Example: <code>{"record": { "keyName": {} } }</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecord} method.
     * </p>
     * 
     * @return An attribute value of <a
     *         href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a> type.</p>
     *         <p>
     *         Example: <code>{"record": { "keyName": {} } }</code>
     */
    public final Map<String, AttributeValue> record() {
        return record;
    }

    /**
     * <p>
     * An attribute value of <a
     * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr">ipaddr</a> type.
     * </p>
     * <p>
     * Example: <code>{"ip": "192.168.1.100"}</code>
     * </p>
     * 
     * @return An attribute value of <a
     *         href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr">ipaddr</a> type.</p>
     *         <p>
     *         Example: <code>{"ip": "192.168.1.100"}</code>
     */
    public final String ipaddr() {
        return ipaddr;
    }

    /**
     * <p>
     * An attribute value of <a
     * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal">decimal</a> type.
     * </p>
     * <p>
     * Example: <code>{"decimal": "1.1"}</code>
     * </p>
     * 
     * @return An attribute value of <a
     *         href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal">decimal</a> type.</p>
     *         <p>
     *         Example: <code>{"decimal": "1.1"}</code>
     */
    public final String decimal() {
        return decimal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(string());
        hashCode = 31 * hashCode + Objects.hashCode(hasSet() ? set() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipaddr());
        hashCode = 31 * hashCode + Objects.hashCode(decimal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue) obj;
        return Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(entityIdentifier(), other.entityIdentifier()) && Objects.equals(longValue(), other.longValue())
                && Objects.equals(string(), other.string()) && hasSet() == other.hasSet() && Objects.equals(set(), other.set())
                && hasRecord() == other.hasRecord() && Objects.equals(record(), other.record())
                && Objects.equals(ipaddr(), other.ipaddr()) && Objects.equals(decimal(), other.decimal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeValue")
                .add("Boolean", booleanValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EntityIdentifier", entityIdentifier())
                .add("Long", longValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("String", string() == null ? null : "*** Sensitive Data Redacted ***").add("Set", hasSet() ? set() : null)
                .add("Record", hasRecord() ? record() : null)
                .add("Ipaddr", ipaddr() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Decimal", decimal() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "boolean":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "long":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "string":
            return Optional.ofNullable(clazz.cast(string()));
        case "set":
            return Optional.ofNullable(clazz.cast(set()));
        case "record":
            return Optional.ofNullable(clazz.cast(record()));
        case "ipaddr":
            return Optional.ofNullable(clazz.cast(ipaddr()));
        case "decimal":
            return Optional.ofNullable(clazz.cast(decimal()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a>
     * type.
     * </p>
     * <p>
     * Example: <code>{"boolean": true}</code>
     * </p>
     * 
     * @param booleanValue
     *        An attribute value of <a
     *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a> type.</p>
     *        <p>
     *        Example: <code>{"boolean": true}</code>
     */
    public static AttributeValue fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #entityIdentifier()} initialized to the given value.
     *
     * <p>
     * An attribute value of type <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
     * >EntityIdentifier</a>.
     * </p>
     * <p>
     * Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
     * </p>
     * 
     * @param entityIdentifier
     *        An attribute value of type <a
     *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
     *        >EntityIdentifier</a>.</p>
     *        <p>
     *        Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
     */
    public static AttributeValue fromEntityIdentifier(EntityIdentifier entityIdentifier) {
        return builder().entityIdentifier(entityIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #entityIdentifier()} initialized to the given value.
     *
     * <p>
     * An attribute value of type <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
     * >EntityIdentifier</a>.
     * </p>
     * <p>
     * Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
     * </p>
     * 
     * @param entityIdentifier
     *        An attribute value of type <a
     *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
     *        >EntityIdentifier</a>.</p>
     *        <p>
     *        Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
     */
    public static AttributeValue fromEntityIdentifier(Consumer<EntityIdentifier.Builder> entityIdentifier) {
        EntityIdentifier.Builder builder = EntityIdentifier.builder();
        entityIdentifier.accept(builder);
        return fromEntityIdentifier(builder.build());
    }

    /**
     * Create an instance of this class with {@link #longValue()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a> type.
     * </p>
     * <p>
     * Example: <code>{"long": 0}</code>
     * </p>
     * 
     * @param longValue
     *        An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a>
     *        type.</p>
     *        <p>
     *        Example: <code>{"long": 0}</code>
     */
    public static AttributeValue fromLongValue(Long longValue) {
        return builder().longValue(longValue).build();
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a>
     * type.
     * </p>
     * <p>
     * Example: <code>{"string": "abc"}</code>
     * </p>
     * 
     * @param string
     *        An attribute value of <a
     *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a> type.</p>
     *        <p>
     *        Example: <code>{"string": "abc"}</code>
     */
    public static AttributeValue fromString(String string) {
        return builder().string(string).build();
    }

    /**
     * Create an instance of this class with {@link #set()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.
     * </p>
     * <p>
     * Example: <code>{"set": [ {} ] }</code>
     * </p>
     * 
     * @param set
     *        An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a>
     *        type.</p>
     *        <p>
     *        Example: <code>{"set": [ {} ] }</code>
     */
    public static AttributeValue fromSet(List<AttributeValue> set) {
        return builder().set(set).build();
    }

    /**
     * Create an instance of this class with {@link #record()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a>
     * type.
     * </p>
     * <p>
     * Example: <code>{"record": { "keyName": {} } }</code>
     * </p>
     * 
     * @param record
     *        An attribute value of <a
     *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a> type.</p>
     *        <p>
     *        Example: <code>{"record": { "keyName": {} } }</code>
     */
    public static AttributeValue fromRecord(Map<String, AttributeValue> record) {
        return builder().record(record).build();
    }

    /**
     * Create an instance of this class with {@link #ipaddr()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a
     * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr">ipaddr</a> type.
     * </p>
     * <p>
     * Example: <code>{"ip": "192.168.1.100"}</code>
     * </p>
     * 
     * @param ipaddr
     *        An attribute value of <a
     *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr">ipaddr</a> type.</p>
     *        <p>
     *        Example: <code>{"ip": "192.168.1.100"}</code>
     */
    public static AttributeValue fromIpaddr(String ipaddr) {
        return builder().ipaddr(ipaddr).build();
    }

    /**
     * Create an instance of this class with {@link #decimal()} initialized to the given value.
     *
     * <p>
     * An attribute value of <a
     * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal">decimal</a> type.
     * </p>
     * <p>
     * Example: <code>{"decimal": "1.1"}</code>
     * </p>
     * 
     * @param decimal
     *        An attribute value of <a
     *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal">decimal</a> type.</p>
     *        <p>
     *        Example: <code>{"decimal": "1.1"}</code>
     */
    public static AttributeValue fromDecimal(String decimal) {
        return builder().decimal(decimal).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("boolean", BOOLEAN_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("long", LONG_FIELD);
        map.put("string", STRING_FIELD);
        map.put("set", SET_FIELD);
        map.put("record", RECORD_FIELD);
        map.put("ipaddr", IPADDR_FIELD);
        map.put("decimal", DECIMAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeValue> {
        /**
         * <p>
         * An attribute value of <a
         * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a> type.
         * </p>
         * <p>
         * Example: <code>{"boolean": true}</code>
         * </p>
         * 
         * @param booleanValue
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean">Boolean</a> type.</p>
         *        <p>
         *        Example: <code>{"boolean": true}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * An attribute value of type <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
         * >EntityIdentifier</a>.
         * </p>
         * <p>
         * Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
         * </p>
         * 
         * @param entityIdentifier
         *        An attribute value of type <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
         *        >EntityIdentifier</a>.</p>
         *        <p>
         *        Example:
         *        <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(EntityIdentifier entityIdentifier);

        /**
         * <p>
         * An attribute value of type <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html"
         * >EntityIdentifier</a>.
         * </p>
         * <p>
         * Example: <code>"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #entityIdentifier(EntityIdentifier)}.
         * 
         * @param entityIdentifier
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityIdentifier(EntityIdentifier)
         */
        default Builder entityIdentifier(Consumer<EntityIdentifier.Builder> entityIdentifier) {
            return entityIdentifier(EntityIdentifier.builder().applyMutation(entityIdentifier).build());
        }

        /**
         * <p>
         * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a>
         * type.
         * </p>
         * <p>
         * Example: <code>{"long": 0}</code>
         * </p>
         * 
         * @param longValue
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long">Long</a> type.</p>
         *        <p>
         *        Example: <code>{"long": 0}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a>
         * type.
         * </p>
         * <p>
         * Example: <code>{"string": "abc"}</code>
         * </p>
         * 
         * @param string
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string">String</a> type.</p>
         *        <p>
         *        Example: <code>{"string": "abc"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder string(String string);

        /**
         * <p>
         * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.
         * </p>
         * <p>
         * Example: <code>{"set": [ {} ] }</code>
         * </p>
         * 
         * @param set
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.</p>
         *        <p>
         *        Example: <code>{"set": [ {} ] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder set(Collection<AttributeValue> set);

        /**
         * <p>
         * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.
         * </p>
         * <p>
         * Example: <code>{"set": [ {} ] }</code>
         * </p>
         * 
         * @param set
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.</p>
         *        <p>
         *        Example: <code>{"set": [ {} ] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder set(AttributeValue... set);

        /**
         * <p>
         * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set">Set</a> type.
         * </p>
         * <p>
         * Example: <code>{"set": [ {} ] }</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue.Builder#build()} is called
         * immediately and its result is passed to {@link #set(List<AttributeValue>)}.
         * 
         * @param set
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #set(java.util.Collection<AttributeValue>)
         */
        Builder set(Consumer<Builder>... set);

        /**
         * <p>
         * An attribute value of <a href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a>
         * type.
         * </p>
         * <p>
         * Example: <code>{"record": { "keyName": {} } }</code>
         * </p>
         * 
         * @param record
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record">Record</a> type.</p>
         *        <p>
         *        Example: <code>{"record": { "keyName": {} } }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Map<String, AttributeValue> record);

        /**
         * <p>
         * An attribute value of <a
         * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr">ipaddr</a> type.
         * </p>
         * <p>
         * Example: <code>{"ip": "192.168.1.100"}</code>
         * </p>
         * 
         * @param ipaddr
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr">ipaddr</a>
         *        type.</p>
         *        <p>
         *        Example: <code>{"ip": "192.168.1.100"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipaddr(String ipaddr);

        /**
         * <p>
         * An attribute value of <a
         * href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal">decimal</a> type.
         * </p>
         * <p>
         * Example: <code>{"decimal": "1.1"}</code>
         * </p>
         * 
         * @param decimal
         *        An attribute value of <a
         *        href="https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal">decimal</a>
         *        type.</p>
         *        <p>
         *        Example: <code>{"decimal": "1.1"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimal(String decimal);
    }

    static final class BuilderImpl implements Builder {
        private Boolean booleanValue;

        private EntityIdentifier entityIdentifier;

        private Long longValue;

        private String string;

        private List<AttributeValue> set = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AttributeValue> record = DefaultSdkAutoConstructMap.getInstance();

        private String ipaddr;

        private String decimal;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            booleanValue(model.booleanValue);
            entityIdentifier(model.entityIdentifier);
            longValue(model.longValue);
            string(model.string);
            set(model.set);
            record(model.record);
            ipaddr(model.ipaddr);
            decimal(model.decimal);
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
            return this;
        }

        public final EntityIdentifier.Builder getEntityIdentifier() {
            return entityIdentifier != null ? entityIdentifier.toBuilder() : null;
        }

        public final void setEntityIdentifier(EntityIdentifier.BuilderImpl entityIdentifier) {
            Object oldValue = this.entityIdentifier;
            this.entityIdentifier = entityIdentifier != null ? entityIdentifier.build() : null;
            handleUnionValueChange(Type.ENTITY_IDENTIFIER, oldValue, this.entityIdentifier);
        }

        @Override
        public final Builder entityIdentifier(EntityIdentifier entityIdentifier) {
            Object oldValue = this.entityIdentifier;
            this.entityIdentifier = entityIdentifier;
            handleUnionValueChange(Type.ENTITY_IDENTIFIER, oldValue, this.entityIdentifier);
            return this;
        }

        public final Long getLongValue() {
            return longValue;
        }

        public final void setLongValue(Long longValue) {
            Object oldValue = this.longValue;
            this.longValue = longValue;
            handleUnionValueChange(Type.LONG, oldValue, this.longValue);
        }

        @Override
        public final Builder longValue(Long longValue) {
            Object oldValue = this.longValue;
            this.longValue = longValue;
            handleUnionValueChange(Type.LONG, oldValue, this.longValue);
            return this;
        }

        public final String getString() {
            return string;
        }

        public final void setString(String string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(String string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final List<Builder> getSet() {
            List<Builder> result = SetAttributeCopier.copyToBuilder(this.set);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSet(Collection<BuilderImpl> set) {
            Object oldValue = this.set;
            this.set = SetAttributeCopier.copyFromBuilder(set);
            handleUnionValueChange(Type.SET, oldValue, this.set);
        }

        @Override
        @Transient
        public final Builder set(Collection<AttributeValue> set) {
            Object oldValue = this.set;
            this.set = SetAttributeCopier.copy(set);
            handleUnionValueChange(Type.SET, oldValue, this.set);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder set(AttributeValue... set) {
            set(Arrays.asList(set));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder set(Consumer<Builder>... set) {
            set(Stream.of(set).map(c -> AttributeValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getRecord() {
            Map<String, Builder> result = RecordAttributeCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRecord(Map<String, BuilderImpl> record) {
            Object oldValue = this.record;
            this.record = RecordAttributeCopier.copyFromBuilder(record);
            handleUnionValueChange(Type.RECORD, oldValue, this.record);
        }

        @Override
        public final Builder record(Map<String, AttributeValue> record) {
            Object oldValue = this.record;
            this.record = RecordAttributeCopier.copy(record);
            handleUnionValueChange(Type.RECORD, oldValue, this.record);
            return this;
        }

        public final String getIpaddr() {
            return ipaddr;
        }

        public final void setIpaddr(String ipaddr) {
            Object oldValue = this.ipaddr;
            this.ipaddr = ipaddr;
            handleUnionValueChange(Type.IPADDR, oldValue, this.ipaddr);
        }

        @Override
        public final Builder ipaddr(String ipaddr) {
            Object oldValue = this.ipaddr;
            this.ipaddr = ipaddr;
            handleUnionValueChange(Type.IPADDR, oldValue, this.ipaddr);
            return this;
        }

        public final String getDecimal() {
            return decimal;
        }

        public final void setDecimal(String decimal) {
            Object oldValue = this.decimal;
            this.decimal = decimal;
            handleUnionValueChange(Type.DECIMAL, oldValue, this.decimal);
        }

        @Override
        public final Builder decimal(String decimal) {
            Object oldValue = this.decimal;
            this.decimal = decimal;
            handleUnionValueChange(Type.DECIMAL, oldValue, this.decimal);
            return this;
        }

        @Override
        public AttributeValue build() {
            return new AttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AttributeValue#type()
     */
    public enum Type {
        BOOLEAN,

        ENTITY_IDENTIFIER,

        LONG,

        STRING,

        SET,

        RECORD,

        IPADDR,

        DECIMAL,

        UNKNOWN_TO_SDK_VERSION
    }
}
