/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An authorization request that you include in a <code>BatchIsAuthorizedWithToken</code> API request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchIsAuthorizedWithTokenInputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchIsAuthorizedWithTokenInputItem.Builder, BatchIsAuthorizedWithTokenInputItem> {
    private static final SdkField<ActionIdentifier> ACTION_FIELD = SdkField.<ActionIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(BatchIsAuthorizedWithTokenInputItem::action)).setter(setter(Builder::action))
            .constructor(ActionIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<EntityIdentifier> RESOURCE_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(BatchIsAuthorizedWithTokenInputItem::resource)).setter(setter(Builder::resource))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<ContextDefinition> CONTEXT_FIELD = SdkField
            .<ContextDefinition> builder(MarshallingType.SDK_POJO).memberName("context")
            .getter(getter(BatchIsAuthorizedWithTokenInputItem::context)).setter(setter(Builder::context))
            .constructor(ContextDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, RESOURCE_FIELD,
            CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ActionIdentifier action;

    private final EntityIdentifier resource;

    private final ContextDefinition context;

    private BatchIsAuthorizedWithTokenInputItem(BuilderImpl builder) {
        this.action = builder.action;
        this.resource = builder.resource;
        this.context = builder.context;
    }

    /**
     * <p>
     * Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.
     * </p>
     * 
     * @return Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.
     */
    public final ActionIdentifier action() {
        return action;
    }

    /**
     * <p>
     * Specifies the resource that you want an authorization decision for. For example, <code>PhotoFlash::Photo</code>.
     * </p>
     * 
     * @return Specifies the resource that you want an authorization decision for. For example,
     *         <code>PhotoFlash::Photo</code>.
     */
    public final EntityIdentifier resource() {
        return resource;
    }

    /**
     * <p>
     * Specifies additional context that can be used to make more granular authorization decisions.
     * </p>
     * 
     * @return Specifies additional context that can be used to make more granular authorization decisions.
     */
    public final ContextDefinition context() {
        return context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedWithTokenInputItem)) {
            return false;
        }
        BatchIsAuthorizedWithTokenInputItem other = (BatchIsAuthorizedWithTokenInputItem) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(resource(), other.resource())
                && Objects.equals(context(), other.context());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchIsAuthorizedWithTokenInputItem").add("Action", action()).add("Resource", resource())
                .add("Context", context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("context", CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedWithTokenInputItem, T> g) {
        return obj -> g.apply((BatchIsAuthorizedWithTokenInputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchIsAuthorizedWithTokenInputItem> {
        /**
         * <p>
         * Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.
         * </p>
         * 
         * @param action
         *        Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ActionIdentifier action);

        /**
         * <p>
         * Specifies the requested action to be authorized. For example, <code>PhotoFlash::ReadPhoto</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionIdentifier.Builder} avoiding the
         * need to create one manually via {@link ActionIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ActionIdentifier)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ActionIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ActionIdentifier)
         */
        default Builder action(Consumer<ActionIdentifier.Builder> action) {
            return action(ActionIdentifier.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Specifies the resource that you want an authorization decision for. For example,
         * <code>PhotoFlash::Photo</code>.
         * </p>
         * 
         * @param resource
         *        Specifies the resource that you want an authorization decision for. For example,
         *        <code>PhotoFlash::Photo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(EntityIdentifier resource);

        /**
         * <p>
         * Specifies the resource that you want an authorization decision for. For example,
         * <code>PhotoFlash::Photo</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(EntityIdentifier)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(EntityIdentifier)
         */
        default Builder resource(Consumer<EntityIdentifier.Builder> resource) {
            return resource(EntityIdentifier.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Specifies additional context that can be used to make more granular authorization decisions.
         * </p>
         * 
         * @param context
         *        Specifies additional context that can be used to make more granular authorization decisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(ContextDefinition context);

        /**
         * <p>
         * Specifies additional context that can be used to make more granular authorization decisions.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextDefinition.Builder} avoiding the
         * need to create one manually via {@link ContextDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #context(ContextDefinition)}.
         * 
         * @param context
         *        a consumer that will call methods on {@link ContextDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #context(ContextDefinition)
         */
        default Builder context(Consumer<ContextDefinition.Builder> context) {
            return context(ContextDefinition.builder().applyMutation(context).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActionIdentifier action;

        private EntityIdentifier resource;

        private ContextDefinition context;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedWithTokenInputItem model) {
            action(model.action);
            resource(model.resource);
            context(model.context);
        }

        public final ActionIdentifier.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(ActionIdentifier.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ActionIdentifier action) {
            this.action = action;
            return this;
        }

        public final EntityIdentifier.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(EntityIdentifier.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityIdentifier resource) {
            this.resource = resource;
            return this;
        }

        public final ContextDefinition.Builder getContext() {
            return context != null ? context.toBuilder() : null;
        }

        public final void setContext(ContextDefinition.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(ContextDefinition context) {
            this.context = context;
            return this;
        }

        @Override
        public BatchIsAuthorizedWithTokenInputItem build() {
            return new BatchIsAuthorizedWithTokenInputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
