/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyStoresResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<ListPolicyStoresResponse.Builder, ListPolicyStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPolicyStoresResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PolicyStoreItem>> POLICY_STORES_FIELD = SdkField
            .<List<PolicyStoreItem>> builder(MarshallingType.LIST)
            .memberName("policyStores")
            .getter(getter(ListPolicyStoresResponse::policyStores))
            .setter(setter(Builder::policyStores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyStoreItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyStoreItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            POLICY_STORES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<PolicyStoreItem> policyStores;

    private ListPolicyStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policyStores = builder.policyStores;
    }

    /**
     * <p>
     * If present, this value indicates that more output is available than is included in the current response. Use this
     * value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part
     * of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>. This indicates that this is the last page of results.
     * </p>
     * 
     * @return If present, this value indicates that more output is available than is included in the current response.
     *         Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to
     *         get the next part of the output. You should repeat this until the <code>NextToken</code> response element
     *         comes back as <code>null</code>. This indicates that this is the last page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyStores() {
        return policyStores != null && !(policyStores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of policy stores in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyStores} method.
     * </p>
     * 
     * @return The list of policy stores in the account.
     */
    public final List<PolicyStoreItem> policyStores() {
        return policyStores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyStores() ? policyStores() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyStoresResponse)) {
            return false;
        }
        ListPolicyStoresResponse other = (ListPolicyStoresResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPolicyStores() == other.hasPolicyStores()
                && Objects.equals(policyStores(), other.policyStores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPolicyStoresResponse").add("NextToken", nextToken())
                .add("PolicyStores", hasPolicyStores() ? policyStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "policyStores":
            return Optional.ofNullable(clazz.cast(policyStores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("policyStores", POLICY_STORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyStoresResponse, T> g) {
        return obj -> g.apply((ListPolicyStoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPolicyStoresResponse> {
        /**
         * <p>
         * If present, this value indicates that more output is available than is included in the current response. Use
         * this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back
         * as <code>null</code>. This indicates that this is the last page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that more output is available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>. This indicates that this is the last page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of policy stores in the account.
         * </p>
         * 
         * @param policyStores
         *        The list of policy stores in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStores(Collection<PolicyStoreItem> policyStores);

        /**
         * <p>
         * The list of policy stores in the account.
         * </p>
         * 
         * @param policyStores
         *        The list of policy stores in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStores(PolicyStoreItem... policyStores);

        /**
         * <p>
         * The list of policy stores in the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem.Builder#build()} is called
         * immediately and its result is passed to {@link #policyStores(List<PolicyStoreItem>)}.
         * 
         * @param policyStores
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyStores(java.util.Collection<PolicyStoreItem>)
         */
        Builder policyStores(Consumer<PolicyStoreItem.Builder>... policyStores);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PolicyStoreItem> policyStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyStoresResponse model) {
            super(model);
            nextToken(model.nextToken);
            policyStores(model.policyStores);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PolicyStoreItem.Builder> getPolicyStores() {
            List<PolicyStoreItem.Builder> result = PolicyStoreListCopier.copyToBuilder(this.policyStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyStores(Collection<PolicyStoreItem.BuilderImpl> policyStores) {
            this.policyStores = PolicyStoreListCopier.copyFromBuilder(policyStores);
        }

        @Override
        public final Builder policyStores(Collection<PolicyStoreItem> policyStores) {
            this.policyStores = PolicyStoreListCopier.copy(policyStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStores(PolicyStoreItem... policyStores) {
            policyStores(Arrays.asList(policyStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStores(Consumer<PolicyStoreItem.Builder>... policyStores) {
            policyStores(Stream.of(policyStores).map(c -> PolicyStoreItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPolicyStoresResponse build() {
            return new ListPolicyStoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
