/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the details for a Cedar policy definition. It includes the policy type, a description, and
 * a policy body. This is a top level data type used to create a policy.
 * </p>
 * <p>
 * This data type is used as a request parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a>
 * operation. This structure must always have either an <code>static</code> or a <code>templateLinked</code> element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyDefinition.Builder, PolicyDefinition> {
    private static final SdkField<StaticPolicyDefinition> STATIC_FIELD = SdkField
            .<StaticPolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("static")
            .getter(getter(PolicyDefinition::staticValue)).setter(setter(Builder::staticValue))
            .constructor(StaticPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("static").build()).build();

    private static final SdkField<TemplateLinkedPolicyDefinition> TEMPLATE_LINKED_FIELD = SdkField
            .<TemplateLinkedPolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("templateLinked")
            .getter(getter(PolicyDefinition::templateLinked)).setter(setter(Builder::templateLinked))
            .constructor(TemplateLinkedPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLinked").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FIELD,
            TEMPLATE_LINKED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StaticPolicyDefinition staticValue;

    private final TemplateLinkedPolicyDefinition templateLinked;

    private final Type type;

    private PolicyDefinition(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.templateLinked = builder.templateLinked;
        this.type = builder.type;
    }

    /**
     * <p>
     * A structure that describes a static policy. An static policy doesn't use a template or allow placeholders for
     * entities.
     * </p>
     * 
     * @return A structure that describes a static policy. An static policy doesn't use a template or allow placeholders
     *         for entities.
     */
    public final StaticPolicyDefinition staticValue() {
        return staticValue;
    }

    /**
     * <p>
     * A structure that describes a policy that was instantiated from a template. The template can specify placeholders
     * for <code>principal</code> and <code>resource</code>. When you use <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a>
     * to create a policy from a template, you specify the exact principal and resource to use for the instantiated
     * policy.
     * </p>
     * 
     * @return A structure that describes a policy that was instantiated from a template. The template can specify
     *         placeholders for <code>principal</code> and <code>resource</code>. When you use <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html"
     *         >CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use
     *         for the instantiated policy.
     */
    public final TemplateLinkedPolicyDefinition templateLinked() {
        return templateLinked;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(templateLinked());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDefinition)) {
            return false;
        }
        PolicyDefinition other = (PolicyDefinition) obj;
        return Objects.equals(staticValue(), other.staticValue()) && Objects.equals(templateLinked(), other.templateLinked());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyDefinition").add("Static", staticValue()).add("TemplateLinked", templateLinked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "static":
            return Optional.ofNullable(clazz.cast(staticValue()));
        case "templateLinked":
            return Optional.ofNullable(clazz.cast(templateLinked()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #staticValue()} initialized to the given value.
     *
     * <p>
     * A structure that describes a static policy. An static policy doesn't use a template or allow placeholders for
     * entities.
     * </p>
     * 
     * @param staticValue
     *        A structure that describes a static policy. An static policy doesn't use a template or allow placeholders
     *        for entities.
     */
    public static PolicyDefinition fromStaticValue(StaticPolicyDefinition staticValue) {
        return builder().staticValue(staticValue).build();
    }

    /**
     * Create an instance of this class with {@link #staticValue()} initialized to the given value.
     *
     * <p>
     * A structure that describes a static policy. An static policy doesn't use a template or allow placeholders for
     * entities.
     * </p>
     * 
     * @param staticValue
     *        A structure that describes a static policy. An static policy doesn't use a template or allow placeholders
     *        for entities.
     */
    public static PolicyDefinition fromStaticValue(Consumer<StaticPolicyDefinition.Builder> staticValue) {
        StaticPolicyDefinition.Builder builder = StaticPolicyDefinition.builder();
        staticValue.accept(builder);
        return fromStaticValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #templateLinked()} initialized to the given value.
     *
     * <p>
     * A structure that describes a policy that was instantiated from a template. The template can specify placeholders
     * for <code>principal</code> and <code>resource</code>. When you use <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a>
     * to create a policy from a template, you specify the exact principal and resource to use for the instantiated
     * policy.
     * </p>
     * 
     * @param templateLinked
     *        A structure that describes a policy that was instantiated from a template. The template can specify
     *        placeholders for <code>principal</code> and <code>resource</code>. When you use <a
     *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html"
     *        >CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use
     *        for the instantiated policy.
     */
    public static PolicyDefinition fromTemplateLinked(TemplateLinkedPolicyDefinition templateLinked) {
        return builder().templateLinked(templateLinked).build();
    }

    /**
     * Create an instance of this class with {@link #templateLinked()} initialized to the given value.
     *
     * <p>
     * A structure that describes a policy that was instantiated from a template. The template can specify placeholders
     * for <code>principal</code> and <code>resource</code>. When you use <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a>
     * to create a policy from a template, you specify the exact principal and resource to use for the instantiated
     * policy.
     * </p>
     * 
     * @param templateLinked
     *        A structure that describes a policy that was instantiated from a template. The template can specify
     *        placeholders for <code>principal</code> and <code>resource</code>. When you use <a
     *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html"
     *        >CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use
     *        for the instantiated policy.
     */
    public static PolicyDefinition fromTemplateLinked(Consumer<TemplateLinkedPolicyDefinition.Builder> templateLinked) {
        TemplateLinkedPolicyDefinition.Builder builder = TemplateLinkedPolicyDefinition.builder();
        templateLinked.accept(builder);
        return fromTemplateLinked(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("static", STATIC_FIELD);
        map.put("templateLinked", TEMPLATE_LINKED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyDefinition, T> g) {
        return obj -> g.apply((PolicyDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyDefinition> {
        /**
         * <p>
         * A structure that describes a static policy. An static policy doesn't use a template or allow placeholders for
         * entities.
         * </p>
         * 
         * @param staticValue
         *        A structure that describes a static policy. An static policy doesn't use a template or allow
         *        placeholders for entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(StaticPolicyDefinition staticValue);

        /**
         * <p>
         * A structure that describes a static policy. An static policy doesn't use a template or allow placeholders for
         * entities.
         * </p>
         * This is a convenience method that creates an instance of the {@link StaticPolicyDefinition.Builder} avoiding
         * the need to create one manually via {@link StaticPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticPolicyDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #staticValue(StaticPolicyDefinition)}.
         * 
         * @param staticValue
         *        a consumer that will call methods on {@link StaticPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticValue(StaticPolicyDefinition)
         */
        default Builder staticValue(Consumer<StaticPolicyDefinition.Builder> staticValue) {
            return staticValue(StaticPolicyDefinition.builder().applyMutation(staticValue).build());
        }

        /**
         * <p>
         * A structure that describes a policy that was instantiated from a template. The template can specify
         * placeholders for <code>principal</code> and <code>resource</code>. When you use <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html"
         * >CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use for
         * the instantiated policy.
         * </p>
         * 
         * @param templateLinked
         *        A structure that describes a policy that was instantiated from a template. The template can specify
         *        placeholders for <code>principal</code> and <code>resource</code>. When you use <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html"
         *        >CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to
         *        use for the instantiated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateLinked(TemplateLinkedPolicyDefinition templateLinked);

        /**
         * <p>
         * A structure that describes a policy that was instantiated from a template. The template can specify
         * placeholders for <code>principal</code> and <code>resource</code>. When you use <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html"
         * >CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use for
         * the instantiated policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateLinkedPolicyDefinition.Builder}
         * avoiding the need to create one manually via {@link TemplateLinkedPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateLinkedPolicyDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #templateLinked(TemplateLinkedPolicyDefinition)}.
         * 
         * @param templateLinked
         *        a consumer that will call methods on {@link TemplateLinkedPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateLinked(TemplateLinkedPolicyDefinition)
         */
        default Builder templateLinked(Consumer<TemplateLinkedPolicyDefinition.Builder> templateLinked) {
            return templateLinked(TemplateLinkedPolicyDefinition.builder().applyMutation(templateLinked).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StaticPolicyDefinition staticValue;

        private TemplateLinkedPolicyDefinition templateLinked;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDefinition model) {
            staticValue(model.staticValue);
            templateLinked(model.templateLinked);
        }

        public final StaticPolicyDefinition.Builder getStaticValue() {
            return staticValue != null ? staticValue.toBuilder() : null;
        }

        public final void setStaticValue(StaticPolicyDefinition.BuilderImpl staticValue) {
            Object oldValue = this.staticValue;
            this.staticValue = staticValue != null ? staticValue.build() : null;
            handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
        }

        @Override
        public final Builder staticValue(StaticPolicyDefinition staticValue) {
            Object oldValue = this.staticValue;
            this.staticValue = staticValue;
            handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
            return this;
        }

        public final TemplateLinkedPolicyDefinition.Builder getTemplateLinked() {
            return templateLinked != null ? templateLinked.toBuilder() : null;
        }

        public final void setTemplateLinked(TemplateLinkedPolicyDefinition.BuilderImpl templateLinked) {
            Object oldValue = this.templateLinked;
            this.templateLinked = templateLinked != null ? templateLinked.build() : null;
            handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
        }

        @Override
        public final Builder templateLinked(TemplateLinkedPolicyDefinition templateLinked) {
            Object oldValue = this.templateLinked;
            this.templateLinked = templateLinked;
            handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
            return this;
        }

        @Override
        public PolicyDefinition build() {
            return new PolicyDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PolicyDefinition#type()
     */
    public enum Type {
        STATIC,

        TEMPLATE_LINKED,

        UNKNOWN_TO_SDK_VERSION
    }
}
