/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a policy that was created by instantiating a policy template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateLinkedPolicyDefinitionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateLinkedPolicyDefinitionDetail.Builder, TemplateLinkedPolicyDefinitionDetail> {
    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyTemplateId").getter(getter(TemplateLinkedPolicyDefinitionDetail::policyTemplateId))
            .setter(setter(Builder::policyTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()).build();

    private static final SdkField<EntityIdentifier> PRINCIPAL_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("principal")
            .getter(getter(TemplateLinkedPolicyDefinitionDetail::principal)).setter(setter(Builder::principal))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<EntityIdentifier> RESOURCE_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(TemplateLinkedPolicyDefinitionDetail::resource)).setter(setter(Builder::resource))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TEMPLATE_ID_FIELD,
            PRINCIPAL_FIELD, RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyTemplateId;

    private final EntityIdentifier principal;

    private final EntityIdentifier resource;

    private TemplateLinkedPolicyDefinitionDetail(BuilderImpl builder) {
        this.policyTemplateId = builder.policyTemplateId;
        this.principal = builder.principal;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The unique identifier of the policy template used to create this policy.
     * </p>
     * 
     * @return The unique identifier of the policy template used to create this policy.
     */
    public final String policyTemplateId() {
        return policyTemplateId;
    }

    /**
     * <p>
     * The principal associated with this template-linked policy. Verified Permissions substitutes this principal for
     * the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.
     * </p>
     * 
     * @return The principal associated with this template-linked policy. Verified Permissions substitutes this
     *         principal for the <code>?principal</code> placeholder in the policy template when it evaluates an
     *         authorization request.
     */
    public final EntityIdentifier principal() {
        return principal;
    }

    /**
     * <p>
     * The resource associated with this template-linked policy. Verified Permissions substitutes this resource for the
     * <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.
     * </p>
     * 
     * @return The resource associated with this template-linked policy. Verified Permissions substitutes this resource
     *         for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization
     *         request.
     */
    public final EntityIdentifier resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateLinkedPolicyDefinitionDetail)) {
            return false;
        }
        TemplateLinkedPolicyDefinitionDetail other = (TemplateLinkedPolicyDefinitionDetail) obj;
        return Objects.equals(policyTemplateId(), other.policyTemplateId()) && Objects.equals(principal(), other.principal())
                && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateLinkedPolicyDefinitionDetail").add("PolicyTemplateId", policyTemplateId())
                .add("Principal", principal()).add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyTemplateId":
            return Optional.ofNullable(clazz.cast(policyTemplateId()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateLinkedPolicyDefinitionDetail, T> g) {
        return obj -> g.apply((TemplateLinkedPolicyDefinitionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateLinkedPolicyDefinitionDetail> {
        /**
         * <p>
         * The unique identifier of the policy template used to create this policy.
         * </p>
         * 
         * @param policyTemplateId
         *        The unique identifier of the policy template used to create this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTemplateId(String policyTemplateId);

        /**
         * <p>
         * The principal associated with this template-linked policy. Verified Permissions substitutes this principal
         * for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization
         * request.
         * </p>
         * 
         * @param principal
         *        The principal associated with this template-linked policy. Verified Permissions substitutes this
         *        principal for the <code>?principal</code> placeholder in the policy template when it evaluates an
         *        authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(EntityIdentifier principal);

        /**
         * <p>
         * The principal associated with this template-linked policy. Verified Permissions substitutes this principal
         * for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization
         * request.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(EntityIdentifier)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(EntityIdentifier)
         */
        default Builder principal(Consumer<EntityIdentifier.Builder> principal) {
            return principal(EntityIdentifier.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The resource associated with this template-linked policy. Verified Permissions substitutes this resource for
         * the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.
         * </p>
         * 
         * @param resource
         *        The resource associated with this template-linked policy. Verified Permissions substitutes this
         *        resource for the <code>?resource</code> placeholder in the policy template when it evaluates an
         *        authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(EntityIdentifier resource);

        /**
         * <p>
         * The resource associated with this template-linked policy. Verified Permissions substitutes this resource for
         * the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(EntityIdentifier)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(EntityIdentifier)
         */
        default Builder resource(Consumer<EntityIdentifier.Builder> resource) {
            return resource(EntityIdentifier.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyTemplateId;

        private EntityIdentifier principal;

        private EntityIdentifier resource;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateLinkedPolicyDefinitionDetail model) {
            policyTemplateId(model.policyTemplateId);
            principal(model.principal);
            resource(model.resource);
        }

        public final String getPolicyTemplateId() {
            return policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public final EntityIdentifier.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityIdentifier.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityIdentifier principal) {
            this.principal = principal;
            return this;
        }

        public final EntityIdentifier.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(EntityIdentifier.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityIdentifier resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public TemplateLinkedPolicyDefinitionDetail build() {
            return new TemplateLinkedPolicyDefinitionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
