/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentitySourceRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<UpdateIdentitySourceRequest.Builder, UpdateIdentitySourceRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(UpdateIdentitySourceRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> IDENTITY_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identitySourceId").getter(getter(UpdateIdentitySourceRequest::identitySourceId))
            .setter(setter(Builder::identitySourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySourceId").build()).build();

    private static final SdkField<UpdateConfiguration> UPDATE_CONFIGURATION_FIELD = SdkField
            .<UpdateConfiguration> builder(MarshallingType.SDK_POJO).memberName("updateConfiguration")
            .getter(getter(UpdateIdentitySourceRequest::updateConfiguration)).setter(setter(Builder::updateConfiguration))
            .constructor(UpdateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateConfiguration").build())
            .build();

    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalEntityType").getter(getter(UpdateIdentitySourceRequest::principalEntityType))
            .setter(setter(Builder::principalEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            IDENTITY_SOURCE_ID_FIELD, UPDATE_CONFIGURATION_FIELD, PRINCIPAL_ENTITY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final String identitySourceId;

    private final UpdateConfiguration updateConfiguration;

    private final String principalEntityType;

    private UpdateIdentitySourceRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.identitySourceId = builder.identitySourceId;
        this.updateConfiguration = builder.updateConfiguration;
        this.principalEntityType = builder.principalEntityType;
    }

    /**
     * <p>
     * Specifies the ID of the policy store that contains the identity source that you want to update.
     * </p>
     * 
     * @return Specifies the ID of the policy store that contains the identity source that you want to update.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the ID of the identity source that you want to update.
     * </p>
     * 
     * @return Specifies the ID of the identity source that you want to update.
     */
    public final String identitySourceId() {
        return identitySourceId;
    }

    /**
     * <p>
     * Specifies the details required to communicate with the identity provider (IdP) associated with this identity
     * source.
     * </p>
     * 
     * @return Specifies the details required to communicate with the identity provider (IdP) associated with this
     *         identity source.
     */
    public final UpdateConfiguration updateConfiguration() {
        return updateConfiguration;
    }

    /**
     * <p>
     * Specifies the data type of principals generated for identities authenticated by the identity source.
     * </p>
     * 
     * @return Specifies the data type of principals generated for identities authenticated by the identity source.
     */
    public final String principalEntityType() {
        return principalEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceId());
        hashCode = 31 * hashCode + Objects.hashCode(updateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(principalEntityType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentitySourceRequest)) {
            return false;
        }
        UpdateIdentitySourceRequest other = (UpdateIdentitySourceRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(identitySourceId(), other.identitySourceId())
                && Objects.equals(updateConfiguration(), other.updateConfiguration())
                && Objects.equals(principalEntityType(), other.principalEntityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdentitySourceRequest").add("PolicyStoreId", policyStoreId())
                .add("IdentitySourceId", identitySourceId()).add("UpdateConfiguration", updateConfiguration())
                .add("PrincipalEntityType", principalEntityType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "identitySourceId":
            return Optional.ofNullable(clazz.cast(identitySourceId()));
        case "updateConfiguration":
            return Optional.ofNullable(clazz.cast(updateConfiguration()));
        case "principalEntityType":
            return Optional.ofNullable(clazz.cast(principalEntityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("identitySourceId", IDENTITY_SOURCE_ID_FIELD);
        map.put("updateConfiguration", UPDATE_CONFIGURATION_FIELD);
        map.put("principalEntityType", PRINCIPAL_ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentitySourceRequest, T> g) {
        return obj -> g.apply((UpdateIdentitySourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentitySourceRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store that contains the identity source that you want to update.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store that contains the identity source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the ID of the identity source that you want to update.
         * </p>
         * 
         * @param identitySourceId
         *        Specifies the ID of the identity source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceId(String identitySourceId);

        /**
         * <p>
         * Specifies the details required to communicate with the identity provider (IdP) associated with this identity
         * source.
         * </p>
         * 
         * @param updateConfiguration
         *        Specifies the details required to communicate with the identity provider (IdP) associated with this
         *        identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateConfiguration(UpdateConfiguration updateConfiguration);

        /**
         * <p>
         * Specifies the details required to communicate with the identity provider (IdP) associated with this identity
         * source.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateConfiguration.Builder} avoiding the
         * need to create one manually via {@link UpdateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #updateConfiguration(UpdateConfiguration)}.
         * 
         * @param updateConfiguration
         *        a consumer that will call methods on {@link UpdateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateConfiguration(UpdateConfiguration)
         */
        default Builder updateConfiguration(Consumer<UpdateConfiguration.Builder> updateConfiguration) {
            return updateConfiguration(UpdateConfiguration.builder().applyMutation(updateConfiguration).build());
        }

        /**
         * <p>
         * Specifies the data type of principals generated for identities authenticated by the identity source.
         * </p>
         * 
         * @param principalEntityType
         *        Specifies the data type of principals generated for identities authenticated by the identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalEntityType(String principalEntityType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private String identitySourceId;

        private UpdateConfiguration updateConfiguration;

        private String principalEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentitySourceRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            identitySourceId(model.identitySourceId);
            updateConfiguration(model.updateConfiguration);
            principalEntityType(model.principalEntityType);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getIdentitySourceId() {
            return identitySourceId;
        }

        public final void setIdentitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
        }

        @Override
        public final Builder identitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        public final UpdateConfiguration.Builder getUpdateConfiguration() {
            return updateConfiguration != null ? updateConfiguration.toBuilder() : null;
        }

        public final void setUpdateConfiguration(UpdateConfiguration.BuilderImpl updateConfiguration) {
            this.updateConfiguration = updateConfiguration != null ? updateConfiguration.build() : null;
        }

        @Override
        public final Builder updateConfiguration(UpdateConfiguration updateConfiguration) {
            this.updateConfiguration = updateConfiguration;
            return this;
        }

        public final String getPrincipalEntityType() {
            return principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentitySourceRequest build() {
            return new UpdateIdentitySourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
