/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about updates to be applied to a policy.
 * </p>
 * <p>
 * This data type is used as a request parameter in the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html">UpdatePolicy</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePolicyDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatePolicyDefinition.Builder, UpdatePolicyDefinition> {
    private static final SdkField<UpdateStaticPolicyDefinition> STATIC_FIELD = SdkField
            .<UpdateStaticPolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("static")
            .getter(getter(UpdatePolicyDefinition::staticValue)).setter(setter(Builder::staticValue))
            .constructor(UpdateStaticPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("static").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateStaticPolicyDefinition staticValue;

    private final Type type;

    private UpdatePolicyDefinition(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains details about the updates to be applied to a static policy.
     * </p>
     * 
     * @return Contains details about the updates to be applied to a static policy.
     */
    public final UpdateStaticPolicyDefinition staticValue() {
        return staticValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyDefinition)) {
            return false;
        }
        UpdatePolicyDefinition other = (UpdatePolicyDefinition) obj;
        return Objects.equals(staticValue(), other.staticValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePolicyDefinition").add("Static", staticValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "static":
            return Optional.ofNullable(clazz.cast(staticValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #staticValue()} initialized to the given value.
     *
     * <p>
     * Contains details about the updates to be applied to a static policy.
     * </p>
     * 
     * @param staticValue
     *        Contains details about the updates to be applied to a static policy.
     */
    public static UpdatePolicyDefinition fromStaticValue(UpdateStaticPolicyDefinition staticValue) {
        return builder().staticValue(staticValue).build();
    }

    /**
     * Create an instance of this class with {@link #staticValue()} initialized to the given value.
     *
     * <p>
     * Contains details about the updates to be applied to a static policy.
     * </p>
     * 
     * @param staticValue
     *        Contains details about the updates to be applied to a static policy.
     */
    public static UpdatePolicyDefinition fromStaticValue(Consumer<UpdateStaticPolicyDefinition.Builder> staticValue) {
        UpdateStaticPolicyDefinition.Builder builder = UpdateStaticPolicyDefinition.builder();
        staticValue.accept(builder);
        return fromStaticValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("static", STATIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyDefinition, T> g) {
        return obj -> g.apply((UpdatePolicyDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePolicyDefinition> {
        /**
         * <p>
         * Contains details about the updates to be applied to a static policy.
         * </p>
         * 
         * @param staticValue
         *        Contains details about the updates to be applied to a static policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(UpdateStaticPolicyDefinition staticValue);

        /**
         * <p>
         * Contains details about the updates to be applied to a static policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateStaticPolicyDefinition.Builder}
         * avoiding the need to create one manually via {@link UpdateStaticPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateStaticPolicyDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #staticValue(UpdateStaticPolicyDefinition)}.
         * 
         * @param staticValue
         *        a consumer that will call methods on {@link UpdateStaticPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticValue(UpdateStaticPolicyDefinition)
         */
        default Builder staticValue(Consumer<UpdateStaticPolicyDefinition.Builder> staticValue) {
            return staticValue(UpdateStaticPolicyDefinition.builder().applyMutation(staticValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateStaticPolicyDefinition staticValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyDefinition model) {
            staticValue(model.staticValue);
        }

        public final UpdateStaticPolicyDefinition.Builder getStaticValue() {
            return staticValue != null ? staticValue.toBuilder() : null;
        }

        public final void setStaticValue(UpdateStaticPolicyDefinition.BuilderImpl staticValue) {
            Object oldValue = this.staticValue;
            this.staticValue = staticValue != null ? staticValue.build() : null;
            handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
        }

        @Override
        public final Builder staticValue(UpdateStaticPolicyDefinition staticValue) {
            Object oldValue = this.staticValue;
            this.staticValue = staticValue;
            handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
            return this;
        }

        @Override
        public UpdatePolicyDefinition build() {
            return new UpdatePolicyDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdatePolicyDefinition#type()
     */
    public enum Type {
        STATIC,

        UNKNOWN_TO_SDK_VERSION
    }
}
