/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePolicyRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<UpdatePolicyRequest.Builder, UpdatePolicyRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(UpdatePolicyRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyId").getter(getter(UpdatePolicyRequest::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()).build();

    private static final SdkField<UpdatePolicyDefinition> DEFINITION_FIELD = SdkField
            .<UpdatePolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(UpdatePolicyRequest::definition)).setter(setter(Builder::definition))
            .constructor(UpdatePolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            POLICY_ID_FIELD, DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final String policyId;

    private final UpdatePolicyDefinition definition;

    private UpdatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyId = builder.policyId;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * Specifies the ID of the policy store that contains the policy that you want to update.
     * </p>
     * 
     * @return Specifies the ID of the policy store that contains the policy that you want to update.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the ID of the policy that you want to update. To find this value, you can use <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html"
     * >ListPolicies</a>.
     * </p>
     * 
     * @return Specifies the ID of the policy that you want to update. To find this value, you can use <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html"
     *         >ListPolicies</a>.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * Specifies the updated policy content that you want to replace on the specified policy. The content must be valid
     * Cedar policy language text.
     * </p>
     * <p>
     * You can change only the following elements from the policy definition:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>action</code> referenced by the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You <b>can't</b> change the following elements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Changing from <code>static</code> to <code>templateLinked</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Changing the effect of the policy from <code>permit</code> or <code>forbid</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>principal</code> referenced by the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>resource</code> referenced by the policy.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the updated policy content that you want to replace on the specified policy. The content must
     *         be valid Cedar policy language text.</p>
     *         <p>
     *         You can change only the following elements from the policy definition:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>action</code> referenced by the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You <b>can't</b> change the following elements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Changing from <code>static</code> to <code>templateLinked</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Changing the effect of the policy from <code>permit</code> or <code>forbid</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>principal</code> referenced by the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>resource</code> referenced by the policy.
     *         </p>
     *         </li>
     */
    public final UpdatePolicyDefinition definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyRequest)) {
            return false;
        }
        UpdatePolicyRequest other = (UpdatePolicyRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(policyId(), other.policyId())
                && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePolicyRequest").add("PolicyStoreId", policyStoreId()).add("PolicyId", policyId())
                .add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "policyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyId", POLICY_ID_FIELD);
        map.put("definition", DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyRequest, T> g) {
        return obj -> g.apply((UpdatePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePolicyRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store that contains the policy that you want to update.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store that contains the policy that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the ID of the policy that you want to update. To find this value, you can use <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html"
         * >ListPolicies</a>.
         * </p>
         * 
         * @param policyId
         *        Specifies the ID of the policy that you want to update. To find this value, you can use <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html"
         *        >ListPolicies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * Specifies the updated policy content that you want to replace on the specified policy. The content must be
         * valid Cedar policy language text.
         * </p>
         * <p>
         * You can change only the following elements from the policy definition:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>action</code> referenced by the policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You <b>can't</b> change the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Changing from <code>static</code> to <code>templateLinked</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Changing the effect of the policy from <code>permit</code> or <code>forbid</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>principal</code> referenced by the policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>resource</code> referenced by the policy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param definition
         *        Specifies the updated policy content that you want to replace on the specified policy. The content
         *        must be valid Cedar policy language text.</p>
         *        <p>
         *        You can change only the following elements from the policy definition:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>action</code> referenced by the policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You <b>can't</b> change the following elements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Changing from <code>static</code> to <code>templateLinked</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Changing the effect of the policy from <code>permit</code> or <code>forbid</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>principal</code> referenced by the policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>resource</code> referenced by the policy.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(UpdatePolicyDefinition definition);

        /**
         * <p>
         * Specifies the updated policy content that you want to replace on the specified policy. The content must be
         * valid Cedar policy language text.
         * </p>
         * <p>
         * You can change only the following elements from the policy definition:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>action</code> referenced by the policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * Any conditional clauses, such as <code>when</code> or <code>unless</code> clauses.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You <b>can't</b> change the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Changing from <code>static</code> to <code>templateLinked</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Changing the effect of the policy from <code>permit</code> or <code>forbid</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>principal</code> referenced by the policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>resource</code> referenced by the policy.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link UpdatePolicyDefinition.Builder} avoiding
         * the need to create one manually via {@link UpdatePolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePolicyDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #definition(UpdatePolicyDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link UpdatePolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(UpdatePolicyDefinition)
         */
        default Builder definition(Consumer<UpdatePolicyDefinition.Builder> definition) {
            return definition(UpdatePolicyDefinition.builder().applyMutation(definition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private String policyId;

        private UpdatePolicyDefinition definition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            policyId(model.policyId);
            definition(model.definition);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final UpdatePolicyDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(UpdatePolicyDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(UpdatePolicyDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePolicyRequest build() {
            return new UpdatePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
