/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyTemplateResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, CreatePolicyTemplateResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(CreatePolicyTemplateResponse.getter(CreatePolicyTemplateResponse::policyStoreId)).setter(CreatePolicyTemplateResponse.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyTemplateId").getter(CreatePolicyTemplateResponse.getter(CreatePolicyTemplateResponse::policyTemplateId)).setter(CreatePolicyTemplateResponse.setter(Builder::policyTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(CreatePolicyTemplateResponse.getter(CreatePolicyTemplateResponse::createdDate)).setter(CreatePolicyTemplateResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(CreatePolicyTemplateResponse.getter(CreatePolicyTemplateResponse::lastUpdatedDate)).setter(CreatePolicyTemplateResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, POLICY_TEMPLATE_ID_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePolicyTemplateResponse.memberNameToFieldInitializer();
    private final String policyStoreId;
    private final String policyTemplateId;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;

    private CreatePolicyTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyTemplateId = builder.policyTemplateId;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String policyTemplateId() {
        return this.policyTemplateId;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyTemplateResponse)) {
            return false;
        }
        CreatePolicyTemplateResponse other = (CreatePolicyTemplateResponse)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.policyTemplateId(), other.policyTemplateId()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePolicyTemplateResponse").add("PolicyStoreId", (Object)this.policyStoreId()).add("PolicyTemplateId", (Object)this.policyTemplateId()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "policyTemplateId": {
                return Optional.ofNullable(clazz.cast(this.policyTemplateId()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyTemplateResponse, T> g) {
        return obj -> g.apply((CreatePolicyTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String policyTemplateId;
        private Instant createdDate;
        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyTemplateResponse model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.policyTemplateId(model.policyTemplateId);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyTemplateId() {
            return this.policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        @Override
        public CreatePolicyTemplateResponse build() {
            return new CreatePolicyTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyTemplateResponse> {
        public Builder policyStoreId(String var1);

        public Builder policyTemplateId(String var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);
    }
}

