/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePolicyTemplateResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<UpdatePolicyTemplateResponse.Builder, UpdatePolicyTemplateResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(UpdatePolicyTemplateResponse::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyTemplateId").getter(getter(UpdatePolicyTemplateResponse::policyTemplateId))
            .setter(setter(Builder::policyTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate")
            .getter(getter(UpdatePolicyTemplateResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate")
            .getter(getter(UpdatePolicyTemplateResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            POLICY_TEMPLATE_ID_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final String policyTemplateId;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private UpdatePolicyTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyTemplateId = builder.policyTemplateId;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    /**
     * <p>
     * The ID of the policy store that contains the updated policy template.
     * </p>
     * 
     * @return The ID of the policy store that contains the updated policy template.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * The ID of the updated policy template.
     * </p>
     * 
     * @return The ID of the updated policy template.
     */
    public final String policyTemplateId() {
        return policyTemplateId;
    }

    /**
     * <p>
     * The date and time that the policy template was originally created.
     * </p>
     * 
     * @return The date and time that the policy template was originally created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date and time that the policy template was most recently updated.
     * </p>
     * 
     * @return The date and time that the policy template was most recently updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyTemplateResponse)) {
            return false;
        }
        UpdatePolicyTemplateResponse other = (UpdatePolicyTemplateResponse) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(policyTemplateId(), other.policyTemplateId())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePolicyTemplateResponse").add("PolicyStoreId", policyStoreId())
                .add("PolicyTemplateId", policyTemplateId()).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "policyTemplateId":
            return Optional.ofNullable(clazz.cast(policyTemplateId()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicyTemplateResponse, T> g) {
        return obj -> g.apply((UpdatePolicyTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePolicyTemplateResponse> {
        /**
         * <p>
         * The ID of the policy store that contains the updated policy template.
         * </p>
         * 
         * @param policyStoreId
         *        The ID of the policy store that contains the updated policy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * The ID of the updated policy template.
         * </p>
         * 
         * @param policyTemplateId
         *        The ID of the updated policy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTemplateId(String policyTemplateId);

        /**
         * <p>
         * The date and time that the policy template was originally created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the policy template was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date and time that the policy template was most recently updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time that the policy template was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private String policyStoreId;

        private String policyTemplateId;

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyTemplateResponse model) {
            super(model);
            policyStoreId(model.policyStoreId);
            policyTemplateId(model.policyTemplateId);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyTemplateId() {
            return policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        @Override
        public UpdatePolicyTemplateResponse build() {
            return new UpdatePolicyTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
