/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information about an identity source.
 * </p>
 * <p>
 * This data type is a response parameter to the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html"
 * >GetIdentitySource</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationDetail.Builder, ConfigurationDetail> {
    private static final SdkField<CognitoUserPoolConfigurationDetail> COGNITO_USER_POOL_CONFIGURATION_FIELD = SdkField
            .<CognitoUserPoolConfigurationDetail> builder(MarshallingType.SDK_POJO)
            .memberName("cognitoUserPoolConfiguration")
            .getter(getter(ConfigurationDetail::cognitoUserPoolConfiguration))
            .setter(setter(Builder::cognitoUserPoolConfiguration))
            .constructor(CognitoUserPoolConfigurationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoUserPoolConfiguration")
                    .build()).build();

    private static final SdkField<OpenIdConnectConfigurationDetail> OPEN_ID_CONNECT_CONFIGURATION_FIELD = SdkField
            .<OpenIdConnectConfigurationDetail> builder(MarshallingType.SDK_POJO)
            .memberName("openIdConnectConfiguration")
            .getter(getter(ConfigurationDetail::openIdConnectConfiguration))
            .setter(setter(Builder::openIdConnectConfiguration))
            .constructor(OpenIdConnectConfigurationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIdConnectConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COGNITO_USER_POOL_CONFIGURATION_FIELD, OPEN_ID_CONNECT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration;

    private final OpenIdConnectConfigurationDetail openIdConnectConfiguration;

    private final Type type;

    private ConfigurationDetail(BuilderImpl builder) {
        this.cognitoUserPoolConfiguration = builder.cognitoUserPoolConfiguration;
        this.openIdConnectConfiguration = builder.openIdConnectConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
     * authenticated identities as entities. It specifies the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and one or more
     * application client IDs.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
     * </p>
     * 
     * @return Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a
     *         source of authenticated identities as entities. It specifies the <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups,
     *         and one or more application client IDs.</p>
     *         <p>
     *         Example:
     *         <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
     */
    public final CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration() {
        return cognitoUserPoolConfiguration;
    }

    /**
     * <p>
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified
     * Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type
     * that you want to use, and policy store entity details.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
     * </p>
     * 
     * @return Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
     *         Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer
     *         URL, token type that you want to use, and policy store entity details.</p>
     *         <p>
     *         Example:
     *         <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
     */
    public final OpenIdConnectConfigurationDetail openIdConnectConfiguration() {
        return openIdConnectConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cognitoUserPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openIdConnectConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDetail)) {
            return false;
        }
        ConfigurationDetail other = (ConfigurationDetail) obj;
        return Objects.equals(cognitoUserPoolConfiguration(), other.cognitoUserPoolConfiguration())
                && Objects.equals(openIdConnectConfiguration(), other.openIdConnectConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationDetail").add("CognitoUserPoolConfiguration", cognitoUserPoolConfiguration())
                .add("OpenIdConnectConfiguration", openIdConnectConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cognitoUserPoolConfiguration":
            return Optional.ofNullable(clazz.cast(cognitoUserPoolConfiguration()));
        case "openIdConnectConfiguration":
            return Optional.ofNullable(clazz.cast(openIdConnectConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cognitoUserPoolConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
     * authenticated identities as entities. It specifies the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and one or more
     * application client IDs.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
     * </p>
     * 
     * @param cognitoUserPoolConfiguration
     *        Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source
     *        of authenticated identities as entities. It specifies the <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *        (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups,
     *        and one or more application client IDs.</p>
     *        <p>
     *        Example:
     *        <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
     */
    public static ConfigurationDetail fromCognitoUserPoolConfiguration(
            CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration) {
        return builder().cognitoUserPoolConfiguration(cognitoUserPoolConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #cognitoUserPoolConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
     * authenticated identities as entities. It specifies the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and one or more
     * application client IDs.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
     * </p>
     * 
     * @param cognitoUserPoolConfiguration
     *        Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source
     *        of authenticated identities as entities. It specifies the <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *        (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups,
     *        and one or more application client IDs.</p>
     *        <p>
     *        Example:
     *        <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
     */
    public static ConfigurationDetail fromCognitoUserPoolConfiguration(
            Consumer<CognitoUserPoolConfigurationDetail.Builder> cognitoUserPoolConfiguration) {
        CognitoUserPoolConfigurationDetail.Builder builder = CognitoUserPoolConfigurationDetail.builder();
        cognitoUserPoolConfiguration.accept(builder);
        return fromCognitoUserPoolConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #openIdConnectConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified
     * Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type
     * that you want to use, and policy store entity details.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
     * </p>
     * 
     * @param openIdConnectConfiguration
     *        Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
     *        Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer
     *        URL, token type that you want to use, and policy store entity details.</p>
     *        <p>
     *        Example:
     *        <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
     */
    public static ConfigurationDetail fromOpenIdConnectConfiguration(OpenIdConnectConfigurationDetail openIdConnectConfiguration) {
        return builder().openIdConnectConfiguration(openIdConnectConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #openIdConnectConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified
     * Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type
     * that you want to use, and policy store entity details.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
     * </p>
     * 
     * @param openIdConnectConfiguration
     *        Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
     *        Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer
     *        URL, token type that you want to use, and policy store entity details.</p>
     *        <p>
     *        Example:
     *        <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
     */
    public static ConfigurationDetail fromOpenIdConnectConfiguration(
            Consumer<OpenIdConnectConfigurationDetail.Builder> openIdConnectConfiguration) {
        OpenIdConnectConfigurationDetail.Builder builder = OpenIdConnectConfigurationDetail.builder();
        openIdConnectConfiguration.accept(builder);
        return fromOpenIdConnectConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cognitoUserPoolConfiguration", COGNITO_USER_POOL_CONFIGURATION_FIELD);
        map.put("openIdConnectConfiguration", OPEN_ID_CONNECT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDetail, T> g) {
        return obj -> g.apply((ConfigurationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationDetail> {
        /**
         * <p>
         * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
         * authenticated identities as entities. It specifies the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and
         * one or more application client IDs.
         * </p>
         * <p>
         * Example:
         * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
         * </p>
         * 
         * @param cognitoUserPoolConfiguration
         *        Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a
         *        source of authenticated identities as entities. It specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user
         *        groups, and one or more application client IDs.</p>
         *        <p>
         *        Example:
         *        <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration);

        /**
         * <p>
         * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
         * authenticated identities as entities. It specifies the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of a Amazon Cognito user pool, the policy store entity that you want to assign to user groups, and
         * one or more application client IDs.
         * </p>
         * <p>
         * Example:
         * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CognitoUserPoolConfigurationDetail.Builder} avoiding the need to create one manually via
         * {@link CognitoUserPoolConfigurationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoUserPoolConfigurationDetail.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail)}.
         * 
         * @param cognitoUserPoolConfiguration
         *        a consumer that will call methods on {@link CognitoUserPoolConfigurationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail)
         */
        default Builder cognitoUserPoolConfiguration(
                Consumer<CognitoUserPoolConfigurationDetail.Builder> cognitoUserPoolConfiguration) {
            return cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail.builder()
                    .applyMutation(cognitoUserPoolConfiguration).build());
        }

        /**
         * <p>
         * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
         * Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL,
         * token type that you want to use, and policy store entity details.
         * </p>
         * <p>
         * Example:
         * <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
         * </p>
         * 
         * @param openIdConnectConfiguration
         *        Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
         *        Verified Permissions can use to generate entities from authenticated identities. It specifies the
         *        issuer URL, token type that you want to use, and policy store entity details.</p>
         *        <p>
         *        Example:
         *        <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectConfiguration(OpenIdConnectConfigurationDetail openIdConnectConfiguration);

        /**
         * <p>
         * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that
         * Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL,
         * token type that you want to use, and policy store entity details.
         * </p>
         * <p>
         * Example:
         * <code>"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenIdConnectConfigurationDetail.Builder}
         * avoiding the need to create one manually via {@link OpenIdConnectConfigurationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIdConnectConfigurationDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #openIdConnectConfiguration(OpenIdConnectConfigurationDetail)}.
         * 
         * @param openIdConnectConfiguration
         *        a consumer that will call methods on {@link OpenIdConnectConfigurationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIdConnectConfiguration(OpenIdConnectConfigurationDetail)
         */
        default Builder openIdConnectConfiguration(Consumer<OpenIdConnectConfigurationDetail.Builder> openIdConnectConfiguration) {
            return openIdConnectConfiguration(OpenIdConnectConfigurationDetail.builder()
                    .applyMutation(openIdConnectConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration;

        private OpenIdConnectConfigurationDetail openIdConnectConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDetail model) {
            cognitoUserPoolConfiguration(model.cognitoUserPoolConfiguration);
            openIdConnectConfiguration(model.openIdConnectConfiguration);
        }

        public final CognitoUserPoolConfigurationDetail.Builder getCognitoUserPoolConfiguration() {
            return cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.toBuilder() : null;
        }

        public final void setCognitoUserPoolConfiguration(
                CognitoUserPoolConfigurationDetail.BuilderImpl cognitoUserPoolConfiguration) {
            Object oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.build()
                    : null;
            handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
        }

        @Override
        public final Builder cognitoUserPoolConfiguration(CognitoUserPoolConfigurationDetail cognitoUserPoolConfiguration) {
            Object oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
            handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
            return this;
        }

        public final OpenIdConnectConfigurationDetail.Builder getOpenIdConnectConfiguration() {
            return openIdConnectConfiguration != null ? openIdConnectConfiguration.toBuilder() : null;
        }

        public final void setOpenIdConnectConfiguration(OpenIdConnectConfigurationDetail.BuilderImpl openIdConnectConfiguration) {
            Object oldValue = this.openIdConnectConfiguration;
            this.openIdConnectConfiguration = openIdConnectConfiguration != null ? openIdConnectConfiguration.build() : null;
            handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIdConnectConfiguration);
        }

        @Override
        public final Builder openIdConnectConfiguration(OpenIdConnectConfigurationDetail openIdConnectConfiguration) {
            Object oldValue = this.openIdConnectConfiguration;
            this.openIdConnectConfiguration = openIdConnectConfiguration;
            handleUnionValueChange(Type.OPEN_ID_CONNECT_CONFIGURATION, oldValue, this.openIdConnectConfiguration);
            return this;
        }

        @Override
        public ConfigurationDetail build() {
            return new ConfigurationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConfigurationDetail#type()
     */
    public enum Type {
        COGNITO_USER_POOL_CONFIGURATION,

        OPEN_ID_CONNECT_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
