/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyErrorItem;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyErrorListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyOutputItem;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyOutputListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetPolicyResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, BatchGetPolicyResponse> {
    private static final SdkField<List<BatchGetPolicyOutputItem>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("results").getter(BatchGetPolicyResponse.getter(BatchGetPolicyResponse::results)).setter(BatchGetPolicyResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetPolicyOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetPolicyErrorItem>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetPolicyResponse.getter(BatchGetPolicyResponse::errors)).setter(BatchGetPolicyResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetPolicyErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetPolicyResponse.memberNameToFieldInitializer();
    private final List<BatchGetPolicyOutputItem> results;
    private final List<BatchGetPolicyErrorItem> errors;

    private BatchGetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.errors = builder.errors;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<BatchGetPolicyOutputItem> results() {
        return this.results;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetPolicyErrorItem> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPolicyResponse)) {
            return false;
        }
        BatchGetPolicyResponse other = (BatchGetPolicyResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetPolicyResponse").add("Results", this.hasResults() ? this.results() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("results", RESULTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPolicyResponse, T> g) {
        return obj -> g.apply((BatchGetPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private List<BatchGetPolicyOutputItem> results = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetPolicyErrorItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPolicyResponse model) {
            super(model);
            this.results(model.results);
            this.errors(model.errors);
        }

        public final List<BatchGetPolicyOutputItem.Builder> getResults() {
            List<BatchGetPolicyOutputItem.Builder> result = BatchGetPolicyOutputListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<BatchGetPolicyOutputItem.BuilderImpl> results) {
            this.results = BatchGetPolicyOutputListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<BatchGetPolicyOutputItem> results) {
            this.results = BatchGetPolicyOutputListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchGetPolicyOutputItem ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<BatchGetPolicyOutputItem.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (BatchGetPolicyOutputItem)((BatchGetPolicyOutputItem.Builder)BatchGetPolicyOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetPolicyErrorItem.Builder> getErrors() {
            List<BatchGetPolicyErrorItem.Builder> result = BatchGetPolicyErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetPolicyErrorItem.BuilderImpl> errors) {
            this.errors = BatchGetPolicyErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetPolicyErrorItem> errors) {
            this.errors = BatchGetPolicyErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetPolicyErrorItem ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetPolicyErrorItem.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetPolicyErrorItem)((BatchGetPolicyErrorItem.Builder)BatchGetPolicyErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetPolicyResponse build() {
            return new BatchGetPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetPolicyResponse> {
        public Builder results(Collection<BatchGetPolicyOutputItem> var1);

        public Builder results(BatchGetPolicyOutputItem ... var1);

        public Builder results(Consumer<BatchGetPolicyOutputItem.Builder> ... var1);

        public Builder errors(Collection<BatchGetPolicyErrorItem> var1);

        public Builder errors(BatchGetPolicyErrorItem ... var1);

        public Builder errors(Consumer<BatchGetPolicyErrorItem.Builder> ... var1);
    }
}

