/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication result produced by Voice ID, processed against the current session state and streamed audio of the
 * speaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationResult.Builder, AuthenticationResult> {
    private static final SdkField<Instant> AUDIO_AGGREGATION_ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AudioAggregationEndedAt").getter(getter(AuthenticationResult::audioAggregationEndedAt))
            .setter(setter(Builder::audioAggregationEndedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioAggregationEndedAt").build())
            .build();

    private static final SdkField<Instant> AUDIO_AGGREGATION_STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("AudioAggregationStartedAt")
            .getter(getter(AuthenticationResult::audioAggregationStartedAt)).setter(setter(Builder::audioAggregationStartedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioAggregationStartedAt").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationResultId").getter(getter(AuthenticationResult::authenticationResultId))
            .setter(setter(Builder::authenticationResultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResultId").build())
            .build();

    private static final SdkField<AuthenticationConfiguration> CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(AuthenticationResult::configuration)).setter(setter(Builder::configuration))
            .constructor(AuthenticationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> CUSTOMER_SPEAKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerSpeakerId").getter(getter(AuthenticationResult::customerSpeakerId))
            .setter(setter(Builder::customerSpeakerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerSpeakerId").build()).build();

    private static final SdkField<String> DECISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Decision").getter(getter(AuthenticationResult::decisionAsString)).setter(setter(Builder::decision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decision").build()).build();

    private static final SdkField<String> GENERATED_SPEAKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedSpeakerId").getter(getter(AuthenticationResult::generatedSpeakerId))
            .setter(setter(Builder::generatedSpeakerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedSpeakerId").build())
            .build();

    private static final SdkField<Integer> SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Score")
            .getter(getter(AuthenticationResult::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUDIO_AGGREGATION_ENDED_AT_FIELD, AUDIO_AGGREGATION_STARTED_AT_FIELD, AUTHENTICATION_RESULT_ID_FIELD,
            CONFIGURATION_FIELD, CUSTOMER_SPEAKER_ID_FIELD, DECISION_FIELD, GENERATED_SPEAKER_ID_FIELD, SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant audioAggregationEndedAt;

    private final Instant audioAggregationStartedAt;

    private final String authenticationResultId;

    private final AuthenticationConfiguration configuration;

    private final String customerSpeakerId;

    private final String decision;

    private final String generatedSpeakerId;

    private final Integer score;

    private AuthenticationResult(BuilderImpl builder) {
        this.audioAggregationEndedAt = builder.audioAggregationEndedAt;
        this.audioAggregationStartedAt = builder.audioAggregationStartedAt;
        this.authenticationResultId = builder.authenticationResultId;
        this.configuration = builder.configuration;
        this.customerSpeakerId = builder.customerSpeakerId;
        this.decision = builder.decision;
        this.generatedSpeakerId = builder.generatedSpeakerId;
        this.score = builder.score;
    }

    /**
     * <p>
     * A timestamp indicating when audio aggregation ended for this authentication result.
     * </p>
     * 
     * @return A timestamp indicating when audio aggregation ended for this authentication result.
     */
    public final Instant audioAggregationEndedAt() {
        return audioAggregationEndedAt;
    }

    /**
     * <p>
     * A timestamp indicating when audio aggregation started for this authentication result.
     * </p>
     * 
     * @return A timestamp indicating when audio aggregation started for this authentication result.
     */
    public final Instant audioAggregationStartedAt() {
        return audioAggregationStartedAt;
    }

    /**
     * <p>
     * The unique identifier for this authentication result. Because there can be multiple authentications for a given
     * session, this field helps to identify if the returned result is from a previous streaming activity or a new
     * result. Note that in absence of any new streaming activity, <code>AcceptanceThreshold</code> changes, or
     * <code>SpeakerId</code> changes, Voice ID always returns cached Authentication Result for this API.
     * </p>
     * 
     * @return The unique identifier for this authentication result. Because there can be multiple authentications for a
     *         given session, this field helps to identify if the returned result is from a previous streaming activity
     *         or a new result. Note that in absence of any new streaming activity, <code>AcceptanceThreshold</code>
     *         changes, or <code>SpeakerId</code> changes, Voice ID always returns cached Authentication Result for this
     *         API.
     */
    public final String authenticationResultId() {
        return authenticationResultId;
    }

    /**
     * <p>
     * The <code>AuthenticationConfiguration</code> used to generate this authentication result.
     * </p>
     * 
     * @return The <code>AuthenticationConfiguration</code> used to generate this authentication result.
     */
    public final AuthenticationConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The client-provided identifier for the speaker whose authentication result is produced. Only present if a
     * <code>SpeakerId</code> is provided for the session.
     * </p>
     * 
     * @return The client-provided identifier for the speaker whose authentication result is produced. Only present if a
     *         <code>SpeakerId</code> is provided for the session.
     */
    public final String customerSpeakerId() {
        return customerSpeakerId;
    }

    /**
     * <p>
     * The authentication decision produced by Voice ID, processed against the current session state and streamed audio
     * of the speaker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decision} will
     * return {@link AuthenticationDecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #decisionAsString}.
     * </p>
     * 
     * @return The authentication decision produced by Voice ID, processed against the current session state and
     *         streamed audio of the speaker.
     * @see AuthenticationDecision
     */
    public final AuthenticationDecision decision() {
        return AuthenticationDecision.fromValue(decision);
    }

    /**
     * <p>
     * The authentication decision produced by Voice ID, processed against the current session state and streamed audio
     * of the speaker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decision} will
     * return {@link AuthenticationDecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #decisionAsString}.
     * </p>
     * 
     * @return The authentication decision produced by Voice ID, processed against the current session state and
     *         streamed audio of the speaker.
     * @see AuthenticationDecision
     */
    public final String decisionAsString() {
        return decision;
    }

    /**
     * <p>
     * The service-generated identifier for the speaker whose authentication result is produced.
     * </p>
     * 
     * @return The service-generated identifier for the speaker whose authentication result is produced.
     */
    public final String generatedSpeakerId() {
        return generatedSpeakerId;
    }

    /**
     * <p>
     * The authentication score for the speaker whose authentication result is produced. This value is only present if
     * the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.
     * </p>
     * 
     * @return The authentication score for the speaker whose authentication result is produced. This value is only
     *         present if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.
     */
    public final Integer score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioAggregationEndedAt());
        hashCode = 31 * hashCode + Objects.hashCode(audioAggregationStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationResultId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(customerSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(decisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(generatedSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResult)) {
            return false;
        }
        AuthenticationResult other = (AuthenticationResult) obj;
        return Objects.equals(audioAggregationEndedAt(), other.audioAggregationEndedAt())
                && Objects.equals(audioAggregationStartedAt(), other.audioAggregationStartedAt())
                && Objects.equals(authenticationResultId(), other.authenticationResultId())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(customerSpeakerId(), other.customerSpeakerId())
                && Objects.equals(decisionAsString(), other.decisionAsString())
                && Objects.equals(generatedSpeakerId(), other.generatedSpeakerId()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationResult").add("AudioAggregationEndedAt", audioAggregationEndedAt())
                .add("AudioAggregationStartedAt", audioAggregationStartedAt())
                .add("AuthenticationResultId", authenticationResultId()).add("Configuration", configuration())
                .add("CustomerSpeakerId", customerSpeakerId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Decision", decisionAsString()).add("GeneratedSpeakerId", generatedSpeakerId()).add("Score", score())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioAggregationEndedAt":
            return Optional.ofNullable(clazz.cast(audioAggregationEndedAt()));
        case "AudioAggregationStartedAt":
            return Optional.ofNullable(clazz.cast(audioAggregationStartedAt()));
        case "AuthenticationResultId":
            return Optional.ofNullable(clazz.cast(authenticationResultId()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CustomerSpeakerId":
            return Optional.ofNullable(clazz.cast(customerSpeakerId()));
        case "Decision":
            return Optional.ofNullable(clazz.cast(decisionAsString()));
        case "GeneratedSpeakerId":
            return Optional.ofNullable(clazz.cast(generatedSpeakerId()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationResult, T> g) {
        return obj -> g.apply((AuthenticationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationResult> {
        /**
         * <p>
         * A timestamp indicating when audio aggregation ended for this authentication result.
         * </p>
         * 
         * @param audioAggregationEndedAt
         *        A timestamp indicating when audio aggregation ended for this authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioAggregationEndedAt(Instant audioAggregationEndedAt);

        /**
         * <p>
         * A timestamp indicating when audio aggregation started for this authentication result.
         * </p>
         * 
         * @param audioAggregationStartedAt
         *        A timestamp indicating when audio aggregation started for this authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioAggregationStartedAt(Instant audioAggregationStartedAt);

        /**
         * <p>
         * The unique identifier for this authentication result. Because there can be multiple authentications for a
         * given session, this field helps to identify if the returned result is from a previous streaming activity or a
         * new result. Note that in absence of any new streaming activity, <code>AcceptanceThreshold</code> changes, or
         * <code>SpeakerId</code> changes, Voice ID always returns cached Authentication Result for this API.
         * </p>
         * 
         * @param authenticationResultId
         *        The unique identifier for this authentication result. Because there can be multiple authentications
         *        for a given session, this field helps to identify if the returned result is from a previous streaming
         *        activity or a new result. Note that in absence of any new streaming activity,
         *        <code>AcceptanceThreshold</code> changes, or <code>SpeakerId</code> changes, Voice ID always returns
         *        cached Authentication Result for this API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationResultId(String authenticationResultId);

        /**
         * <p>
         * The <code>AuthenticationConfiguration</code> used to generate this authentication result.
         * </p>
         * 
         * @param configuration
         *        The <code>AuthenticationConfiguration</code> used to generate this authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AuthenticationConfiguration configuration);

        /**
         * <p>
         * The <code>AuthenticationConfiguration</code> used to generate this authentication result.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthenticationConfiguration.Builder} avoiding
         * the need to create one manually via {@link AuthenticationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(AuthenticationConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AuthenticationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AuthenticationConfiguration)
         */
        default Builder configuration(Consumer<AuthenticationConfiguration.Builder> configuration) {
            return configuration(AuthenticationConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The client-provided identifier for the speaker whose authentication result is produced. Only present if a
         * <code>SpeakerId</code> is provided for the session.
         * </p>
         * 
         * @param customerSpeakerId
         *        The client-provided identifier for the speaker whose authentication result is produced. Only present
         *        if a <code>SpeakerId</code> is provided for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerSpeakerId(String customerSpeakerId);

        /**
         * <p>
         * The authentication decision produced by Voice ID, processed against the current session state and streamed
         * audio of the speaker.
         * </p>
         * 
         * @param decision
         *        The authentication decision produced by Voice ID, processed against the current session state and
         *        streamed audio of the speaker.
         * @see AuthenticationDecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationDecision
         */
        Builder decision(String decision);

        /**
         * <p>
         * The authentication decision produced by Voice ID, processed against the current session state and streamed
         * audio of the speaker.
         * </p>
         * 
         * @param decision
         *        The authentication decision produced by Voice ID, processed against the current session state and
         *        streamed audio of the speaker.
         * @see AuthenticationDecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationDecision
         */
        Builder decision(AuthenticationDecision decision);

        /**
         * <p>
         * The service-generated identifier for the speaker whose authentication result is produced.
         * </p>
         * 
         * @param generatedSpeakerId
         *        The service-generated identifier for the speaker whose authentication result is produced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedSpeakerId(String generatedSpeakerId);

        /**
         * <p>
         * The authentication score for the speaker whose authentication result is produced. This value is only present
         * if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.
         * </p>
         * 
         * @param score
         *        The authentication score for the speaker whose authentication result is produced. This value is only
         *        present if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Integer score);
    }

    static final class BuilderImpl implements Builder {
        private Instant audioAggregationEndedAt;

        private Instant audioAggregationStartedAt;

        private String authenticationResultId;

        private AuthenticationConfiguration configuration;

        private String customerSpeakerId;

        private String decision;

        private String generatedSpeakerId;

        private Integer score;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationResult model) {
            audioAggregationEndedAt(model.audioAggregationEndedAt);
            audioAggregationStartedAt(model.audioAggregationStartedAt);
            authenticationResultId(model.authenticationResultId);
            configuration(model.configuration);
            customerSpeakerId(model.customerSpeakerId);
            decision(model.decision);
            generatedSpeakerId(model.generatedSpeakerId);
            score(model.score);
        }

        public final Instant getAudioAggregationEndedAt() {
            return audioAggregationEndedAt;
        }

        public final void setAudioAggregationEndedAt(Instant audioAggregationEndedAt) {
            this.audioAggregationEndedAt = audioAggregationEndedAt;
        }

        @Override
        @Transient
        public final Builder audioAggregationEndedAt(Instant audioAggregationEndedAt) {
            this.audioAggregationEndedAt = audioAggregationEndedAt;
            return this;
        }

        public final Instant getAudioAggregationStartedAt() {
            return audioAggregationStartedAt;
        }

        public final void setAudioAggregationStartedAt(Instant audioAggregationStartedAt) {
            this.audioAggregationStartedAt = audioAggregationStartedAt;
        }

        @Override
        @Transient
        public final Builder audioAggregationStartedAt(Instant audioAggregationStartedAt) {
            this.audioAggregationStartedAt = audioAggregationStartedAt;
            return this;
        }

        public final String getAuthenticationResultId() {
            return authenticationResultId;
        }

        public final void setAuthenticationResultId(String authenticationResultId) {
            this.authenticationResultId = authenticationResultId;
        }

        @Override
        @Transient
        public final Builder authenticationResultId(String authenticationResultId) {
            this.authenticationResultId = authenticationResultId;
            return this;
        }

        public final AuthenticationConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AuthenticationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(AuthenticationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getCustomerSpeakerId() {
            return customerSpeakerId;
        }

        public final void setCustomerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
        }

        @Override
        @Transient
        public final Builder customerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
            return this;
        }

        public final String getDecision() {
            return decision;
        }

        public final void setDecision(String decision) {
            this.decision = decision;
        }

        @Override
        @Transient
        public final Builder decision(String decision) {
            this.decision = decision;
            return this;
        }

        @Override
        @Transient
        public final Builder decision(AuthenticationDecision decision) {
            this.decision(decision == null ? null : decision.toString());
            return this;
        }

        public final String getGeneratedSpeakerId() {
            return generatedSpeakerId;
        }

        public final void setGeneratedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
        }

        @Override
        @Transient
        public final Builder generatedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
            return this;
        }

        public final Integer getScore() {
            return score;
        }

        public final void setScore(Integer score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Integer score) {
            this.score = score;
            return this;
        }

        @Override
        public AuthenticationResult build() {
            return new AuthenticationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
