/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptOutSpeakerResponse extends VoiceIdResponse implements
        ToCopyableBuilder<OptOutSpeakerResponse.Builder, OptOutSpeakerResponse> {
    private static final SdkField<Speaker> SPEAKER_FIELD = SdkField.<Speaker> builder(MarshallingType.SDK_POJO)
            .memberName("Speaker").getter(getter(OptOutSpeakerResponse::speaker)).setter(setter(Builder::speaker))
            .constructor(Speaker::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Speaker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEAKER_FIELD));

    private final Speaker speaker;

    private OptOutSpeakerResponse(BuilderImpl builder) {
        super(builder);
        this.speaker = builder.speaker;
    }

    /**
     * <p>
     * Details about the opted-out speaker.
     * </p>
     * 
     * @return Details about the opted-out speaker.
     */
    public final Speaker speaker() {
        return speaker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(speaker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptOutSpeakerResponse)) {
            return false;
        }
        OptOutSpeakerResponse other = (OptOutSpeakerResponse) obj;
        return Objects.equals(speaker(), other.speaker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptOutSpeakerResponse").add("Speaker", speaker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Speaker":
            return Optional.ofNullable(clazz.cast(speaker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptOutSpeakerResponse, T> g) {
        return obj -> g.apply((OptOutSpeakerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdResponse.Builder, SdkPojo, CopyableBuilder<Builder, OptOutSpeakerResponse> {
        /**
         * <p>
         * Details about the opted-out speaker.
         * </p>
         * 
         * @param speaker
         *        Details about the opted-out speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speaker(Speaker speaker);

        /**
         * <p>
         * Details about the opted-out speaker.
         * </p>
         * This is a convenience that creates an instance of the {@link Speaker.Builder} avoiding the need to create one
         * manually via {@link Speaker#builder()}.
         *
         * When the {@link Consumer} completes, {@link Speaker.Builder#build()} is called immediately and its result is
         * passed to {@link #speaker(Speaker)}.
         * 
         * @param speaker
         *        a consumer that will call methods on {@link Speaker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speaker(Speaker)
         */
        default Builder speaker(Consumer<Speaker.Builder> speaker) {
            return speaker(Speaker.builder().applyMutation(speaker).build());
        }
    }

    static final class BuilderImpl extends VoiceIdResponse.BuilderImpl implements Builder {
        private Speaker speaker;

        private BuilderImpl() {
        }

        private BuilderImpl(OptOutSpeakerResponse model) {
            super(model);
            speaker(model.speaker);
        }

        public final Speaker.Builder getSpeaker() {
            return speaker != null ? speaker.toBuilder() : null;
        }

        public final void setSpeaker(Speaker.BuilderImpl speaker) {
            this.speaker = speaker != null ? speaker.build() : null;
        }

        @Override
        @Transient
        public final Builder speaker(Speaker speaker) {
            this.speaker = speaker;
            return this;
        }

        @Override
        public OptOutSpeakerResponse build() {
            return new OptOutSpeakerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
