/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSpeakerEnrollmentJobRequest extends VoiceIdRequest implements
        ToCopyableBuilder<StartSpeakerEnrollmentJobRequest.Builder, StartSpeakerEnrollmentJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartSpeakerEnrollmentJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(StartSpeakerEnrollmentJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(StartSpeakerEnrollmentJobRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<EnrollmentConfig> ENROLLMENT_CONFIG_FIELD = SdkField
            .<EnrollmentConfig> builder(MarshallingType.SDK_POJO).memberName("EnrollmentConfig")
            .getter(getter(StartSpeakerEnrollmentJobRequest::enrollmentConfig)).setter(setter(Builder::enrollmentConfig))
            .constructor(EnrollmentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentConfig").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(StartSpeakerEnrollmentJobRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(StartSpeakerEnrollmentJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(StartSpeakerEnrollmentJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD, DOMAIN_ID_FIELD, ENROLLMENT_CONFIG_FIELD, INPUT_DATA_CONFIG_FIELD, JOB_NAME_FIELD,
            OUTPUT_DATA_CONFIG_FIELD));

    private final String clientToken;

    private final String dataAccessRoleArn;

    private final String domainId;

    private final EnrollmentConfig enrollmentConfig;

    private final InputDataConfig inputDataConfig;

    private final String jobName;

    private final OutputDataConfig outputDataConfig;

    private StartSpeakerEnrollmentJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.domainId = builder.domainId;
        this.enrollmentConfig = builder.enrollmentConfig;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobName = builder.jobName;
        this.outputDataConfig = builder.outputDataConfig;
    }

    /**
     * <p>
     * The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK
     * populates this field.
     * </p>
     * 
     * @return The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK
     *         populates this field.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the
     * input manifest file and write the job output file. Refer to <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using
     * audio data from prior calls</a> documentation for the permissions needed in this role.
     * </p>
     * 
     * @return The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to
     *         read the input manifest file and write the job output file. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch
     *         enrollment using audio data from prior calls</a> documentation for the permissions needed in this role.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled.
     * </p>
     * 
     * @return The identifier of the domain that contains the speaker enrollment job and in which the speakers are
     *         enrolled.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The enrollment config that contains details such as the action to take when a speaker is already enrolled in the
     * Voice ID system or when a speaker is identified as a fraudster.
     * </p>
     * 
     * @return The enrollment config that contains details such as the action to take when a speaker is already enrolled
     *         in the Voice ID system or when a speaker is identified as a fraudster.
     */
    public final EnrollmentConfig enrollmentConfig() {
        return enrollmentConfig;
    }

    /**
     * <p>
     * The input data config containing the S3 location for the input manifest file that contains the list of speaker
     * enrollment requests.
     * </p>
     * 
     * @return The input data config containing the S3 location for the input manifest file that contains the list of
     *         speaker enrollment requests.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * A name for your speaker enrollment job.
     * </p>
     * 
     * @return A name for your speaker enrollment job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The output data config containing the S3 location where Voice ID writes the job output file; you must also
     * include a KMS Key ID to encrypt the file.
     * </p>
     * 
     * @return The output data config containing the S3 location where Voice ID writes the job output file; you must
     *         also include a KMS Key ID to encrypt the file.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeakerEnrollmentJobRequest)) {
            return false;
        }
        StartSpeakerEnrollmentJobRequest other = (StartSpeakerEnrollmentJobRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(enrollmentConfig(), other.enrollmentConfig())
                && Objects.equals(inputDataConfig(), other.inputDataConfig()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(outputDataConfig(), other.outputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSpeakerEnrollmentJobRequest").add("ClientToken", clientToken())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("DomainId", domainId())
                .add("EnrollmentConfig", enrollmentConfig()).add("InputDataConfig", inputDataConfig())
                .add("JobName", jobName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OutputDataConfig", outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "EnrollmentConfig":
            return Optional.ofNullable(clazz.cast(enrollmentConfig()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSpeakerEnrollmentJobRequest, T> g) {
        return obj -> g.apply((StartSpeakerEnrollmentJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSpeakerEnrollmentJobRequest> {
        /**
         * <p>
         * The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK
         * populates this field.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services
         *        SDK populates this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read
         * the input manifest file and write the job output file. Refer to <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment
         * using audio data from prior calls</a> documentation for the permissions needed in this role.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
         *        to read the input manifest file and write the job output file. Refer to <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch
         *        enrollment using audio data from prior calls</a> documentation for the permissions needed in this
         *        role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain that contains the speaker enrollment job and in which the speakers are
         *        enrolled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The enrollment config that contains details such as the action to take when a speaker is already enrolled in
         * the Voice ID system or when a speaker is identified as a fraudster.
         * </p>
         * 
         * @param enrollmentConfig
         *        The enrollment config that contains details such as the action to take when a speaker is already
         *        enrolled in the Voice ID system or when a speaker is identified as a fraudster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentConfig(EnrollmentConfig enrollmentConfig);

        /**
         * <p>
         * The enrollment config that contains details such as the action to take when a speaker is already enrolled in
         * the Voice ID system or when a speaker is identified as a fraudster.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnrollmentConfig.Builder} avoiding the
         * need to create one manually via {@link EnrollmentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnrollmentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #enrollmentConfig(EnrollmentConfig)}.
         * 
         * @param enrollmentConfig
         *        a consumer that will call methods on {@link EnrollmentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrollmentConfig(EnrollmentConfig)
         */
        default Builder enrollmentConfig(Consumer<EnrollmentConfig.Builder> enrollmentConfig) {
            return enrollmentConfig(EnrollmentConfig.builder().applyMutation(enrollmentConfig).build());
        }

        /**
         * <p>
         * The input data config containing the S3 location for the input manifest file that contains the list of
         * speaker enrollment requests.
         * </p>
         * 
         * @param inputDataConfig
         *        The input data config containing the S3 location for the input manifest file that contains the list of
         *        speaker enrollment requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * The input data config containing the S3 location for the input manifest file that contains the list of
         * speaker enrollment requests.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * A name for your speaker enrollment job.
         * </p>
         * 
         * @param jobName
         *        A name for your speaker enrollment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The output data config containing the S3 location where Voice ID writes the job output file; you must also
         * include a KMS Key ID to encrypt the file.
         * </p>
         * 
         * @param outputDataConfig
         *        The output data config containing the S3 location where Voice ID writes the job output file; you must
         *        also include a KMS Key ID to encrypt the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * The output data config containing the S3 location where Voice ID writes the job output file; you must also
         * include a KMS Key ID to encrypt the file.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VoiceIdRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String dataAccessRoleArn;

        private String domainId;

        private EnrollmentConfig enrollmentConfig;

        private InputDataConfig inputDataConfig;

        private String jobName;

        private OutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeakerEnrollmentJobRequest model) {
            super(model);
            clientToken(model.clientToken);
            dataAccessRoleArn(model.dataAccessRoleArn);
            domainId(model.domainId);
            enrollmentConfig(model.enrollmentConfig);
            inputDataConfig(model.inputDataConfig);
            jobName(model.jobName);
            outputDataConfig(model.outputDataConfig);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final EnrollmentConfig.Builder getEnrollmentConfig() {
            return enrollmentConfig != null ? enrollmentConfig.toBuilder() : null;
        }

        public final void setEnrollmentConfig(EnrollmentConfig.BuilderImpl enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig != null ? enrollmentConfig.build() : null;
        }

        @Override
        public final Builder enrollmentConfig(EnrollmentConfig enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeakerEnrollmentJobRequest build() {
            return new StartSpeakerEnrollmentJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
