/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptOutSpeakerRequest extends VoiceIdRequest implements
        ToCopyableBuilder<OptOutSpeakerRequest.Builder, OptOutSpeakerRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(OptOutSpeakerRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> SPEAKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeakerId").getter(getter(OptOutSpeakerRequest::speakerId)).setter(setter(Builder::speakerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            SPEAKER_ID_FIELD));

    private final String domainId;

    private final String speakerId;

    private OptOutSpeakerRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.speakerId = builder.speakerId;
    }

    /**
     * <p>
     * The identifier of the domain containing the speaker.
     * </p>
     * 
     * @return The identifier of the domain containing the speaker.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the speaker you want opted-out.
     * </p>
     * 
     * @return The identifier of the speaker you want opted-out.
     */
    public final String speakerId() {
        return speakerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(speakerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptOutSpeakerRequest)) {
            return false;
        }
        OptOutSpeakerRequest other = (OptOutSpeakerRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(speakerId(), other.speakerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptOutSpeakerRequest").add("DomainId", domainId())
                .add("SpeakerId", speakerId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "SpeakerId":
            return Optional.ofNullable(clazz.cast(speakerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptOutSpeakerRequest, T> g) {
        return obj -> g.apply((OptOutSpeakerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdRequest.Builder, SdkPojo, CopyableBuilder<Builder, OptOutSpeakerRequest> {
        /**
         * <p>
         * The identifier of the domain containing the speaker.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain containing the speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the speaker you want opted-out.
         * </p>
         * 
         * @param speakerId
         *        The identifier of the speaker you want opted-out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speakerId(String speakerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VoiceIdRequest.BuilderImpl implements Builder {
        private String domainId;

        private String speakerId;

        private BuilderImpl() {
        }

        private BuilderImpl(OptOutSpeakerRequest model) {
            super(model);
            domainId(model.domainId);
            speakerId(model.speakerId);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpeakerId() {
            return speakerId;
        }

        public final void setSpeakerId(String speakerId) {
            this.speakerId = speakerId;
        }

        @Override
        public final Builder speakerId(String speakerId) {
            this.speakerId = speakerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OptOutSpeakerRequest build() {
            return new OptOutSpeakerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
