/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.voiceid.model.AccessDeniedException;
import software.amazon.awssdk.services.voiceid.model.ConflictException;
import software.amazon.awssdk.services.voiceid.model.CreateDomainRequest;
import software.amazon.awssdk.services.voiceid.model.CreateDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteDomainRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeDomainRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.EvaluateSessionRequest;
import software.amazon.awssdk.services.voiceid.model.EvaluateSessionResponse;
import software.amazon.awssdk.services.voiceid.model.InternalServerException;
import software.amazon.awssdk.services.voiceid.model.ListDomainsRequest;
import software.amazon.awssdk.services.voiceid.model.ListDomainsResponse;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse;
import software.amazon.awssdk.services.voiceid.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.voiceid.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.voiceid.model.OptOutSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.OptOutSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.ResourceNotFoundException;
import software.amazon.awssdk.services.voiceid.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobRequest;
import software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobResponse;
import software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobRequest;
import software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobResponse;
import software.amazon.awssdk.services.voiceid.model.TagResourceRequest;
import software.amazon.awssdk.services.voiceid.model.TagResourceResponse;
import software.amazon.awssdk.services.voiceid.model.ThrottlingException;
import software.amazon.awssdk.services.voiceid.model.UntagResourceRequest;
import software.amazon.awssdk.services.voiceid.model.UntagResourceResponse;
import software.amazon.awssdk.services.voiceid.model.UpdateDomainRequest;
import software.amazon.awssdk.services.voiceid.model.UpdateDomainResponse;
import software.amazon.awssdk.services.voiceid.model.ValidationException;
import software.amazon.awssdk.services.voiceid.model.VoiceIdException;
import software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable;
import software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable;
import software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable;

/**
 * Service client for accessing Amazon Voice ID. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Connect Voice ID provides real-time caller authentication and fraud screening. This guide describes the APIs
 * used for this service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface VoiceIdClient extends SdkClient {
    String SERVICE_NAME = "voiceid";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "voiceid";

    /**
     * Create a {@link VoiceIdClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static VoiceIdClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link VoiceIdClient}.
     */
    static VoiceIdClientBuilder builder() {
        return new DefaultVoiceIdClientBuilder();
    }

    /**
     * <p>
     * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio,
     * and voiceprints.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio,
     * and voiceprints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain from Voice ID.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain from Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the specified fraudster from Voice ID.
     * </p>
     *
     * @param deleteFraudsterRequest
     * @return Result of the DeleteFraudster operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DeleteFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteFraudster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFraudsterResponse deleteFraudster(DeleteFraudsterRequest deleteFraudsterRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified fraudster from Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFraudsterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFraudsterRequest#builder()}
     * </p>
     *
     * @param deleteFraudsterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFraudsterRequest.Builder} to create a request.
     * @return Result of the DeleteFraudster operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DeleteFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteFraudster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFraudsterResponse deleteFraudster(Consumer<DeleteFraudsterRequest.Builder> deleteFraudsterRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return deleteFraudster(DeleteFraudsterRequest.builder().applyMutation(deleteFraudsterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified speaker from Voice ID.
     * </p>
     *
     * @param deleteSpeakerRequest
     * @return Result of the DeleteSpeaker operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DeleteSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSpeakerResponse deleteSpeaker(DeleteSpeakerRequest deleteSpeakerRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified speaker from Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpeakerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSpeakerRequest#builder()}
     * </p>
     *
     * @param deleteSpeakerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSpeakerRequest.Builder} to create a request.
     * @return Result of the DeleteSpeaker operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DeleteSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSpeakerResponse deleteSpeaker(Consumer<DeleteSpeakerRequest.Builder> deleteSpeakerRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return deleteSpeaker(DeleteSpeakerRequest.builder().applyMutation(deleteSpeakerRequest).build());
    }

    /**
     * <p>
     * Describes the specified domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainRequest.Builder} to create a request.
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDomainResponse describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Describes the specified fraudster.
     * </p>
     *
     * @param describeFraudsterRequest
     * @return Result of the DescribeFraudster operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudster" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFraudsterResponse describeFraudster(DescribeFraudsterRequest describeFraudsterRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified fraudster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFraudsterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFraudsterRequest#builder()}
     * </p>
     *
     * @param describeFraudsterRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFraudsterRequest.Builder} to create a request.
     * @return Result of the DescribeFraudster operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudster" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFraudsterResponse describeFraudster(Consumer<DescribeFraudsterRequest.Builder> describeFraudsterRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return describeFraudster(DescribeFraudsterRequest.builder().applyMutation(describeFraudsterRequest).build());
    }

    /**
     * <p>
     * Describes the specified fraudster registration job.
     * </p>
     *
     * @param describeFraudsterRegistrationJobRequest
     * @return Result of the DescribeFraudsterRegistrationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFraudsterRegistrationJobResponse describeFraudsterRegistrationJob(
            DescribeFraudsterRegistrationJobRequest describeFraudsterRegistrationJobRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified fraudster registration job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFraudsterRegistrationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFraudsterRegistrationJobRequest#builder()}
     * </p>
     *
     * @param describeFraudsterRegistrationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFraudsterRegistrationJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFraudsterRegistrationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFraudsterRegistrationJobResponse describeFraudsterRegistrationJob(
            Consumer<DescribeFraudsterRegistrationJobRequest.Builder> describeFraudsterRegistrationJobRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return describeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest.builder()
                .applyMutation(describeFraudsterRegistrationJobRequest).build());
    }

    /**
     * <p>
     * Describes the specified speaker.
     * </p>
     *
     * @param describeSpeakerRequest
     * @return Result of the DescribeSpeaker operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSpeakerResponse describeSpeaker(DescribeSpeakerRequest describeSpeakerRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified speaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpeakerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSpeakerRequest#builder()}
     * </p>
     *
     * @param describeSpeakerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSpeakerRequest.Builder} to create a request.
     * @return Result of the DescribeSpeaker operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSpeakerResponse describeSpeaker(Consumer<DescribeSpeakerRequest.Builder> describeSpeakerRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return describeSpeaker(DescribeSpeakerRequest.builder().applyMutation(describeSpeakerRequest).build());
    }

    /**
     * <p>
     * Describes the specified speaker enrollment job.
     * </p>
     *
     * @param describeSpeakerEnrollmentJobRequest
     * @return Result of the DescribeSpeakerEnrollmentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpeakerEnrollmentJobResponse describeSpeakerEnrollmentJob(
            DescribeSpeakerEnrollmentJobRequest describeSpeakerEnrollmentJobRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified speaker enrollment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpeakerEnrollmentJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSpeakerEnrollmentJobRequest#builder()}
     * </p>
     *
     * @param describeSpeakerEnrollmentJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSpeakerEnrollmentJobRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeSpeakerEnrollmentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.DescribeSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpeakerEnrollmentJobResponse describeSpeakerEnrollmentJob(
            Consumer<DescribeSpeakerEnrollmentJobRequest.Builder> describeSpeakerEnrollmentJobRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return describeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest.builder()
                .applyMutation(describeSpeakerEnrollmentJobRequest).build());
    }

    /**
     * <p>
     * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
     * </p>
     *
     * @param evaluateSessionRequest
     * @return Result of the EvaluateSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.EvaluateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/EvaluateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default EvaluateSessionResponse evaluateSession(EvaluateSessionRequest evaluateSessionRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateSessionRequest.Builder} avoiding the need
     * to create one manually via {@link EvaluateSessionRequest#builder()}
     * </p>
     *
     * @param evaluateSessionRequest
     *        A {@link Consumer} that will call methods on {@link EvaluateSessionRequest.Builder} to create a request.
     * @return Result of the EvaluateSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.EvaluateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/EvaluateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default EvaluateSessionResponse evaluateSession(Consumer<EvaluateSessionRequest.Builder> evaluateSessionRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return evaluateSession(EvaluateSessionRequest.builder().applyMutation(evaluateSessionRequest).build());
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return Result of the ListDomains operation returned by the service.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     * @return Result of the ListFraudsterRegistrationJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFraudsterRegistrationJobsResponse listFraudsterRegistrationJobs(
            ListFraudsterRegistrationJobsRequest listFraudsterRegistrationJobsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFraudsterRegistrationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFraudsterRegistrationJobsRequest#builder()}
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListFraudsterRegistrationJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFraudsterRegistrationJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFraudsterRegistrationJobsResponse listFraudsterRegistrationJobs(
            Consumer<ListFraudsterRegistrationJobsRequest.Builder> listFraudsterRegistrationJobsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest.builder()
                .applyMutation(listFraudsterRegistrationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable responses = client.listFraudsterRegistrationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable responses = client
     *             .listFraudsterRegistrationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable responses = client.listFraudsterRegistrationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFraudsterRegistrationJobsIterable listFraudsterRegistrationJobsPaginator(
            ListFraudsterRegistrationJobsRequest listFraudsterRegistrationJobsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable responses = client.listFraudsterRegistrationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable responses = client
     *             .listFraudsterRegistrationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsIterable responses = client.listFraudsterRegistrationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFraudsterRegistrationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFraudsterRegistrationJobsRequest#builder()}
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListFraudsterRegistrationJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFraudsterRegistrationJobsIterable listFraudsterRegistrationJobsPaginator(
            Consumer<ListFraudsterRegistrationJobsRequest.Builder> listFraudsterRegistrationJobsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return listFraudsterRegistrationJobsPaginator(ListFraudsterRegistrationJobsRequest.builder()
                .applyMutation(listFraudsterRegistrationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     * @return Result of the ListSpeakerEnrollmentJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeakerEnrollmentJobsResponse listSpeakerEnrollmentJobs(
            ListSpeakerEnrollmentJobsRequest listSpeakerEnrollmentJobsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakerEnrollmentJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSpeakerEnrollmentJobsRequest#builder()}
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSpeakerEnrollmentJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSpeakerEnrollmentJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeakerEnrollmentJobsResponse listSpeakerEnrollmentJobs(
            Consumer<ListSpeakerEnrollmentJobsRequest.Builder> listSpeakerEnrollmentJobsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest.builder()
                .applyMutation(listSpeakerEnrollmentJobsRequest).build());
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable responses = client.listSpeakerEnrollmentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable responses = client
     *             .listSpeakerEnrollmentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable responses = client.listSpeakerEnrollmentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeakerEnrollmentJobsIterable listSpeakerEnrollmentJobsPaginator(
            ListSpeakerEnrollmentJobsRequest listSpeakerEnrollmentJobsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable responses = client.listSpeakerEnrollmentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable responses = client
     *             .listSpeakerEnrollmentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsIterable responses = client.listSpeakerEnrollmentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakerEnrollmentJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSpeakerEnrollmentJobsRequest#builder()}
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSpeakerEnrollmentJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeakerEnrollmentJobsIterable listSpeakerEnrollmentJobsPaginator(
            Consumer<ListSpeakerEnrollmentJobsRequest.Builder> listSpeakerEnrollmentJobsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return listSpeakerEnrollmentJobsPaginator(ListSpeakerEnrollmentJobsRequest.builder()
                .applyMutation(listSpeakerEnrollmentJobsRequest).build());
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     *
     * @param listSpeakersRequest
     * @return Result of the ListSpeakers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpeakersResponse listSpeakers(ListSpeakersRequest listSpeakersRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakersRequest.Builder} avoiding the need to
     * create one manually via {@link ListSpeakersRequest#builder()}
     * </p>
     *
     * @param listSpeakersRequest
     *        A {@link Consumer} that will call methods on {@link ListSpeakersRequest.Builder} to create a request.
     * @return Result of the ListSpeakers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpeakersResponse listSpeakers(Consumer<ListSpeakersRequest.Builder> listSpeakersRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return listSpeakers(ListSpeakersRequest.builder().applyMutation(listSpeakersRequest).build());
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable responses = client.listSpeakersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable responses = client.listSpeakersPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable responses = client.listSpeakersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)} operation.</b>
     * </p>
     *
     * @param listSpeakersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpeakersIterable listSpeakersPaginator(ListSpeakersRequest listSpeakersRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable responses = client.listSpeakersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable responses = client.listSpeakersPaginator(request);
     *     for (software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersIterable responses = client.listSpeakersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakersRequest.Builder} avoiding the need to
     * create one manually via {@link ListSpeakersRequest#builder()}
     * </p>
     *
     * @param listSpeakersRequest
     *        A {@link Consumer} that will call methods on {@link ListSpeakersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpeakersIterable listSpeakersPaginator(Consumer<ListSpeakersRequest.Builder> listSpeakersRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return listSpeakersPaginator(ListSpeakersRequest.builder().applyMutation(listSpeakersRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a specified Voice ID resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a specified Voice ID resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, VoiceIdException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in
     * Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their
     * existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are
     * rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
     * </p>
     *
     * @param optOutSpeakerRequest
     * @return Result of the OptOutSpeaker operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.OptOutSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OptOutSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default OptOutSpeakerResponse optOutSpeaker(OptOutSpeakerRequest optOutSpeakerRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in
     * Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their
     * existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are
     * rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OptOutSpeakerRequest.Builder} avoiding the need to
     * create one manually via {@link OptOutSpeakerRequest#builder()}
     * </p>
     *
     * @param optOutSpeakerRequest
     *        A {@link Consumer} that will call methods on {@link OptOutSpeakerRequest.Builder} to create a request.
     * @return Result of the OptOutSpeaker operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.OptOutSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OptOutSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default OptOutSpeakerResponse optOutSpeaker(Consumer<OptOutSpeakerRequest.Builder> optOutSpeakerRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        return optOutSpeaker(OptOutSpeakerRequest.builder().applyMutation(optOutSpeakerRequest).build());
    }

    /**
     * <p>
     * Starts a new batch fraudster registration job using provided details.
     * </p>
     *
     * @param startFraudsterRegistrationJobRequest
     * @return Result of the StartFraudsterRegistrationJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.StartFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFraudsterRegistrationJobResponse startFraudsterRegistrationJob(
            StartFraudsterRegistrationJobRequest startFraudsterRegistrationJobRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new batch fraudster registration job using provided details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFraudsterRegistrationJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartFraudsterRegistrationJobRequest#builder()}
     * </p>
     *
     * @param startFraudsterRegistrationJobRequest
     *        A {@link Consumer} that will call methods on {@link StartFraudsterRegistrationJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartFraudsterRegistrationJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.StartFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFraudsterRegistrationJobResponse startFraudsterRegistrationJob(
            Consumer<StartFraudsterRegistrationJobRequest.Builder> startFraudsterRegistrationJobRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        return startFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest.builder()
                .applyMutation(startFraudsterRegistrationJobRequest).build());
    }

    /**
     * <p>
     * Starts a new batch speaker enrollment job using specified details.
     * </p>
     *
     * @param startSpeakerEnrollmentJobRequest
     * @return Result of the StartSpeakerEnrollmentJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.StartSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSpeakerEnrollmentJobResponse startSpeakerEnrollmentJob(
            StartSpeakerEnrollmentJobRequest startSpeakerEnrollmentJobRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new batch speaker enrollment job using specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSpeakerEnrollmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSpeakerEnrollmentJobRequest#builder()}
     * </p>
     *
     * @param startSpeakerEnrollmentJobRequest
     *        A {@link Consumer} that will call methods on {@link StartSpeakerEnrollmentJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartSpeakerEnrollmentJob operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeded the service quota. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.StartSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSpeakerEnrollmentJobResponse startSpeakerEnrollmentJob(
            Consumer<StartSpeakerEnrollmentJobRequest.Builder> startSpeakerEnrollmentJobRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            VoiceIdException {
        return startSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest.builder()
                .applyMutation(startSpeakerEnrollmentJobRequest).build());
    }

    /**
     * <p>
     * Tags a Voice ID resource with the provided list of tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a Voice ID resource with the provided list of tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from a specified Amazon Connect Voice ID resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from a specified Amazon Connect Voice ID resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an
     * optional field, such as 'Description' is not provided, it is removed from the domain.
     * </p>
     *
     * @param updateDomainRequest
     * @return Result of the UpdateDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDomainResponse updateDomain(UpdateDomainRequest updateDomainRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, VoiceIdException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an
     * optional field, such as 'Description' is not provided, it is removed from the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDomainRequest#builder()}
     * </p>
     *
     * @param updateDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainRequest.Builder} to create a request.
     * @return Result of the UpdateDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more
     *         details.
     * @throws ValidationException
     *         The request failed one or more validations; check the error message for more details.
     * @throws ConflictException
     *         The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more
     *         details.
     * @throws InternalServerException
     *         The request failed due to an unknown error on the server side.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. Please slow down your request rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action. Check the error message and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VoiceIdException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VoiceIdClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDomainResponse updateDomain(Consumer<UpdateDomainRequest.Builder> updateDomainRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        return updateDomain(UpdateDomainRequest.builder().applyMutation(updateDomainRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
