/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateSessionResponse extends VoiceIdResponse implements
        ToCopyableBuilder<EvaluateSessionResponse.Builder, EvaluateSessionResponse> {
    private static final SdkField<AuthenticationResult> AUTHENTICATION_RESULT_FIELD = SdkField
            .<AuthenticationResult> builder(MarshallingType.SDK_POJO).memberName("AuthenticationResult")
            .getter(getter(EvaluateSessionResponse::authenticationResult)).setter(setter(Builder::authenticationResult))
            .constructor(AuthenticationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResult").build())
            .build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(EvaluateSessionResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<FraudDetectionResult> FRAUD_DETECTION_RESULT_FIELD = SdkField
            .<FraudDetectionResult> builder(MarshallingType.SDK_POJO).memberName("FraudDetectionResult")
            .getter(getter(EvaluateSessionResponse::fraudDetectionResult)).setter(setter(Builder::fraudDetectionResult))
            .constructor(FraudDetectionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudDetectionResult").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(EvaluateSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionName").getter(getter(EvaluateSessionResponse::sessionName)).setter(setter(Builder::sessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionName").build()).build();

    private static final SdkField<String> STREAMING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamingStatus").getter(getter(EvaluateSessionResponse::streamingStatusAsString))
            .setter(setter(Builder::streamingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_RESULT_FIELD,
            DOMAIN_ID_FIELD, FRAUD_DETECTION_RESULT_FIELD, SESSION_ID_FIELD, SESSION_NAME_FIELD, STREAMING_STATUS_FIELD));

    private final AuthenticationResult authenticationResult;

    private final String domainId;

    private final FraudDetectionResult fraudDetectionResult;

    private final String sessionId;

    private final String sessionName;

    private final String streamingStatus;

    private EvaluateSessionResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationResult = builder.authenticationResult;
        this.domainId = builder.domainId;
        this.fraudDetectionResult = builder.fraudDetectionResult;
        this.sessionId = builder.sessionId;
        this.sessionName = builder.sessionName;
        this.streamingStatus = builder.streamingStatus;
    }

    /**
     * <p>
     * Details resulting from the authentication process, such as authentication decision and authentication score.
     * </p>
     * 
     * @return Details resulting from the authentication process, such as authentication decision and authentication
     *         score.
     */
    public final AuthenticationResult authenticationResult() {
        return authenticationResult;
    }

    /**
     * <p>
     * The identifier of the domain containing the session.
     * </p>
     * 
     * @return The identifier of the domain containing the session.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Details resulting from the fraud detection process, such as fraud detection decision and risk score.
     * </p>
     * 
     * @return Details resulting from the fraud detection process, such as fraud detection decision and risk score.
     */
    public final FraudDetectionResult fraudDetectionResult() {
        return fraudDetectionResult;
    }

    /**
     * <p>
     * The service-generated identifier of the session.
     * </p>
     * 
     * @return The service-generated identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The client-provided name of the session.
     * </p>
     * 
     * @return The client-provided name of the session.
     */
    public final String sessionName() {
        return sessionName;
    }

    /**
     * <p>
     * The current status of audio streaming for this session. This field is useful to infer next steps when the
     * Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In this
     * situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can mean that
     * the client should call the API again later, once Voice ID has enough audio to produce a result. If the decision
     * remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>, it means
     * that the previously streamed session did not have enough speech to perform evaluation, and a new streaming
     * session is needed to try again.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamingStatus}
     * will return {@link StreamingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamingStatusAsString}.
     * </p>
     * 
     * @return The current status of audio streaming for this session. This field is useful to infer next steps when the
     *         Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In
     *         this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
     *         mean that the client should call the API again later, once Voice ID has enough audio to produce a result.
     *         If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is
     *         <code>ENDED</code>, it means that the previously streamed session did not have enough speech to perform
     *         evaluation, and a new streaming session is needed to try again.
     * @see StreamingStatus
     */
    public final StreamingStatus streamingStatus() {
        return StreamingStatus.fromValue(streamingStatus);
    }

    /**
     * <p>
     * The current status of audio streaming for this session. This field is useful to infer next steps when the
     * Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In this
     * situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can mean that
     * the client should call the API again later, once Voice ID has enough audio to produce a result. If the decision
     * remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>, it means
     * that the previously streamed session did not have enough speech to perform evaluation, and a new streaming
     * session is needed to try again.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamingStatus}
     * will return {@link StreamingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamingStatusAsString}.
     * </p>
     * 
     * @return The current status of audio streaming for this session. This field is useful to infer next steps when the
     *         Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In
     *         this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
     *         mean that the client should call the API again later, once Voice ID has enough audio to produce a result.
     *         If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is
     *         <code>ENDED</code>, it means that the previously streamed session did not have enough speech to perform
     *         evaluation, and a new streaming session is needed to try again.
     * @see StreamingStatus
     */
    public final String streamingStatusAsString() {
        return streamingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationResult());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(fraudDetectionResult());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(streamingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateSessionResponse)) {
            return false;
        }
        EvaluateSessionResponse other = (EvaluateSessionResponse) obj;
        return Objects.equals(authenticationResult(), other.authenticationResult())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(fraudDetectionResult(), other.fraudDetectionResult())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionName(), other.sessionName())
                && Objects.equals(streamingStatusAsString(), other.streamingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateSessionResponse").add("AuthenticationResult", authenticationResult())
                .add("DomainId", domainId()).add("FraudDetectionResult", fraudDetectionResult()).add("SessionId", sessionId())
                .add("SessionName", sessionName()).add("StreamingStatus", streamingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationResult":
            return Optional.ofNullable(clazz.cast(authenticationResult()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "FraudDetectionResult":
            return Optional.ofNullable(clazz.cast(fraudDetectionResult()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "SessionName":
            return Optional.ofNullable(clazz.cast(sessionName()));
        case "StreamingStatus":
            return Optional.ofNullable(clazz.cast(streamingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateSessionResponse, T> g) {
        return obj -> g.apply((EvaluateSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateSessionResponse> {
        /**
         * <p>
         * Details resulting from the authentication process, such as authentication decision and authentication score.
         * </p>
         * 
         * @param authenticationResult
         *        Details resulting from the authentication process, such as authentication decision and authentication
         *        score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationResult(AuthenticationResult authenticationResult);

        /**
         * <p>
         * Details resulting from the authentication process, such as authentication decision and authentication score.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthenticationResult.Builder} avoiding the need
         * to create one manually via {@link AuthenticationResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticationResult.Builder#build()} is called immediately and
         * its result is passed to {@link #authenticationResult(AuthenticationResult)}.
         * 
         * @param authenticationResult
         *        a consumer that will call methods on {@link AuthenticationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationResult(AuthenticationResult)
         */
        default Builder authenticationResult(Consumer<AuthenticationResult.Builder> authenticationResult) {
            return authenticationResult(AuthenticationResult.builder().applyMutation(authenticationResult).build());
        }

        /**
         * <p>
         * The identifier of the domain containing the session.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain containing the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Details resulting from the fraud detection process, such as fraud detection decision and risk score.
         * </p>
         * 
         * @param fraudDetectionResult
         *        Details resulting from the fraud detection process, such as fraud detection decision and risk score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fraudDetectionResult(FraudDetectionResult fraudDetectionResult);

        /**
         * <p>
         * Details resulting from the fraud detection process, such as fraud detection decision and risk score.
         * </p>
         * This is a convenience that creates an instance of the {@link FraudDetectionResult.Builder} avoiding the need
         * to create one manually via {@link FraudDetectionResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link FraudDetectionResult.Builder#build()} is called immediately and
         * its result is passed to {@link #fraudDetectionResult(FraudDetectionResult)}.
         * 
         * @param fraudDetectionResult
         *        a consumer that will call methods on {@link FraudDetectionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fraudDetectionResult(FraudDetectionResult)
         */
        default Builder fraudDetectionResult(Consumer<FraudDetectionResult.Builder> fraudDetectionResult) {
            return fraudDetectionResult(FraudDetectionResult.builder().applyMutation(fraudDetectionResult).build());
        }

        /**
         * <p>
         * The service-generated identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The service-generated identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The client-provided name of the session.
         * </p>
         * 
         * @param sessionName
         *        The client-provided name of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionName(String sessionName);

        /**
         * <p>
         * The current status of audio streaming for this session. This field is useful to infer next steps when the
         * Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In
         * this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
         * mean that the client should call the API again later, once Voice ID has enough audio to produce a result. If
         * the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is
         * <code>ENDED</code>, it means that the previously streamed session did not have enough speech to perform
         * evaluation, and a new streaming session is needed to try again.
         * </p>
         * 
         * @param streamingStatus
         *        The current status of audio streaming for this session. This field is useful to infer next steps when
         *        the Authentication or Fraud Detection results are empty or the decision is
         *        <code>NOT_ENOUGH_SPEECH</code>. In this situation, if the <code>StreamingStatus</code> is
         *        <code>ONGOING/PENDING_CONFIGURATION</code>, it can mean that the client should call the API again
         *        later, once Voice ID has enough audio to produce a result. If the decision remains
         *        <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>, it means
         *        that the previously streamed session did not have enough speech to perform evaluation, and a new
         *        streaming session is needed to try again.
         * @see StreamingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingStatus
         */
        Builder streamingStatus(String streamingStatus);

        /**
         * <p>
         * The current status of audio streaming for this session. This field is useful to infer next steps when the
         * Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In
         * this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
         * mean that the client should call the API again later, once Voice ID has enough audio to produce a result. If
         * the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is
         * <code>ENDED</code>, it means that the previously streamed session did not have enough speech to perform
         * evaluation, and a new streaming session is needed to try again.
         * </p>
         * 
         * @param streamingStatus
         *        The current status of audio streaming for this session. This field is useful to infer next steps when
         *        the Authentication or Fraud Detection results are empty or the decision is
         *        <code>NOT_ENOUGH_SPEECH</code>. In this situation, if the <code>StreamingStatus</code> is
         *        <code>ONGOING/PENDING_CONFIGURATION</code>, it can mean that the client should call the API again
         *        later, once Voice ID has enough audio to produce a result. If the decision remains
         *        <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>, it means
         *        that the previously streamed session did not have enough speech to perform evaluation, and a new
         *        streaming session is needed to try again.
         * @see StreamingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingStatus
         */
        Builder streamingStatus(StreamingStatus streamingStatus);
    }

    static final class BuilderImpl extends VoiceIdResponse.BuilderImpl implements Builder {
        private AuthenticationResult authenticationResult;

        private String domainId;

        private FraudDetectionResult fraudDetectionResult;

        private String sessionId;

        private String sessionName;

        private String streamingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateSessionResponse model) {
            super(model);
            authenticationResult(model.authenticationResult);
            domainId(model.domainId);
            fraudDetectionResult(model.fraudDetectionResult);
            sessionId(model.sessionId);
            sessionName(model.sessionName);
            streamingStatus(model.streamingStatus);
        }

        public final AuthenticationResult.Builder getAuthenticationResult() {
            return authenticationResult != null ? authenticationResult.toBuilder() : null;
        }

        public final void setAuthenticationResult(AuthenticationResult.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        @Transient
        public final Builder authenticationResult(AuthenticationResult authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final FraudDetectionResult.Builder getFraudDetectionResult() {
            return fraudDetectionResult != null ? fraudDetectionResult.toBuilder() : null;
        }

        public final void setFraudDetectionResult(FraudDetectionResult.BuilderImpl fraudDetectionResult) {
            this.fraudDetectionResult = fraudDetectionResult != null ? fraudDetectionResult.build() : null;
        }

        @Override
        @Transient
        public final Builder fraudDetectionResult(FraudDetectionResult fraudDetectionResult) {
            this.fraudDetectionResult = fraudDetectionResult;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionName() {
            return sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        @Transient
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final String getStreamingStatus() {
            return streamingStatus;
        }

        public final void setStreamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
        }

        @Override
        @Transient
        public final Builder streamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder streamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus == null ? null : streamingStatus.toString());
            return this;
        }

        @Override
        public EvaluateSessionResponse build() {
            return new EvaluateSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
