/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration used for performing fraud detection over a speaker during a session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FraudDetectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FraudDetectionConfiguration.Builder, FraudDetectionConfiguration> {
    private static final SdkField<Integer> RISK_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RiskThreshold").getter(getter(FraudDetectionConfiguration::riskThreshold))
            .setter(setter(Builder::riskThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer riskThreshold;

    private FraudDetectionConfiguration(BuilderImpl builder) {
        this.riskThreshold = builder.riskThreshold;
    }

    /**
     * <p>
     * Threshold value for determining whether the speaker is a fraudster. If the detected risk score calculated by
     * Voice ID is higher than the threshold, the speaker is considered a fraudster.
     * </p>
     * 
     * @return Threshold value for determining whether the speaker is a fraudster. If the detected risk score calculated
     *         by Voice ID is higher than the threshold, the speaker is considered a fraudster.
     */
    public final Integer riskThreshold() {
        return riskThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(riskThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudDetectionConfiguration)) {
            return false;
        }
        FraudDetectionConfiguration other = (FraudDetectionConfiguration) obj;
        return Objects.equals(riskThreshold(), other.riskThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FraudDetectionConfiguration").add("RiskThreshold", riskThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RiskThreshold":
            return Optional.ofNullable(clazz.cast(riskThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FraudDetectionConfiguration, T> g) {
        return obj -> g.apply((FraudDetectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FraudDetectionConfiguration> {
        /**
         * <p>
         * Threshold value for determining whether the speaker is a fraudster. If the detected risk score calculated by
         * Voice ID is higher than the threshold, the speaker is considered a fraudster.
         * </p>
         * 
         * @param riskThreshold
         *        Threshold value for determining whether the speaker is a fraudster. If the detected risk score
         *        calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskThreshold(Integer riskThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Integer riskThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(FraudDetectionConfiguration model) {
            riskThreshold(model.riskThreshold);
        }

        public final Integer getRiskThreshold() {
            return riskThreshold;
        }

        public final void setRiskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
        }

        @Override
        @Transient
        public final Builder riskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
            return this;
        }

        @Override
        public FraudDetectionConfiguration build() {
            return new FraudDetectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
