/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all the information about a speaker enrollment job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeakerEnrollmentJob implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeakerEnrollmentJob.Builder, SpeakerEnrollmentJob> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(SpeakerEnrollmentJob::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(SpeakerEnrollmentJob::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(SpeakerEnrollmentJob::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndedAt").getter(getter(SpeakerEnrollmentJob::endedAt)).setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()).build();

    private static final SdkField<EnrollmentConfig> ENROLLMENT_CONFIG_FIELD = SdkField
            .<EnrollmentConfig> builder(MarshallingType.SDK_POJO).memberName("EnrollmentConfig")
            .getter(getter(SpeakerEnrollmentJob::enrollmentConfig)).setter(setter(Builder::enrollmentConfig))
            .constructor(EnrollmentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentConfig").build()).build();

    private static final SdkField<FailureDetails> FAILURE_DETAILS_FIELD = SdkField
            .<FailureDetails> builder(MarshallingType.SDK_POJO).memberName("FailureDetails")
            .getter(getter(SpeakerEnrollmentJob::failureDetails)).setter(setter(Builder::failureDetails))
            .constructor(FailureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(SpeakerEnrollmentJob::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(SpeakerEnrollmentJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(SpeakerEnrollmentJob::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<JobProgress> JOB_PROGRESS_FIELD = SdkField.<JobProgress> builder(MarshallingType.SDK_POJO)
            .memberName("JobProgress").getter(getter(SpeakerEnrollmentJob::jobProgress)).setter(setter(Builder::jobProgress))
            .constructor(JobProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobProgress").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(SpeakerEnrollmentJob::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(SpeakerEnrollmentJob::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATED_AT_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, DOMAIN_ID_FIELD, ENDED_AT_FIELD, ENROLLMENT_CONFIG_FIELD,
                    FAILURE_DETAILS_FIELD, INPUT_DATA_CONFIG_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_PROGRESS_FIELD,
                    JOB_STATUS_FIELD, OUTPUT_DATA_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String dataAccessRoleArn;

    private final String domainId;

    private final Instant endedAt;

    private final EnrollmentConfig enrollmentConfig;

    private final FailureDetails failureDetails;

    private final InputDataConfig inputDataConfig;

    private final String jobId;

    private final String jobName;

    private final JobProgress jobProgress;

    private final String jobStatus;

    private final OutputDataConfig outputDataConfig;

    private SpeakerEnrollmentJob(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.domainId = builder.domainId;
        this.endedAt = builder.endedAt;
        this.enrollmentConfig = builder.enrollmentConfig;
        this.failureDetails = builder.failureDetails;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobProgress = builder.jobProgress;
        this.jobStatus = builder.jobStatus;
        this.outputDataConfig = builder.outputDataConfig;
    }

    /**
     * <p>
     * A timestamp showing the creation of the speaker enrollment job.
     * </p>
     * 
     * @return A timestamp showing the creation of the speaker enrollment job.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the
     * input manifest file and write the job output file.
     * </p>
     * 
     * @return The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to
     *         read the input manifest file and write the job output file.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The identifier of the domain that contains the speaker enrollment job.
     * </p>
     * 
     * @return The identifier of the domain that contains the speaker enrollment job.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * A timestamp showing when the speaker enrollment job ended.
     * </p>
     * 
     * @return A timestamp showing when the speaker enrollment job ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the
     * <code>FraudDetectionConfig</code> to use.
     * </p>
     * 
     * @return The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and
     *         the <code>FraudDetectionConfig</code> to use.
     */
    public final EnrollmentConfig enrollmentConfig() {
        return enrollmentConfig;
    }

    /**
     * <p>
     * Contains details that are populated when an entire batch job fails. In cases of individual registration job
     * failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
     * <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration
     * requests that failed.
     * </p>
     * 
     * @return Contains details that are populated when an entire batch job fails. In cases of individual registration
     *         job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
     *         <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
     *         registration requests that failed.
     */
    public final FailureDetails failureDetails() {
        return failureDetails;
    }

    /**
     * <p>
     * The input data config containing an S3 URI for the input manifest file that contains the list of speaker
     * enrollment job requests.
     * </p>
     * 
     * @return The input data config containing an S3 URI for the input manifest file that contains the list of speaker
     *         enrollment job requests.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The service-generated identifier for the speaker enrollment job.
     * </p>
     * 
     * @return The service-generated identifier for the speaker enrollment job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The client-provided name for the speaker enrollment job.
     * </p>
     * 
     * @return The client-provided name for the speaker enrollment job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Provides details on job progress. This field shows the completed percentage of registration requests listed in
     * the input file.
     * </p>
     * 
     * @return Provides details on job progress. This field shows the completed percentage of registration requests
     *         listed in the input file.
     */
    public final JobProgress jobProgress() {
        return jobProgress;
    }

    /**
     * <p>
     * The current status of the speaker enrollment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link SpeakerEnrollmentJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the speaker enrollment job.
     * @see SpeakerEnrollmentJobStatus
     */
    public final SpeakerEnrollmentJobStatus jobStatus() {
        return SpeakerEnrollmentJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the speaker enrollment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link SpeakerEnrollmentJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the speaker enrollment job.
     * @see SpeakerEnrollmentJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The output data config containing the S3 location where Voice ID writes the job output file; you must also
     * include a KMS Key ID to encrypt the file.
     * </p>
     * 
     * @return The output data config containing the S3 location where Voice ID writes the job output file; you must
     *         also include a KMS Key ID to encrypt the file.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobProgress());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerEnrollmentJob)) {
            return false;
        }
        SpeakerEnrollmentJob other = (SpeakerEnrollmentJob) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(enrollmentConfig(), other.enrollmentConfig())
                && Objects.equals(failureDetails(), other.failureDetails())
                && Objects.equals(inputDataConfig(), other.inputDataConfig()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobProgress(), other.jobProgress())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(outputDataConfig(), other.outputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeakerEnrollmentJob").add("CreatedAt", createdAt())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("DomainId", domainId()).add("EndedAt", endedAt())
                .add("EnrollmentConfig", enrollmentConfig()).add("FailureDetails", failureDetails())
                .add("InputDataConfig", inputDataConfig()).add("JobId", jobId())
                .add("JobName", jobName() == null ? null : "*** Sensitive Data Redacted ***").add("JobProgress", jobProgress())
                .add("JobStatus", jobStatusAsString()).add("OutputDataConfig", outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "EndedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "EnrollmentConfig":
            return Optional.ofNullable(clazz.cast(enrollmentConfig()));
        case "FailureDetails":
            return Optional.ofNullable(clazz.cast(failureDetails()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobProgress":
            return Optional.ofNullable(clazz.cast(jobProgress()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerEnrollmentJob, T> g) {
        return obj -> g.apply((SpeakerEnrollmentJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeakerEnrollmentJob> {
        /**
         * <p>
         * A timestamp showing the creation of the speaker enrollment job.
         * </p>
         * 
         * @param createdAt
         *        A timestamp showing the creation of the speaker enrollment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read
         * the input manifest file and write the job output file.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
         *        to read the input manifest file and write the job output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The identifier of the domain that contains the speaker enrollment job.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain that contains the speaker enrollment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * A timestamp showing when the speaker enrollment job ended.
         * </p>
         * 
         * @param endedAt
         *        A timestamp showing when the speaker enrollment job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the
         * <code>FraudDetectionConfig</code> to use.
         * </p>
         * 
         * @param enrollmentConfig
         *        The configuration that defines the action to take when the speaker is already enrolled in Voice ID,
         *        and the <code>FraudDetectionConfig</code> to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentConfig(EnrollmentConfig enrollmentConfig);

        /**
         * <p>
         * The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the
         * <code>FraudDetectionConfig</code> to use.
         * </p>
         * This is a convenience that creates an instance of the {@link EnrollmentConfig.Builder} avoiding the need to
         * create one manually via {@link EnrollmentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnrollmentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #enrollmentConfig(EnrollmentConfig)}.
         * 
         * @param enrollmentConfig
         *        a consumer that will call methods on {@link EnrollmentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrollmentConfig(EnrollmentConfig)
         */
        default Builder enrollmentConfig(Consumer<EnrollmentConfig.Builder> enrollmentConfig) {
            return enrollmentConfig(EnrollmentConfig.builder().applyMutation(enrollmentConfig).build());
        }

        /**
         * <p>
         * Contains details that are populated when an entire batch job fails. In cases of individual registration job
         * failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
         * <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration
         * requests that failed.
         * </p>
         * 
         * @param failureDetails
         *        Contains details that are populated when an entire batch job fails. In cases of individual
         *        registration job failures, the batch job as a whole doesn't fail; it is completed with a
         *        <code>JobStatus</code> of <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to
         *        identify the individual registration requests that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDetails(FailureDetails failureDetails);

        /**
         * <p>
         * Contains details that are populated when an entire batch job fails. In cases of individual registration job
         * failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
         * <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration
         * requests that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link FailureDetails.Builder} avoiding the need to
         * create one manually via {@link FailureDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link FailureDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #failureDetails(FailureDetails)}.
         * 
         * @param failureDetails
         *        a consumer that will call methods on {@link FailureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDetails(FailureDetails)
         */
        default Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return failureDetails(FailureDetails.builder().applyMutation(failureDetails).build());
        }

        /**
         * <p>
         * The input data config containing an S3 URI for the input manifest file that contains the list of speaker
         * enrollment job requests.
         * </p>
         * 
         * @param inputDataConfig
         *        The input data config containing an S3 URI for the input manifest file that contains the list of
         *        speaker enrollment job requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * The input data config containing an S3 URI for the input manifest file that contains the list of speaker
         * enrollment job requests.
         * </p>
         * This is a convenience that creates an instance of the {@link InputDataConfig.Builder} avoiding the need to
         * create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * The service-generated identifier for the speaker enrollment job.
         * </p>
         * 
         * @param jobId
         *        The service-generated identifier for the speaker enrollment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The client-provided name for the speaker enrollment job.
         * </p>
         * 
         * @param jobName
         *        The client-provided name for the speaker enrollment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Provides details on job progress. This field shows the completed percentage of registration requests listed
         * in the input file.
         * </p>
         * 
         * @param jobProgress
         *        Provides details on job progress. This field shows the completed percentage of registration requests
         *        listed in the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobProgress(JobProgress jobProgress);

        /**
         * <p>
         * Provides details on job progress. This field shows the completed percentage of registration requests listed
         * in the input file.
         * </p>
         * This is a convenience that creates an instance of the {@link JobProgress.Builder} avoiding the need to create
         * one manually via {@link JobProgress#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobProgress.Builder#build()} is called immediately and its result
         * is passed to {@link #jobProgress(JobProgress)}.
         * 
         * @param jobProgress
         *        a consumer that will call methods on {@link JobProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobProgress(JobProgress)
         */
        default Builder jobProgress(Consumer<JobProgress.Builder> jobProgress) {
            return jobProgress(JobProgress.builder().applyMutation(jobProgress).build());
        }

        /**
         * <p>
         * The current status of the speaker enrollment job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the speaker enrollment job.
         * @see SpeakerEnrollmentJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeakerEnrollmentJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the speaker enrollment job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the speaker enrollment job.
         * @see SpeakerEnrollmentJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeakerEnrollmentJobStatus
         */
        Builder jobStatus(SpeakerEnrollmentJobStatus jobStatus);

        /**
         * <p>
         * The output data config containing the S3 location where Voice ID writes the job output file; you must also
         * include a KMS Key ID to encrypt the file.
         * </p>
         * 
         * @param outputDataConfig
         *        The output data config containing the S3 location where Voice ID writes the job output file; you must
         *        also include a KMS Key ID to encrypt the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * The output data config containing the S3 location where Voice ID writes the job output file; you must also
         * include a KMS Key ID to encrypt the file.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputDataConfig.Builder} avoiding the need to
         * create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String dataAccessRoleArn;

        private String domainId;

        private Instant endedAt;

        private EnrollmentConfig enrollmentConfig;

        private FailureDetails failureDetails;

        private InputDataConfig inputDataConfig;

        private String jobId;

        private String jobName;

        private JobProgress jobProgress;

        private String jobStatus;

        private OutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerEnrollmentJob model) {
            createdAt(model.createdAt);
            dataAccessRoleArn(model.dataAccessRoleArn);
            domainId(model.domainId);
            endedAt(model.endedAt);
            enrollmentConfig(model.enrollmentConfig);
            failureDetails(model.failureDetails);
            inputDataConfig(model.inputDataConfig);
            jobId(model.jobId);
            jobName(model.jobName);
            jobProgress(model.jobProgress);
            jobStatus(model.jobStatus);
            outputDataConfig(model.outputDataConfig);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        @Transient
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final EnrollmentConfig.Builder getEnrollmentConfig() {
            return enrollmentConfig != null ? enrollmentConfig.toBuilder() : null;
        }

        public final void setEnrollmentConfig(EnrollmentConfig.BuilderImpl enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig != null ? enrollmentConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder enrollmentConfig(EnrollmentConfig enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig;
            return this;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return failureDetails != null ? failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobProgress.Builder getJobProgress() {
            return jobProgress != null ? jobProgress.toBuilder() : null;
        }

        public final void setJobProgress(JobProgress.BuilderImpl jobProgress) {
            this.jobProgress = jobProgress != null ? jobProgress.build() : null;
        }

        @Override
        @Transient
        public final Builder jobProgress(JobProgress jobProgress) {
            this.jobProgress = jobProgress;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        @Transient
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder jobStatus(SpeakerEnrollmentJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        @Override
        public SpeakerEnrollmentJob build() {
            return new SpeakerEnrollmentJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
