/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details produced as a result of performing known fraudster risk analysis on a speaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnownFraudsterRisk implements SdkPojo, Serializable,
        ToCopyableBuilder<KnownFraudsterRisk.Builder, KnownFraudsterRisk> {
    private static final SdkField<String> GENERATED_FRAUDSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedFraudsterId").getter(getter(KnownFraudsterRisk::generatedFraudsterId))
            .setter(setter(Builder::generatedFraudsterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedFraudsterId").build())
            .build();

    private static final SdkField<Integer> RISK_SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RiskScore").getter(getter(KnownFraudsterRisk::riskScore)).setter(setter(Builder::riskScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_FRAUDSTER_ID_FIELD,
            RISK_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String generatedFraudsterId;

    private final Integer riskScore;

    private KnownFraudsterRisk(BuilderImpl builder) {
        this.generatedFraudsterId = builder.generatedFraudsterId;
        this.riskScore = builder.riskScore;
    }

    /**
     * <p>
     * The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters registered
     * in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is <code>null</code>.
     * </p>
     * 
     * @return The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters
     *         registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is
     *         <code>null</code>.
     */
    public final String generatedFraudsterId() {
        return generatedFraudsterId;
    }

    /**
     * <p>
     * The score indicating the likelihood the speaker is a known fraudster.
     * </p>
     * 
     * @return The score indicating the likelihood the speaker is a known fraudster.
     */
    public final Integer riskScore() {
        return riskScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generatedFraudsterId());
        hashCode = 31 * hashCode + Objects.hashCode(riskScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnownFraudsterRisk)) {
            return false;
        }
        KnownFraudsterRisk other = (KnownFraudsterRisk) obj;
        return Objects.equals(generatedFraudsterId(), other.generatedFraudsterId())
                && Objects.equals(riskScore(), other.riskScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnownFraudsterRisk").add("GeneratedFraudsterId", generatedFraudsterId())
                .add("RiskScore", riskScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedFraudsterId":
            return Optional.ofNullable(clazz.cast(generatedFraudsterId()));
        case "RiskScore":
            return Optional.ofNullable(clazz.cast(riskScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnownFraudsterRisk, T> g) {
        return obj -> g.apply((KnownFraudsterRisk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnownFraudsterRisk> {
        /**
         * <p>
         * The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters
         * registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is
         * <code>null</code>.
         * </p>
         * 
         * @param generatedFraudsterId
         *        The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters
         *        registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFraudsterId(String generatedFraudsterId);

        /**
         * <p>
         * The score indicating the likelihood the speaker is a known fraudster.
         * </p>
         * 
         * @param riskScore
         *        The score indicating the likelihood the speaker is a known fraudster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskScore(Integer riskScore);
    }

    static final class BuilderImpl implements Builder {
        private String generatedFraudsterId;

        private Integer riskScore;

        private BuilderImpl() {
        }

        private BuilderImpl(KnownFraudsterRisk model) {
            generatedFraudsterId(model.generatedFraudsterId);
            riskScore(model.riskScore);
        }

        public final String getGeneratedFraudsterId() {
            return generatedFraudsterId;
        }

        public final void setGeneratedFraudsterId(String generatedFraudsterId) {
            this.generatedFraudsterId = generatedFraudsterId;
        }

        @Override
        public final Builder generatedFraudsterId(String generatedFraudsterId) {
            this.generatedFraudsterId = generatedFraudsterId;
            return this;
        }

        public final Integer getRiskScore() {
            return riskScore;
        }

        public final void setRiskScore(Integer riskScore) {
            this.riskScore = riskScore;
        }

        @Override
        public final Builder riskScore(Integer riskScore) {
            this.riskScore = riskScore;
            return this;
        }

        @Override
        public KnownFraudsterRisk build() {
            return new KnownFraudsterRisk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
