/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainRequest extends VoiceIdRequest implements
        ToCopyableBuilder<UpdateDomainRequest.Builder, UpdateDomainRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDomainRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UpdateDomainRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDomainRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionConfiguration")
            .getter(getter(UpdateDomainRequest::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_ID_FIELD, NAME_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD));

    private final String description;

    private final String domainId;

    private final String name;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * A brief description about this domain.
     * </p>
     * 
     * @return A brief description about this domain.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the domain to be updated.
     * </p>
     * 
     * @return The identifier of the domain to be updated.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side encryption of
     * your data. Changing the domain's associated KMS key immediately triggers an asynchronous process to remove
     * dependency on the old KMS key, such that the domain's data can only be accessed using the new KMS key. The
     * domain's <code>ServerSideEncryptionUpdateDetails</code> contains the details for this process.
     * </p>
     * 
     * @return The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side
     *         encryption of your data. Changing the domain's associated KMS key immediately triggers an asynchronous
     *         process to remove dependency on the old KMS key, such that the domain's data can only be accessed using
     *         the new KMS key. The domain's <code>ServerSideEncryptionUpdateDetails</code> contains the details for
     *         this process.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(name(), other.name())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VoiceIdRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainRequest> {
        /**
         * <p>
         * A brief description about this domain.
         * </p>
         * 
         * @param description
         *        A brief description about this domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the domain to be updated.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param name
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side encryption
         * of your data. Changing the domain's associated KMS key immediately triggers an asynchronous process to remove
         * dependency on the old KMS key, such that the domain's data can only be accessed using the new KMS key. The
         * domain's <code>ServerSideEncryptionUpdateDetails</code> contains the details for this process.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side
         *        encryption of your data. Changing the domain's associated KMS key immediately triggers an asynchronous
         *        process to remove dependency on the old KMS key, such that the domain's data can only be accessed
         *        using the new KMS key. The domain's <code>ServerSideEncryptionUpdateDetails</code> contains the
         *        details for this process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side encryption
         * of your data. Changing the domain's associated KMS key immediately triggers an asynchronous process to remove
         * dependency on the old KMS key, such that the domain's data can only be accessed using the new KMS key. The
         * domain's <code>ServerSideEncryptionUpdateDetails</code> contains the details for this process.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VoiceIdRequest.BuilderImpl implements Builder {
        private String description;

        private String domainId;

        private String name;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            description(model.description);
            domainId(model.domainId);
            name(model.name);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
