/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.voiceid.model.AssociateFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.AssociateFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.CreateDomainRequest;
import software.amazon.awssdk.services.voiceid.model.CreateDomainResponse;
import software.amazon.awssdk.services.voiceid.model.CreateWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.CreateWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteDomainRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeDomainRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.DisassociateFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DisassociateFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.EvaluateSessionRequest;
import software.amazon.awssdk.services.voiceid.model.EvaluateSessionResponse;
import software.amazon.awssdk.services.voiceid.model.ListDomainsRequest;
import software.amazon.awssdk.services.voiceid.model.ListDomainsResponse;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse;
import software.amazon.awssdk.services.voiceid.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.voiceid.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse;
import software.amazon.awssdk.services.voiceid.model.OptOutSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.OptOutSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobRequest;
import software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobResponse;
import software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobRequest;
import software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobResponse;
import software.amazon.awssdk.services.voiceid.model.TagResourceRequest;
import software.amazon.awssdk.services.voiceid.model.TagResourceResponse;
import software.amazon.awssdk.services.voiceid.model.UntagResourceRequest;
import software.amazon.awssdk.services.voiceid.model.UntagResourceResponse;
import software.amazon.awssdk.services.voiceid.model.UpdateDomainRequest;
import software.amazon.awssdk.services.voiceid.model.UpdateDomainResponse;
import software.amazon.awssdk.services.voiceid.model.UpdateWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.UpdateWatchlistResponse;
import software.amazon.awssdk.services.voiceid.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsPublisher;
import software.amazon.awssdk.services.voiceid.paginators.ListFraudstersPublisher;
import software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsPublisher;
import software.amazon.awssdk.services.voiceid.paginators.ListSpeakersPublisher;
import software.amazon.awssdk.services.voiceid.paginators.ListWatchlistsPublisher;

/**
 * Service client for accessing Amazon Voice ID asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Connect Voice ID provides real-time caller authentication and fraud risk detection, which make voice
 * interactions in contact centers more secure and efficient.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface VoiceIdAsyncClient extends AwsClient {
    String SERVICE_NAME = "voiceid";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "voiceid";

    /**
     * <p>
     * Associates the fraudsters with the watchlist specified in the same domain.
     * </p>
     *
     * @param associateFraudsterRequest
     * @return A Java Future containing the result of the AssociateFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.AssociateFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/AssociateFraudster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateFraudsterResponse> associateFraudster(AssociateFraudsterRequest associateFraudsterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the fraudsters with the watchlist specified in the same domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFraudsterRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateFraudsterRequest#builder()}
     * </p>
     *
     * @param associateFraudsterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.AssociateFraudsterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.AssociateFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/AssociateFraudster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateFraudsterResponse> associateFraudster(
            Consumer<AssociateFraudsterRequest.Builder> associateFraudsterRequest) {
        return associateFraudster(AssociateFraudsterRequest.builder().applyMutation(associateFraudsterRequest).build());
    }

    /**
     * <p>
     * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio,
     * and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio,
     * and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a watchlist that fraudsters can be a part of.
     * </p>
     *
     * @param createWatchlistRequest
     * @return A Java Future containing the result of the CreateWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.CreateWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateWatchlist" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWatchlistResponse> createWatchlist(CreateWatchlistRequest createWatchlistRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a watchlist that fraudsters can be a part of.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWatchlistRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWatchlistRequest#builder()}
     * </p>
     *
     * @param createWatchlistRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.CreateWatchlistRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.CreateWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateWatchlist" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWatchlistResponse> createWatchlist(
            Consumer<CreateWatchlistRequest.Builder> createWatchlistRequest) {
        return createWatchlist(CreateWatchlistRequest.builder().applyMutation(createWatchlistRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain from Voice ID.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain from Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the specified fraudster from Voice ID. This action disassociates the fraudster from any watchlists it is
     * a part of.
     * </p>
     *
     * @param deleteFraudsterRequest
     * @return A Java Future containing the result of the DeleteFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteFraudster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFraudsterResponse> deleteFraudster(DeleteFraudsterRequest deleteFraudsterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified fraudster from Voice ID. This action disassociates the fraudster from any watchlists it is
     * a part of.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFraudsterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFraudsterRequest#builder()}
     * </p>
     *
     * @param deleteFraudsterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DeleteFraudsterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteFraudster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFraudsterResponse> deleteFraudster(
            Consumer<DeleteFraudsterRequest.Builder> deleteFraudsterRequest) {
        return deleteFraudster(DeleteFraudsterRequest.builder().applyMutation(deleteFraudsterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified speaker from Voice ID.
     * </p>
     *
     * @param deleteSpeakerRequest
     * @return A Java Future containing the result of the DeleteSpeaker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSpeakerResponse> deleteSpeaker(DeleteSpeakerRequest deleteSpeakerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified speaker from Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpeakerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSpeakerRequest#builder()}
     * </p>
     *
     * @param deleteSpeakerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DeleteSpeakerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSpeaker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSpeakerResponse> deleteSpeaker(Consumer<DeleteSpeakerRequest.Builder> deleteSpeakerRequest) {
        return deleteSpeaker(DeleteSpeakerRequest.builder().applyMutation(deleteSpeakerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified watchlist from Voice ID. This API throws an exception when there are fraudsters in the
     * watchlist that you are trying to delete. You must delete the fraudsters, and then delete the watchlist. Every
     * domain has a default watchlist which cannot be deleted.
     * </p>
     *
     * @param deleteWatchlistRequest
     * @return A Java Future containing the result of the DeleteWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteWatchlist" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWatchlistResponse> deleteWatchlist(DeleteWatchlistRequest deleteWatchlistRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified watchlist from Voice ID. This API throws an exception when there are fraudsters in the
     * watchlist that you are trying to delete. You must delete the fraudsters, and then delete the watchlist. Every
     * domain has a default watchlist which cannot be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWatchlistRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWatchlistRequest#builder()}
     * </p>
     *
     * @param deleteWatchlistRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DeleteWatchlistRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DeleteWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteWatchlist" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWatchlistResponse> deleteWatchlist(
            Consumer<DeleteWatchlistRequest.Builder> deleteWatchlistRequest) {
        return deleteWatchlist(DeleteWatchlistRequest.builder().applyMutation(deleteWatchlistRequest).build());
    }

    /**
     * <p>
     * Describes the specified domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DescribeDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest) {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Describes the specified fraudster.
     * </p>
     *
     * @param describeFraudsterRequest
     * @return A Java Future containing the result of the DescribeFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFraudsterResponse> describeFraudster(DescribeFraudsterRequest describeFraudsterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified fraudster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFraudsterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFraudsterRequest#builder()}
     * </p>
     *
     * @param describeFraudsterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFraudsterResponse> describeFraudster(
            Consumer<DescribeFraudsterRequest.Builder> describeFraudsterRequest) {
        return describeFraudster(DescribeFraudsterRequest.builder().applyMutation(describeFraudsterRequest).build());
    }

    /**
     * <p>
     * Describes the specified fraudster registration job.
     * </p>
     *
     * @param describeFraudsterRegistrationJobRequest
     * @return A Java Future containing the result of the DescribeFraudsterRegistrationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFraudsterRegistrationJobResponse> describeFraudsterRegistrationJob(
            DescribeFraudsterRegistrationJobRequest describeFraudsterRegistrationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified fraudster registration job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFraudsterRegistrationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFraudsterRegistrationJobRequest#builder()}
     * </p>
     *
     * @param describeFraudsterRegistrationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFraudsterRegistrationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFraudsterRegistrationJobResponse> describeFraudsterRegistrationJob(
            Consumer<DescribeFraudsterRegistrationJobRequest.Builder> describeFraudsterRegistrationJobRequest) {
        return describeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest.builder()
                .applyMutation(describeFraudsterRegistrationJobRequest).build());
    }

    /**
     * <p>
     * Describes the specified speaker.
     * </p>
     *
     * @param describeSpeakerRequest
     * @return A Java Future containing the result of the DescribeSpeaker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSpeakerResponse> describeSpeaker(DescribeSpeakerRequest describeSpeakerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified speaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpeakerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSpeakerRequest#builder()}
     * </p>
     *
     * @param describeSpeakerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DescribeSpeakerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSpeaker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSpeakerResponse> describeSpeaker(
            Consumer<DescribeSpeakerRequest.Builder> describeSpeakerRequest) {
        return describeSpeaker(DescribeSpeakerRequest.builder().applyMutation(describeSpeakerRequest).build());
    }

    /**
     * <p>
     * Describes the specified speaker enrollment job.
     * </p>
     *
     * @param describeSpeakerEnrollmentJobRequest
     * @return A Java Future containing the result of the DescribeSpeakerEnrollmentJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSpeakerEnrollmentJobResponse> describeSpeakerEnrollmentJob(
            DescribeSpeakerEnrollmentJobRequest describeSpeakerEnrollmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified speaker enrollment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpeakerEnrollmentJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSpeakerEnrollmentJobRequest#builder()}
     * </p>
     *
     * @param describeSpeakerEnrollmentJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSpeakerEnrollmentJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSpeakerEnrollmentJobResponse> describeSpeakerEnrollmentJob(
            Consumer<DescribeSpeakerEnrollmentJobRequest.Builder> describeSpeakerEnrollmentJobRequest) {
        return describeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest.builder()
                .applyMutation(describeSpeakerEnrollmentJobRequest).build());
    }

    /**
     * <p>
     * Describes the specified watchlist.
     * </p>
     *
     * @param describeWatchlistRequest
     * @return A Java Future containing the result of the DescribeWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeWatchlist" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWatchlistResponse> describeWatchlist(DescribeWatchlistRequest describeWatchlistRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified watchlist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWatchlistRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWatchlistRequest#builder()}
     * </p>
     *
     * @param describeWatchlistRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DescribeWatchlistRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DescribeWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeWatchlist" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWatchlistResponse> describeWatchlist(
            Consumer<DescribeWatchlistRequest.Builder> describeWatchlistRequest) {
        return describeWatchlist(DescribeWatchlistRequest.builder().applyMutation(describeWatchlistRequest).build());
    }

    /**
     * <p>
     * Disassociates the fraudsters from the watchlist specified. Voice ID always expects a fraudster to be a part of at
     * least one watchlist. If you try to disassociate a fraudster from its only watchlist, a
     * <code>ValidationException</code> is thrown.
     * </p>
     *
     * @param disassociateFraudsterRequest
     * @return A Java Future containing the result of the DisassociateFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DisassociateFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DisassociateFraudster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFraudsterResponse> disassociateFraudster(
            DisassociateFraudsterRequest disassociateFraudsterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the fraudsters from the watchlist specified. Voice ID always expects a fraudster to be a part of at
     * least one watchlist. If you try to disassociate a fraudster from its only watchlist, a
     * <code>ValidationException</code> is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFraudsterRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateFraudsterRequest#builder()}
     * </p>
     *
     * @param disassociateFraudsterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.DisassociateFraudsterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateFraudster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.DisassociateFraudster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DisassociateFraudster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFraudsterResponse> disassociateFraudster(
            Consumer<DisassociateFraudsterRequest.Builder> disassociateFraudsterRequest) {
        return disassociateFraudster(DisassociateFraudsterRequest.builder().applyMutation(disassociateFraudsterRequest).build());
    }

    /**
     * <p>
     * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
     * </p>
     *
     * @param evaluateSessionRequest
     * @return A Java Future containing the result of the EvaluateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.EvaluateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/EvaluateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EvaluateSessionResponse> evaluateSession(EvaluateSessionRequest evaluateSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateSessionRequest.Builder} avoiding the need
     * to create one manually via {@link EvaluateSessionRequest#builder()}
     * </p>
     *
     * @param evaluateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.EvaluateSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EvaluateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.EvaluateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/EvaluateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EvaluateSessionResponse> evaluateSession(
            Consumer<EvaluateSessionRequest.Builder> evaluateSessionRequest) {
        return evaluateSession(EvaluateSessionRequest.builder().applyMutation(evaluateSessionRequest).build());
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        return new ListDomainsPublisher(this, listDomainsRequest);
    }

    /**
     * <p>
     * Lists all the domains in the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.voiceid.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     * @return A Java Future containing the result of the ListFraudsterRegistrationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFraudsterRegistrationJobsResponse> listFraudsterRegistrationJobs(
            ListFraudsterRegistrationJobsRequest listFraudsterRegistrationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFraudsterRegistrationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFraudsterRegistrationJobsRequest#builder()}
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFraudsterRegistrationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFraudsterRegistrationJobsResponse> listFraudsterRegistrationJobs(
            Consumer<ListFraudsterRegistrationJobsRequest.Builder> listFraudsterRegistrationJobsRequest) {
        return listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest.builder()
                .applyMutation(listFraudsterRegistrationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsPublisher publisher = client.listFraudsterRegistrationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsPublisher publisher = client.listFraudsterRegistrationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFraudsterRegistrationJobsPublisher listFraudsterRegistrationJobsPaginator(
            ListFraudsterRegistrationJobsRequest listFraudsterRegistrationJobsRequest) {
        return new ListFraudsterRegistrationJobsPublisher(this, listFraudsterRegistrationJobsRequest);
    }

    /**
     * <p>
     * Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsPublisher publisher = client.listFraudsterRegistrationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudsterRegistrationJobsPublisher publisher = client.listFraudsterRegistrationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFraudsterRegistrationJobs(software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFraudsterRegistrationJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFraudsterRegistrationJobsRequest#builder()}
     * </p>
     *
     * @param listFraudsterRegistrationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsterRegistrationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFraudsterRegistrationJobsPublisher listFraudsterRegistrationJobsPaginator(
            Consumer<ListFraudsterRegistrationJobsRequest.Builder> listFraudsterRegistrationJobsRequest) {
        return listFraudsterRegistrationJobsPaginator(ListFraudsterRegistrationJobsRequest.builder()
                .applyMutation(listFraudsterRegistrationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all fraudsters in a specified watchlist or domain.
     * </p>
     *
     * @param listFraudstersRequest
     * @return A Java Future containing the result of the ListFraudsters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFraudstersResponse> listFraudsters(ListFraudstersRequest listFraudstersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all fraudsters in a specified watchlist or domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFraudstersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFraudstersRequest#builder()}
     * </p>
     *
     * @param listFraudstersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFraudsters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFraudstersResponse> listFraudsters(Consumer<ListFraudstersRequest.Builder> listFraudstersRequest) {
        return listFraudsters(ListFraudstersRequest.builder().applyMutation(listFraudstersRequest).build());
    }

    /**
     * <p>
     * Lists all fraudsters in a specified watchlist or domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFraudsters(software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudstersPublisher publisher = client.listFraudstersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudstersPublisher publisher = client.listFraudstersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFraudsters(software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest)} operation.</b>
     * </p>
     *
     * @param listFraudstersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFraudstersPublisher listFraudstersPaginator(ListFraudstersRequest listFraudstersRequest) {
        return new ListFraudstersPublisher(this, listFraudstersRequest);
    }

    /**
     * <p>
     * Lists all fraudsters in a specified watchlist or domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFraudsters(software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudstersPublisher publisher = client.listFraudstersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListFraudstersPublisher publisher = client.listFraudstersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFraudsters(software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFraudstersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFraudstersRequest#builder()}
     * </p>
     *
     * @param listFraudstersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListFraudsters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFraudstersPublisher listFraudstersPaginator(Consumer<ListFraudstersRequest.Builder> listFraudstersRequest) {
        return listFraudstersPaginator(ListFraudstersRequest.builder().applyMutation(listFraudstersRequest).build());
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     * @return A Java Future containing the result of the ListSpeakerEnrollmentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSpeakerEnrollmentJobsResponse> listSpeakerEnrollmentJobs(
            ListSpeakerEnrollmentJobsRequest listSpeakerEnrollmentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakerEnrollmentJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSpeakerEnrollmentJobsRequest#builder()}
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSpeakerEnrollmentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSpeakerEnrollmentJobsResponse> listSpeakerEnrollmentJobs(
            Consumer<ListSpeakerEnrollmentJobsRequest.Builder> listSpeakerEnrollmentJobsRequest) {
        return listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest.builder()
                .applyMutation(listSpeakerEnrollmentJobsRequest).build());
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsPublisher publisher = client.listSpeakerEnrollmentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsPublisher publisher = client.listSpeakerEnrollmentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeakerEnrollmentJobsPublisher listSpeakerEnrollmentJobsPaginator(
            ListSpeakerEnrollmentJobsRequest listSpeakerEnrollmentJobsRequest) {
        return new ListSpeakerEnrollmentJobsPublisher(this, listSpeakerEnrollmentJobsRequest);
    }

    /**
     * <p>
     * Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
     * <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsPublisher publisher = client.listSpeakerEnrollmentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakerEnrollmentJobsPublisher publisher = client.listSpeakerEnrollmentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakerEnrollmentJobs(software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakerEnrollmentJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSpeakerEnrollmentJobsRequest#builder()}
     * </p>
     *
     * @param listSpeakerEnrollmentJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakerEnrollmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeakerEnrollmentJobsPublisher listSpeakerEnrollmentJobsPaginator(
            Consumer<ListSpeakerEnrollmentJobsRequest.Builder> listSpeakerEnrollmentJobsRequest) {
        return listSpeakerEnrollmentJobsPaginator(ListSpeakerEnrollmentJobsRequest.builder()
                .applyMutation(listSpeakerEnrollmentJobsRequest).build());
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     *
     * @param listSpeakersRequest
     * @return A Java Future containing the result of the ListSpeakers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSpeakersResponse> listSpeakers(ListSpeakersRequest listSpeakersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakersRequest.Builder} avoiding the need to
     * create one manually via {@link ListSpeakersRequest#builder()}
     * </p>
     *
     * @param listSpeakersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSpeakers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSpeakersResponse> listSpeakers(Consumer<ListSpeakersRequest.Builder> listSpeakersRequest) {
        return listSpeakers(ListSpeakersRequest.builder().applyMutation(listSpeakersRequest).build());
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersPublisher publisher = client.listSpeakersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersPublisher publisher = client.listSpeakersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)} operation.</b>
     * </p>
     *
     * @param listSpeakersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpeakersPublisher listSpeakersPaginator(ListSpeakersRequest listSpeakersRequest) {
        return new ListSpeakersPublisher(this, listSpeakersRequest);
    }

    /**
     * <p>
     * Lists all speakers in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersPublisher publisher = client.listSpeakersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListSpeakersPublisher publisher = client.listSpeakersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeakers(software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeakersRequest.Builder} avoiding the need to
     * create one manually via {@link ListSpeakersRequest#builder()}
     * </p>
     *
     * @param listSpeakersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListSpeakers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpeakersPublisher listSpeakersPaginator(Consumer<ListSpeakersRequest.Builder> listSpeakersRequest) {
        return listSpeakersPaginator(ListSpeakersRequest.builder().applyMutation(listSpeakersRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a specified Voice ID resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a specified Voice ID resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all watchlists in a specified domain.
     * </p>
     *
     * @param listWatchlistsRequest
     * @return A Java Future containing the result of the ListWatchlists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListWatchlists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListWatchlists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWatchlistsResponse> listWatchlists(ListWatchlistsRequest listWatchlistsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all watchlists in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWatchlistsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWatchlistsRequest#builder()}
     * </p>
     *
     * @param listWatchlistsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWatchlists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListWatchlists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListWatchlists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWatchlistsResponse> listWatchlists(Consumer<ListWatchlistsRequest.Builder> listWatchlistsRequest) {
        return listWatchlists(ListWatchlistsRequest.builder().applyMutation(listWatchlistsRequest).build());
    }

    /**
     * <p>
     * Lists all watchlists in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWatchlists(software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListWatchlistsPublisher publisher = client.listWatchlistsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListWatchlistsPublisher publisher = client.listWatchlistsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWatchlists(software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest)} operation.</b>
     * </p>
     *
     * @param listWatchlistsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListWatchlists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListWatchlists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWatchlistsPublisher listWatchlistsPaginator(ListWatchlistsRequest listWatchlistsRequest) {
        return new ListWatchlistsPublisher(this, listWatchlistsRequest);
    }

    /**
     * <p>
     * Lists all watchlists in a specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWatchlists(software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListWatchlistsPublisher publisher = client.listWatchlistsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.voiceid.paginators.ListWatchlistsPublisher publisher = client.listWatchlistsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWatchlists(software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWatchlistsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWatchlistsRequest#builder()}
     * </p>
     *
     * @param listWatchlistsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.ListWatchlists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListWatchlists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWatchlistsPublisher listWatchlistsPaginator(Consumer<ListWatchlistsRequest.Builder> listWatchlistsRequest) {
        return listWatchlistsPaginator(ListWatchlistsRequest.builder().applyMutation(listWatchlistsRequest).build());
    }

    /**
     * <p>
     * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in
     * Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their
     * existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are
     * rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
     * </p>
     *
     * @param optOutSpeakerRequest
     * @return A Java Future containing the result of the OptOutSpeaker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.OptOutSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OptOutSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<OptOutSpeakerResponse> optOutSpeaker(OptOutSpeakerRequest optOutSpeakerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in
     * Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their
     * existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are
     * rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OptOutSpeakerRequest.Builder} avoiding the need to
     * create one manually via {@link OptOutSpeakerRequest#builder()}
     * </p>
     *
     * @param optOutSpeakerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.OptOutSpeakerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the OptOutSpeaker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.OptOutSpeaker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OptOutSpeaker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<OptOutSpeakerResponse> optOutSpeaker(Consumer<OptOutSpeakerRequest.Builder> optOutSpeakerRequest) {
        return optOutSpeaker(OptOutSpeakerRequest.builder().applyMutation(optOutSpeakerRequest).build());
    }

    /**
     * <p>
     * Starts a new batch fraudster registration job using provided details.
     * </p>
     *
     * @param startFraudsterRegistrationJobRequest
     * @return A Java Future containing the result of the StartFraudsterRegistrationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.StartFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartFraudsterRegistrationJobResponse> startFraudsterRegistrationJob(
            StartFraudsterRegistrationJobRequest startFraudsterRegistrationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new batch fraudster registration job using provided details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFraudsterRegistrationJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartFraudsterRegistrationJobRequest#builder()}
     * </p>
     *
     * @param startFraudsterRegistrationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartFraudsterRegistrationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.StartFraudsterRegistrationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartFraudsterRegistrationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartFraudsterRegistrationJobResponse> startFraudsterRegistrationJob(
            Consumer<StartFraudsterRegistrationJobRequest.Builder> startFraudsterRegistrationJobRequest) {
        return startFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest.builder()
                .applyMutation(startFraudsterRegistrationJobRequest).build());
    }

    /**
     * <p>
     * Starts a new batch speaker enrollment job using specified details.
     * </p>
     *
     * @param startSpeakerEnrollmentJobRequest
     * @return A Java Future containing the result of the StartSpeakerEnrollmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.StartSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSpeakerEnrollmentJobResponse> startSpeakerEnrollmentJob(
            StartSpeakerEnrollmentJobRequest startSpeakerEnrollmentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new batch speaker enrollment job using specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSpeakerEnrollmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSpeakerEnrollmentJobRequest#builder()}
     * </p>
     *
     * @param startSpeakerEnrollmentJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSpeakerEnrollmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request exceeded the service quota. Refer to <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas"
     *         >Voice ID Service Quotas</a> and try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.StartSpeakerEnrollmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartSpeakerEnrollmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSpeakerEnrollmentJobResponse> startSpeakerEnrollmentJob(
            Consumer<StartSpeakerEnrollmentJobRequest.Builder> startSpeakerEnrollmentJobRequest) {
        return startSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest.builder()
                .applyMutation(startSpeakerEnrollmentJobRequest).build());
    }

    /**
     * <p>
     * Tags a Voice ID resource with the provided list of tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a Voice ID resource with the provided list of tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from a specified Amazon Connect Voice ID resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from a specified Amazon Connect Voice ID resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an
     * optional field, such as 'Description' is not provided, it is removed from the domain.
     * </p>
     *
     * @param updateDomainRequest
     * @return A Java Future containing the result of the UpdateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDomainResponse> updateDomain(UpdateDomainRequest updateDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an
     * optional field, such as 'Description' is not provided, it is removed from the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDomainRequest#builder()}
     * </p>
     *
     * @param updateDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.UpdateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDomainResponse> updateDomain(Consumer<UpdateDomainRequest.Builder> updateDomainRequest) {
        return updateDomain(UpdateDomainRequest.builder().applyMutation(updateDomainRequest).build());
    }

    /**
     * <p>
     * Updates the specified watchlist. Every domain has a default watchlist which cannot be updated.
     * </p>
     *
     * @param updateWatchlistRequest
     * @return A Java Future containing the result of the UpdateWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.UpdateWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateWatchlist" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWatchlistResponse> updateWatchlist(UpdateWatchlistRequest updateWatchlistRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified watchlist. Every domain has a default watchlist which cannot be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWatchlistRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWatchlistRequest#builder()}
     * </p>
     *
     * @param updateWatchlistRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.voiceid.model.UpdateWatchlistRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWatchlist operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource cannot be found. Check the <code>ResourceType</code>
     *         and error message for more details.</li>
     *         <li>ValidationException The request failed one or more validations; check the error message for more
     *         details.</li>
     *         <li>ConflictException The request failed due to a conflict. Check the <code>ConflictType</code> and error
     *         message for more details.</li>
     *         <li>InternalServerException The request failed due to an unknown error on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please slow down your request
     *         rate. Refer to <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"
     *         > Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action. Check the error
     *         message and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VoiceIdException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VoiceIdAsyncClient.UpdateWatchlist
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateWatchlist" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWatchlistResponse> updateWatchlist(
            Consumer<UpdateWatchlistRequest.Builder> updateWatchlistRequest) {
        return updateWatchlist(UpdateWatchlistRequest.builder().applyMutation(updateWatchlistRequest).build());
    }

    @Override
    default VoiceIdServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link VoiceIdAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static VoiceIdAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link VoiceIdAsyncClient}.
     */
    static VoiceIdAsyncClientBuilder builder() {
        return new DefaultVoiceIdAsyncClientBuilder();
    }
}
