/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the completion progress for a batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobProgress implements SdkPojo, Serializable, ToCopyableBuilder<JobProgress.Builder, JobProgress> {
    private static final SdkField<Integer> PERCENT_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentComplete").getter(getter(JobProgress::percentComplete)).setter(setter(Builder::percentComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentComplete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_COMPLETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer percentComplete;

    private JobProgress(BuilderImpl builder) {
        this.percentComplete = builder.percentComplete;
    }

    /**
     * <p>
     * Shows the completed percentage of enrollment or registration requests listed in the input file.
     * </p>
     * 
     * @return Shows the completed percentage of enrollment or registration requests listed in the input file.
     */
    public final Integer percentComplete() {
        return percentComplete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentComplete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProgress)) {
            return false;
        }
        JobProgress other = (JobProgress) obj;
        return Objects.equals(percentComplete(), other.percentComplete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobProgress").add("PercentComplete", percentComplete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentComplete":
            return Optional.ofNullable(clazz.cast(percentComplete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PercentComplete", PERCENT_COMPLETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobProgress, T> g) {
        return obj -> g.apply((JobProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobProgress> {
        /**
         * <p>
         * Shows the completed percentage of enrollment or registration requests listed in the input file.
         * </p>
         * 
         * @param percentComplete
         *        Shows the completed percentage of enrollment or registration requests listed in the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentComplete(Integer percentComplete);
    }

    static final class BuilderImpl implements Builder {
        private Integer percentComplete;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProgress model) {
            percentComplete(model.percentComplete);
        }

        public final Integer getPercentComplete() {
            return percentComplete;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        @Override
        public JobProgress build() {
            return new JobProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
