/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceSpoofingRisk implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceSpoofingRisk.Builder, VoiceSpoofingRisk> {
    private static final SdkField<Integer> RISK_SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RiskScore").getter(getter(VoiceSpoofingRisk::riskScore)).setter(setter(Builder::riskScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer riskScore;

    private VoiceSpoofingRisk(BuilderImpl builder) {
        this.riskScore = builder.riskScore;
    }

    /**
     * <p>
     * The score indicating the likelihood of speaker’s voice being spoofed.
     * </p>
     * 
     * @return The score indicating the likelihood of speaker’s voice being spoofed.
     */
    public final Integer riskScore() {
        return riskScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(riskScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceSpoofingRisk)) {
            return false;
        }
        VoiceSpoofingRisk other = (VoiceSpoofingRisk) obj;
        return Objects.equals(riskScore(), other.riskScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceSpoofingRisk").add("RiskScore", riskScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RiskScore":
            return Optional.ofNullable(clazz.cast(riskScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RiskScore", RISK_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceSpoofingRisk, T> g) {
        return obj -> g.apply((VoiceSpoofingRisk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceSpoofingRisk> {
        /**
         * <p>
         * The score indicating the likelihood of speaker’s voice being spoofed.
         * </p>
         * 
         * @param riskScore
         *        The score indicating the likelihood of speaker’s voice being spoofed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskScore(Integer riskScore);
    }

    static final class BuilderImpl implements Builder {
        private Integer riskScore;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceSpoofingRisk model) {
            riskScore(model.riskScore);
        }

        public final Integer getRiskScore() {
            return riskScore;
        }

        public final void setRiskScore(Integer riskScore) {
            this.riskScore = riskScore;
        }

        @Override
        public final Builder riskScore(Integer riskScore) {
            this.riskScore = riskScore;
            return this;
        }

        @Override
        public VoiceSpoofingRisk build() {
            return new VoiceSpoofingRisk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
