/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all the information about a watchlist.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Watchlist implements SdkPojo, Serializable, ToCopyableBuilder<Watchlist.Builder, Watchlist> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Watchlist::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Boolean> DEFAULT_WATCHLIST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultWatchlist").getter(getter(Watchlist::defaultWatchlist)).setter(setter(Builder::defaultWatchlist))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultWatchlist").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Watchlist::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(Watchlist::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Watchlist::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(Watchlist::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> WATCHLIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WatchlistId").getter(getter(Watchlist::watchlistId)).setter(setter(Builder::watchlistId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEFAULT_WATCHLIST_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, NAME_FIELD, UPDATED_AT_FIELD, WATCHLIST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Boolean defaultWatchlist;

    private final String description;

    private final String domainId;

    private final String name;

    private final Instant updatedAt;

    private final String watchlistId;

    private Watchlist(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.defaultWatchlist = builder.defaultWatchlist;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.name = builder.name;
        this.updatedAt = builder.updatedAt;
        this.watchlistId = builder.watchlistId;
    }

    /**
     * <p>
     * The timestamp of when the watchlist was created.
     * </p>
     * 
     * @return The timestamp of when the watchlist was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Whether the specified watchlist is the default watchlist of a domain.
     * </p>
     * 
     * @return Whether the specified watchlist is the default watchlist of a domain.
     */
    public final Boolean defaultWatchlist() {
        return defaultWatchlist;
    }

    /**
     * <p>
     * The description of the watchlist.
     * </p>
     * 
     * @return The description of the watchlist.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the domain that contains the watchlist.
     * </p>
     * 
     * @return The identifier of the domain that contains the watchlist.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name for the watchlist.
     * </p>
     * 
     * @return The name for the watchlist.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The timestamp of when the watchlist was updated.
     * </p>
     * 
     * @return The timestamp of when the watchlist was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The identifier of the watchlist.
     * </p>
     * 
     * @return The identifier of the watchlist.
     */
    public final String watchlistId() {
        return watchlistId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(defaultWatchlist());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(watchlistId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Watchlist)) {
            return false;
        }
        Watchlist other = (Watchlist) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(defaultWatchlist(), other.defaultWatchlist())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(name(), other.name()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(watchlistId(), other.watchlistId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Watchlist").add("CreatedAt", createdAt()).add("DefaultWatchlist", defaultWatchlist())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("UpdatedAt", updatedAt())
                .add("WatchlistId", watchlistId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DefaultWatchlist":
            return Optional.ofNullable(clazz.cast(defaultWatchlist()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "WatchlistId":
            return Optional.ofNullable(clazz.cast(watchlistId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DefaultWatchlist", DEFAULT_WATCHLIST_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("WatchlistId", WATCHLIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Watchlist, T> g) {
        return obj -> g.apply((Watchlist) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Watchlist> {
        /**
         * <p>
         * The timestamp of when the watchlist was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the watchlist was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Whether the specified watchlist is the default watchlist of a domain.
         * </p>
         * 
         * @param defaultWatchlist
         *        Whether the specified watchlist is the default watchlist of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultWatchlist(Boolean defaultWatchlist);

        /**
         * <p>
         * The description of the watchlist.
         * </p>
         * 
         * @param description
         *        The description of the watchlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the domain that contains the watchlist.
         * </p>
         * 
         * @param domainId
         *        The identifier of the domain that contains the watchlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name for the watchlist.
         * </p>
         * 
         * @param name
         *        The name for the watchlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The timestamp of when the watchlist was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the watchlist was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The identifier of the watchlist.
         * </p>
         * 
         * @param watchlistId
         *        The identifier of the watchlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchlistId(String watchlistId);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Boolean defaultWatchlist;

        private String description;

        private String domainId;

        private String name;

        private Instant updatedAt;

        private String watchlistId;

        private BuilderImpl() {
        }

        private BuilderImpl(Watchlist model) {
            createdAt(model.createdAt);
            defaultWatchlist(model.defaultWatchlist);
            description(model.description);
            domainId(model.domainId);
            name(model.name);
            updatedAt(model.updatedAt);
            watchlistId(model.watchlistId);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getDefaultWatchlist() {
            return defaultWatchlist;
        }

        public final void setDefaultWatchlist(Boolean defaultWatchlist) {
            this.defaultWatchlist = defaultWatchlist;
        }

        @Override
        public final Builder defaultWatchlist(Boolean defaultWatchlist) {
            this.defaultWatchlist = defaultWatchlist;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWatchlistId() {
            return watchlistId;
        }

        public final void setWatchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
        }

        @Override
        public final Builder watchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
            return this;
        }

        @Override
        public Watchlist build() {
            return new Watchlist(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
