/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.ServerSideEncryptionUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerSideEncryptionUpdateDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerSideEncryptionUpdateDetails> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ServerSideEncryptionUpdateDetails.getter(ServerSideEncryptionUpdateDetails::message)).setter(ServerSideEncryptionUpdateDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> OLD_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OldKmsKeyId").getter(ServerSideEncryptionUpdateDetails.getter(ServerSideEncryptionUpdateDetails::oldKmsKeyId)).setter(ServerSideEncryptionUpdateDetails.setter(Builder::oldKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldKmsKeyId").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(ServerSideEncryptionUpdateDetails.getter(ServerSideEncryptionUpdateDetails::updateStatusAsString)).setter(ServerSideEncryptionUpdateDetails.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, OLD_KMS_KEY_ID_FIELD, UPDATE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerSideEncryptionUpdateDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String oldKmsKeyId;
    private final String updateStatus;

    private ServerSideEncryptionUpdateDetails(BuilderImpl builder) {
        this.message = builder.message;
        this.oldKmsKeyId = builder.oldKmsKeyId;
        this.updateStatus = builder.updateStatus;
    }

    public final String message() {
        return this.message;
    }

    public final String oldKmsKeyId() {
        return this.oldKmsKeyId;
    }

    public final ServerSideEncryptionUpdateStatus updateStatus() {
        return ServerSideEncryptionUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerSideEncryptionUpdateDetails)) {
            return false;
        }
        ServerSideEncryptionUpdateDetails other = (ServerSideEncryptionUpdateDetails)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.oldKmsKeyId(), other.oldKmsKeyId()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServerSideEncryptionUpdateDetails").add("Message", (Object)this.message()).add("OldKmsKeyId", (Object)this.oldKmsKeyId()).add("UpdateStatus", (Object)this.updateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "OldKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.oldKmsKeyId()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Message", MESSAGE_FIELD);
        map.put("OldKmsKeyId", OLD_KMS_KEY_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerSideEncryptionUpdateDetails, T> g) {
        return obj -> g.apply((ServerSideEncryptionUpdateDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String oldKmsKeyId;
        private String updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerSideEncryptionUpdateDetails model) {
            this.message(model.message);
            this.oldKmsKeyId(model.oldKmsKeyId);
            this.updateStatus(model.updateStatus);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getOldKmsKeyId() {
            return this.oldKmsKeyId;
        }

        public final void setOldKmsKeyId(String oldKmsKeyId) {
            this.oldKmsKeyId = oldKmsKeyId;
        }

        @Override
        public final Builder oldKmsKeyId(String oldKmsKeyId) {
            this.oldKmsKeyId = oldKmsKeyId;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ServerSideEncryptionUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public ServerSideEncryptionUpdateDetails build() {
            return new ServerSideEncryptionUpdateDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerSideEncryptionUpdateDetails> {
        public Builder message(String var1);

        public Builder oldKmsKeyId(String var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(ServerSideEncryptionUpdateStatus var1);
    }
}

