/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateRuleRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<BatchUpdateRuleRequest.Builder, BatchUpdateRuleRequest> {
    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listenerIdentifier").getter(getter(BatchUpdateRuleRequest::listenerIdentifier))
            .setter(setter(Builder::listenerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()).build();

    private static final SdkField<List<RuleUpdate>> RULES_FIELD = SdkField
            .<List<RuleUpdate>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(BatchUpdateRuleRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIdentifier").getter(getter(BatchUpdateRuleRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_IDENTIFIER_FIELD,
            RULES_FIELD, SERVICE_IDENTIFIER_FIELD));

    private final String listenerIdentifier;

    private final List<RuleUpdate> rules;

    private final String serviceIdentifier;

    private BatchUpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.listenerIdentifier = builder.listenerIdentifier;
        this.rules = builder.rules;
        this.serviceIdentifier = builder.serviceIdentifier;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerIdentifier() {
        return listenerIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules for the specified listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules for the specified listener.
     */
    public final List<RuleUpdate> rules() {
        return rules;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRuleRequest)) {
            return false;
        }
        BatchUpdateRuleRequest other = (BatchUpdateRuleRequest) obj;
        return Objects.equals(listenerIdentifier(), other.listenerIdentifier()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && Objects.equals(serviceIdentifier(), other.serviceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateRuleRequest").add("ListenerIdentifier", listenerIdentifier())
                .add("Rules", hasRules() ? rules() : null).add("ServiceIdentifier", serviceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "listenerIdentifier":
            return Optional.ofNullable(clazz.cast(listenerIdentifier()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "serviceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRuleRequest, T> g) {
        return obj -> g.apply((BatchUpdateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateRuleRequest> {
        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerIdentifier
         *        The ID or Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerIdentifier(String listenerIdentifier);

        /**
         * <p>
         * The rules for the specified listener.
         * </p>
         * 
         * @param rules
         *        The rules for the specified listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RuleUpdate> rules);

        /**
         * <p>
         * The rules for the specified listener.
         * </p>
         * 
         * @param rules
         *        The rules for the specified listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RuleUpdate... rules);

        /**
         * <p>
         * The rules for the specified listener.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.vpclattice.model.RuleUpdate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.vpclattice.model.RuleUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.vpclattice.model.RuleUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<RuleUpdate>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.vpclattice.model.RuleUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<RuleUpdate>)
         */
        Builder rules(Consumer<RuleUpdate.Builder>... rules);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID or Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String listenerIdentifier;

        private List<RuleUpdate> rules = DefaultSdkAutoConstructList.getInstance();

        private String serviceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRuleRequest model) {
            super(model);
            listenerIdentifier(model.listenerIdentifier);
            rules(model.rules);
            serviceIdentifier(model.serviceIdentifier);
        }

        public final String getListenerIdentifier() {
            return listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final List<RuleUpdate.Builder> getRules() {
            List<RuleUpdate.Builder> result = RuleUpdateListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RuleUpdate.BuilderImpl> rules) {
            this.rules = RuleUpdateListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RuleUpdate> rules) {
            this.rules = RuleUpdateListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleUpdate... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleUpdate.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RuleUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateRuleRequest build() {
            return new BatchUpdateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
