/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkVpcAssociationSummary;

public class ListServiceNetworkVpcAssociationsPublisher
implements SdkPublisher<ListServiceNetworkVpcAssociationsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListServiceNetworkVpcAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceNetworkVpcAssociationsPublisher(VpcLatticeAsyncClient client, ListServiceNetworkVpcAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceNetworkVpcAssociationsPublisher(VpcLatticeAsyncClient client, ListServiceNetworkVpcAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceNetworkVpcAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceNetworkVpcAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceNetworkVpcAssociationSummary> items() {
        Function<ListServiceNetworkVpcAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceNetworkVpcAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceNetworkVpcAssociationsResponseFetcher
    implements AsyncPageFetcher<ListServiceNetworkVpcAssociationsResponse> {
        private ListServiceNetworkVpcAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkVpcAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceNetworkVpcAssociationsResponse> nextPage(ListServiceNetworkVpcAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkVpcAssociationsPublisher.this.client.listServiceNetworkVpcAssociations(ListServiceNetworkVpcAssociationsPublisher.this.firstRequest);
            }
            return ListServiceNetworkVpcAssociationsPublisher.this.client.listServiceNetworkVpcAssociations((ListServiceNetworkVpcAssociationsRequest)((Object)ListServiceNetworkVpcAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

