/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkSummary;

public class ListServiceNetworksPublisher
implements SdkPublisher<ListServiceNetworksResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListServiceNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceNetworksPublisher(VpcLatticeAsyncClient client, ListServiceNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceNetworksPublisher(VpcLatticeAsyncClient client, ListServiceNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceNetworkSummary> items() {
        Function<ListServiceNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceNetworksResponseFetcher
    implements AsyncPageFetcher<ListServiceNetworksResponse> {
        private ListServiceNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceNetworksResponse> nextPage(ListServiceNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworksPublisher.this.client.listServiceNetworks(ListServiceNetworksPublisher.this.firstRequest);
            }
            return ListServiceNetworksPublisher.this.client.listServiceNetworks((ListServiceNetworksRequest)((Object)ListServiceNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

