/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a successful rule update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleUpdateSuccess implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleUpdateSuccess.Builder, RuleUpdateSuccess> {
    private static final SdkField<RuleAction> ACTION_FIELD = SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(RuleUpdateSuccess::action)).setter(setter(Builder::action))
            .constructor(RuleAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RuleUpdateSuccess::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RuleUpdateSuccess::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDefault").getter(getter(RuleUpdateSuccess::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefault").build()).build();

    private static final SdkField<RuleMatch> MATCH_FIELD = SdkField.<RuleMatch> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(RuleUpdateSuccess::match)).setter(setter(Builder::match))
            .constructor(RuleMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RuleUpdateSuccess::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(RuleUpdateSuccess::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD,
            ID_FIELD, IS_DEFAULT_FIELD, MATCH_FIELD, NAME_FIELD, PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final RuleAction action;

    private final String arn;

    private final String id;

    private final Boolean isDefault;

    private final RuleMatch match;

    private final String name;

    private final Integer priority;

    private RuleUpdateSuccess(BuilderImpl builder) {
        this.action = builder.action;
        this.arn = builder.arn;
        this.id = builder.id;
        this.isDefault = builder.isDefault;
        this.match = builder.match;
        this.name = builder.name;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The action for the default rule.
     * </p>
     * 
     * @return The action for the default rule.
     */
    public final RuleAction action() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the listener.
     * </p>
     * 
     * @return The ID of the listener.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Indicates whether this is the default rule.
     * </p>
     * 
     * @return Indicates whether this is the default rule.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The rule match.
     * </p>
     * 
     * @return The rule match.
     */
    public final RuleMatch match() {
        return match;
    }

    /**
     * <p>
     * The name of the listener.
     * </p>
     * 
     * @return The name of the listener.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The rule priority.
     * </p>
     * 
     * @return The rule priority.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleUpdateSuccess)) {
            return false;
        }
        RuleUpdateSuccess other = (RuleUpdateSuccess) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(match(), other.match())
                && Objects.equals(name(), other.name()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleUpdateSuccess").add("Action", action()).add("Arn", arn()).add("Id", id())
                .add("IsDefault", isDefault()).add("Match", match()).add("Name", name()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "isDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleUpdateSuccess, T> g) {
        return obj -> g.apply((RuleUpdateSuccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleUpdateSuccess> {
        /**
         * <p>
         * The action for the default rule.
         * </p>
         * 
         * @param action
         *        The action for the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * The action for the default rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleAction.Builder} avoiding the need to
         * create one manually via {@link RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleAction.Builder#build()} is called immediately and its result
         * is passed to {@link #action(RuleAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(RuleAction)
         */
        default Builder action(Consumer<RuleAction.Builder> action) {
            return action(RuleAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the listener.
         * </p>
         * 
         * @param id
         *        The ID of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Indicates whether this is the default rule.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether this is the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The rule match.
         * </p>
         * 
         * @param match
         *        The rule match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(RuleMatch match);

        /**
         * <p>
         * The rule match.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleMatch.Builder} avoiding the need to
         * create one manually via {@link RuleMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleMatch.Builder#build()} is called immediately and its result
         * is passed to {@link #match(RuleMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link RuleMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(RuleMatch)
         */
        default Builder match(Consumer<RuleMatch.Builder> match) {
            return match(RuleMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * The name of the listener.
         * </p>
         * 
         * @param name
         *        The name of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The rule priority.
         * </p>
         * 
         * @param priority
         *        The rule priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private RuleAction action;

        private String arn;

        private String id;

        private Boolean isDefault;

        private RuleMatch match;

        private String name;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleUpdateSuccess model) {
            action(model.action);
            arn(model.arn);
            id(model.id);
            isDefault(model.isDefault);
            match(model.match);
            name(model.name);
            priority(model.priority);
        }

        public final RuleAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(RuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action = action;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final RuleMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(RuleMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(RuleMatch match) {
            this.match = match;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public RuleUpdateSuccess build() {
            return new RuleUpdateSuccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
