/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary;

public class ListServiceNetworkServiceAssociationsIterable
implements SdkIterable<ListServiceNetworkServiceAssociationsResponse> {
    private final VpcLatticeClient client;
    private final ListServiceNetworkServiceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceNetworkServiceAssociationsIterable(VpcLatticeClient client, ListServiceNetworkServiceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceNetworkServiceAssociationsResponseFetcher();
    }

    public Iterator<ListServiceNetworkServiceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceNetworkServiceAssociationSummary> items() {
        Function<ListServiceNetworkServiceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceNetworkServiceAssociationsResponseFetcher
    implements SyncPageFetcher<ListServiceNetworkServiceAssociationsResponse> {
        private ListServiceNetworkServiceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkServiceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceNetworkServiceAssociationsResponse nextPage(ListServiceNetworkServiceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkServiceAssociationsIterable.this.client.listServiceNetworkServiceAssociations(ListServiceNetworkServiceAssociationsIterable.this.firstRequest);
            }
            return ListServiceNetworkServiceAssociationsIterable.this.client.listServiceNetworkServiceAssociations((ListServiceNetworkServiceAssociationsRequest)((Object)ListServiceNetworkServiceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

