/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.DnsEntry;
import software.amazon.awssdk.services.vpclattice.model.ServiceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceSummary.getter(ServiceSummary::arn)).setter(ServiceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceSummary.getter(ServiceSummary::createdAt)).setter(ServiceSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(ServiceSummary.getter(ServiceSummary::customDomainName)).setter(ServiceSummary.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsEntry").getter(ServiceSummary.getter(ServiceSummary::dnsEntry)).setter(ServiceSummary.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServiceSummary.getter(ServiceSummary::id)).setter(ServiceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(ServiceSummary.getter(ServiceSummary::lastUpdatedAt)).setter(ServiceSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServiceSummary.getter(ServiceSummary::name)).setter(ServiceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceSummary.getter(ServiceSummary::statusAsString)).setter(ServiceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DNS_ENTRY_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String customDomainName;
    private final DnsEntry dnsEntry;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;

    private ServiceSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.customDomainName = builder.customDomainName;
        this.dnsEntry = builder.dnsEntry;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final ServiceStatus status() {
        return ServiceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CustomDomainName", (Object)this.customDomainName()).add("DnsEntry", (Object)this.dnsEntry()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "dnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSummary, T> g) {
        return obj -> g.apply((ServiceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String customDomainName;
        private DnsEntry dnsEntry;
        private String id;
        private Instant lastUpdatedAt;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.customDomainName(model.customDomainName);
            this.dnsEntry(model.dnsEntry);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ServiceSummary build() {
            return new ServiceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder customDomainName(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ServiceStatus var1);
    }
}

