/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServiceNetworkVpcAssociationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<DeleteServiceNetworkVpcAssociationResponse.Builder, DeleteServiceNetworkVpcAssociationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DeleteServiceNetworkVpcAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeleteServiceNetworkVpcAssociationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeleteServiceNetworkVpcAssociationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            STATUS_FIELD));

    private final String arn;

    private final String id;

    private final String status;

    private DeleteServiceNetworkVpcAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it
     * while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkVpcAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you
     *         retry it while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
     * @see ServiceNetworkVpcAssociationStatus
     */
    public final ServiceNetworkVpcAssociationStatus status() {
        return ServiceNetworkVpcAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it
     * while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkVpcAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you
     *         retry it while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
     * @see ServiceNetworkVpcAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceNetworkVpcAssociationResponse)) {
            return false;
        }
        DeleteServiceNetworkVpcAssociationResponse other = (DeleteServiceNetworkVpcAssociationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteServiceNetworkVpcAssociationResponse").add("Arn", arn()).add("Id", id())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceNetworkVpcAssociationResponse, T> g) {
        return obj -> g.apply((DeleteServiceNetworkVpcAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteServiceNetworkVpcAssociationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param id
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it
         * while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
         * </p>
         * 
         * @param status
         *        The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you
         *        retry it while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
         * @see ServiceNetworkVpcAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkVpcAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it
         * while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
         * </p>
         * 
         * @param status
         *        The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you
         *        retry it while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.
         * @see ServiceNetworkVpcAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkVpcAssociationStatus
         */
        Builder status(ServiceNetworkVpcAssociationStatus status);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceNetworkVpcAssociationResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkVpcAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteServiceNetworkVpcAssociationResponse build() {
            return new DeleteServiceNetworkVpcAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
