/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a forward action. You can use forward actions to route requests to one or more target groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForwardAction implements SdkPojo, Serializable, ToCopyableBuilder<ForwardAction.Builder, ForwardAction> {
    private static final SdkField<List<WeightedTargetGroup>> TARGET_GROUPS_FIELD = SdkField
            .<List<WeightedTargetGroup>> builder(MarshallingType.LIST)
            .memberName("targetGroups")
            .getter(getter(ForwardAction::targetGroups))
            .setter(setter(Builder::targetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WeightedTargetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(WeightedTargetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WeightedTargetGroup> targetGroups;

    private ForwardAction(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetGroups() {
        return targetGroups != null && !(targetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions,
     * you can assign a weight that controls the prioritization and selection of each target group. This means that
     * requests are distributed to individual target groups based on their weights. For example, if two target groups
     * have the same weight, each target group receives half of the traffic.
     * </p>
     * <p>
     * The default value is 1. This means that if only one target group is provided, there is no need to set the weight;
     * 100% of the traffic goes to that target group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetGroups} method.
     * </p>
     * 
     * @return The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward
     *         actions, you can assign a weight that controls the prioritization and selection of each target group.
     *         This means that requests are distributed to individual target groups based on their weights. For example,
     *         if two target groups have the same weight, each target group receives half of the traffic.</p>
     *         <p>
     *         The default value is 1. This means that if only one target group is provided, there is no need to set the
     *         weight; 100% of the traffic goes to that target group.
     */
    public final List<WeightedTargetGroup> targetGroups() {
        return targetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroups() ? targetGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardAction)) {
            return false;
        }
        ForwardAction other = (ForwardAction) obj;
        return hasTargetGroups() == other.hasTargetGroups() && Objects.equals(targetGroups(), other.targetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForwardAction").add("TargetGroups", hasTargetGroups() ? targetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetGroups":
            return Optional.ofNullable(clazz.cast(targetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForwardAction, T> g) {
        return obj -> g.apply((ForwardAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForwardAction> {
        /**
         * <p>
         * The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward
         * actions, you can assign a weight that controls the prioritization and selection of each target group. This
         * means that requests are distributed to individual target groups based on their weights. For example, if two
         * target groups have the same weight, each target group receives half of the traffic.
         * </p>
         * <p>
         * The default value is 1. This means that if only one target group is provided, there is no need to set the
         * weight; 100% of the traffic goes to that target group.
         * </p>
         * 
         * @param targetGroups
         *        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward
         *        actions, you can assign a weight that controls the prioritization and selection of each target group.
         *        This means that requests are distributed to individual target groups based on their weights. For
         *        example, if two target groups have the same weight, each target group receives half of the
         *        traffic.</p>
         *        <p>
         *        The default value is 1. This means that if only one target group is provided, there is no need to set
         *        the weight; 100% of the traffic goes to that target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(Collection<WeightedTargetGroup> targetGroups);

        /**
         * <p>
         * The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward
         * actions, you can assign a weight that controls the prioritization and selection of each target group. This
         * means that requests are distributed to individual target groups based on their weights. For example, if two
         * target groups have the same weight, each target group receives half of the traffic.
         * </p>
         * <p>
         * The default value is 1. This means that if only one target group is provided, there is no need to set the
         * weight; 100% of the traffic goes to that target group.
         * </p>
         * 
         * @param targetGroups
         *        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward
         *        actions, you can assign a weight that controls the prioritization and selection of each target group.
         *        This means that requests are distributed to individual target groups based on their weights. For
         *        example, if two target groups have the same weight, each target group receives half of the
         *        traffic.</p>
         *        <p>
         *        The default value is 1. This means that if only one target group is provided, there is no need to set
         *        the weight; 100% of the traffic goes to that target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(WeightedTargetGroup... targetGroups);

        /**
         * <p>
         * The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward
         * actions, you can assign a weight that controls the prioritization and selection of each target group. This
         * means that requests are distributed to individual target groups based on their weights. For example, if two
         * target groups have the same weight, each target group receives half of the traffic.
         * </p>
         * <p>
         * The default value is 1. This means that if only one target group is provided, there is no need to set the
         * weight; 100% of the traffic goes to that target group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #targetGroups(List<WeightedTargetGroup>)}.
         * 
         * @param targetGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.vpclattice.model.WeightedTargetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroups(java.util.Collection<WeightedTargetGroup>)
         */
        Builder targetGroups(Consumer<WeightedTargetGroup.Builder>... targetGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<WeightedTargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardAction model) {
            targetGroups(model.targetGroups);
        }

        public final List<WeightedTargetGroup.Builder> getTargetGroups() {
            List<WeightedTargetGroup.Builder> result = WeightedTargetGroupListCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<WeightedTargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = WeightedTargetGroupListCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<WeightedTargetGroup> targetGroups) {
            this.targetGroups = WeightedTargetGroupListCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(WeightedTargetGroup... targetGroups) {
            targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<WeightedTargetGroup.Builder>... targetGroups) {
            targetGroups(Stream.of(targetGroups).map(c -> WeightedTargetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ForwardAction build() {
            return new ForwardAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
