/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the conditions that can be applied when matching a path for incoming requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathMatch implements SdkPojo, Serializable, ToCopyableBuilder<PathMatch.Builder, PathMatch> {
    private static final SdkField<Boolean> CASE_SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("caseSensitive").getter(getter(PathMatch::caseSensitive)).setter(setter(Builder::caseSensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseSensitive").build()).build();

    private static final SdkField<PathMatchType> MATCH_FIELD = SdkField.<PathMatchType> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(PathMatch::match)).setter(setter(Builder::match))
            .constructor(PathMatchType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_SENSITIVE_FIELD,
            MATCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean caseSensitive;

    private final PathMatchType match;

    private PathMatch(BuilderImpl builder) {
        this.caseSensitive = builder.caseSensitive;
        this.match = builder.match;
    }

    /**
     * <p>
     * Indicates whether the match is case sensitive.
     * </p>
     * 
     * @return Indicates whether the match is case sensitive.
     */
    public final Boolean caseSensitive() {
        return caseSensitive;
    }

    /**
     * <p>
     * The type of path match.
     * </p>
     * 
     * @return The type of path match.
     */
    public final PathMatchType match() {
        return match;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseSensitive());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathMatch)) {
            return false;
        }
        PathMatch other = (PathMatch) obj;
        return Objects.equals(caseSensitive(), other.caseSensitive()) && Objects.equals(match(), other.match());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathMatch").add("CaseSensitive", caseSensitive()).add("Match", match()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseSensitive":
            return Optional.ofNullable(clazz.cast(caseSensitive()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathMatch, T> g) {
        return obj -> g.apply((PathMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathMatch> {
        /**
         * <p>
         * Indicates whether the match is case sensitive.
         * </p>
         * 
         * @param caseSensitive
         *        Indicates whether the match is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSensitive(Boolean caseSensitive);

        /**
         * <p>
         * The type of path match.
         * </p>
         * 
         * @param match
         *        The type of path match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(PathMatchType match);

        /**
         * <p>
         * The type of path match.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathMatchType.Builder} avoiding the need
         * to create one manually via {@link PathMatchType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathMatchType.Builder#build()} is called immediately and its
         * result is passed to {@link #match(PathMatchType)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link PathMatchType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(PathMatchType)
         */
        default Builder match(Consumer<PathMatchType.Builder> match) {
            return match(PathMatchType.builder().applyMutation(match).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean caseSensitive;

        private PathMatchType match;

        private BuilderImpl() {
        }

        private BuilderImpl(PathMatch model) {
            caseSensitive(model.caseSensitive);
            match(model.match);
        }

        public final Boolean getCaseSensitive() {
            return caseSensitive;
        }

        public final void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public final Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public final PathMatchType.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(PathMatchType.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(PathMatchType match) {
            this.match = match;
            return this;
        }

        @Override
        public PathMatch build() {
            return new PathMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
